# Especificaciones XML

## WSDL

El WSDL (*Web Service Description Language*) es un lenguaje basado en
XML para describir los servicios web, es decir, especifica la ubicación,
los datos que maneja y los métodos que soporta.\
\
Utiliza los siguientes elementos:

-   `portType`, operaciones que proporciona.
-   `message`, mensajes utilizados por el servicio web y datos que
    participan en las operaciones. Los apartados de los mensajes serían
    los parámetros de la llamada a la función\\método.
-   `types`, define tipos de datos utilizados, utilizando XML Schema.
-   `binding`, protocolo de comunicaciones. Define el formato del
    mensaje y el protocolo para cada puerto.

La estructura de un WSDL es la siguiente:

    <definitions>
      <types>
        ...
      </types>

      <message>
        ...
      </message>

      <portType>
        ...
      </portType>

      <binding>
        ...
      </binding>
    </definitions> 

Un ejemplo:

``` xml
<message name="obtTerminoDePet">
<part name="param" type="xs:string"/>
</message>
<message name="obtTerminoDeResp">
<part name="valor" type="xs:string"/>
</message>
<portType name="terminosDeDiccionario">
<operation name="obtTermino">
<input message="obtTerminoDePet"/>
<output message="obtTerminoDeResp"/>
</operation>
</portType>
```

Aquí vemos que se crea un puerto denominado \"terminosDeDiccionario\"
con un método llamado \"obtTermino\", este devuelve (output) un dato de
entrada \"obtTerminoDeResp\" y se le pasa un parámetro del tipo
\"obtTerminoDePet\". Estos dos tipos están definidos en el apartado de
`message`.\
\
Podríamos definir otros tipos de servicios web, por ejemplo, que sean
unidireccionales (sin parámetros de salida (o de retorno)), o que hagan
una petición sin enviar parámetros\...\
\
