# JSTL

-   Es un framework de etiquetas predefinidas para JSP.
-   Debemos descargarnos el archivo *taglibs* de jakarta. Una vez lo
    tengamos deberemos descomprimirlo y en la carpeta de nuestra
    aplicación **/WEB-INF** colocaremos los .tld, en **/WEB-INF/lib**
    deberemos colocar los .jar. De esa forma serán accesibles en todo el
    proyecto.
-   Para usarlas tendremos que hacer un include, ya sea en nuestro
    archivo de código .jsp o en el web.xml:

En nuestro código:

``` xml
<%@ taglib uri="http://jakarta.apache.org/taglibs/{library}" prefix="x" %>
<%@ taglib prefix="c" uri="/WEB-INF/c-rt.tld" %>
```

En el web.xml:

``` xml
<taglib>
  <taglib-uri>http://jakarta.apache.org/taglibs/{library}</taglib-uri>
  <taglib-location>/WEB-INF/{library}.tld</taglib-location>
</taglib>
```

-   Un ejemplo de uso básico es el siguiente:

``` xml
<%@ taglib prefix="c" uri="/WEB-INF/c-rt.tld" %>
<c:out value="hola" />
```

## Indice de etiquetas

-   **core:** Incluye tags de control de flujo tales como forEach,
    choose o if.
-   **format:** Incluye tags para formatear fechas y números
    (formatNumber, formatDate, parseNumber, parseDate\...) como textos
    en lenguajes específicos (message, setBundle, setLocale\...).
-   **sql:** Incluye tags para conexiones a bases de datos.
-   **functions:** Incluye funciones para el tratamiento de cadenas
    (split(), replace(), join(), trim()\...).
-   **xml:** Incluye tags para interpretar datos en formato xml.

## Incluir etiquetas

Podremos incluir etiquetas a nuestro .jsp o podremos incluirlas en
nuestro fichero *web.xml*, para que sean accesibles desde cualquier
parte de nuestra aplicación.

### Externas a nuestra aplicación

``` xml
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/fn" %>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
```

### Internas en nuestra aplicación

``` xml
<%@ taglib prefix="fmt" uri="/WEB-INF/fmt.tld" %>
<%@ taglib prefix="html" uri="/WEB-INF/struts-html-el.tld" %>
```

## Ejemplos de salida y control de código

Tendrás que hacer la siguiente inclusión:

``` xml
<%@ taglib prefix="c" uri="/WEB-INF/c-rt.tld" %>
```

### Definir y usar una variable

``` xml
<c:set var="car" value="renault" scope="page" />
${car}
```

### Mostrar valores

``` xml
<c:out value="coche"></c:out>
<c:out value="${car}" default="ferrari"></c:out>
<c:out value="${pageContext.request.method}" />
<c:out value="${param.msg}" />
```

### Ifs

``` xml
<c:if test="${1==1}">
  cierto!!!
</c:if>

<c:if test="$(1==1)" var="result" />
<c:out value="${result}" />
```

### Control de errores

``` xml
<c:catch var="exc">
${10/0}
<c:if test="${exc!=null}">
    Error: <c:out value="${exc}" />
</c:if>
</c:catch>
```

### If\...Else

``` xml
<c:choose>
    <c:when test="${param.number == 1}">Solo uno</c:when>
    <c:otherwise>Varios</c:otherwise>
</c:choose>
```

## Bucles

### forEach

Para mostrar el uso del forEach añadiremos este código al servlet, al
llamar al servlet se enviará a nuestra página jsp un array de integers:

``` java
protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    java.util.ArrayList<Integer> array = new ArrayList<Integer>();
    java.util.Random rnd = new Random();
    for (int i=0; i<20; i++) 
        array.add(rnd.nextInt(100));
    request.setAttribute("myArray", array);
    request.getRequestDispatcher("pp.jsp").forward(request, response);
}
```

``` xml
<c:forEach begin="0" end="10" step="1" items="${myArray}" var="i">
    <c:out value="${i}"></c:out>
</c:forEach>
```

``` xml
<c:forEach items="${myArray}" var="i" varStatus="stat">
    <jsp:useBean id="stat" type="javax.servlet.jsp.jstl.core.LoopTagStatus" />
    <c:if test="${stat.count %2 == 0}"><font color="grey"></c:if>
    <c:if test="${stat.count %2 != 0}"><font color="black"></c:if>
    <c:out value="${i}"></c:out>
    </font>
</c:forEach>
```

Se ha realizado una conversión implícita del objeto stat que en el bucle
es un *javax.servlet.jsp.jstl.core.LoopTagSupport* y nosotros, mediante
el atributo type, lo pasamos a
*javax.servlet.jsp.jstl.core.LoopTagStatus*. De este objeto contiene
varios métodos que pueden sernos útiles:

-   **getCurrent**() Devuelve el objeto de la actual iteración
-   **getCount**() Devuelve el número de iteración
-   **isFirst**() Indica si es el primero, también existe **isLast**()
-   **getFirst**() Retorna el objeto pasado en el atributo begin del
    bucle, si este no ha sido indicado retornará null. También existe
    **getEnd**()
-   **getStep()** Retorna el valor del atributo step, null si no se ha
    especificado ninguno.

### forTokens

Recorre un string, cada iteración será un elemento de este que será
separado por los carácteres indicados en el atributo *delims*.

``` xml
<c:set var="phrase" value="Hola, estoy en el trineo de SantaClous; me lo estoy pasando muy bien. Hasta luego." />
<c:forTokens items="${phrase}" var="i" delims=",.;">
    <c:out value="${i}"></c:out> <br />
</c:forTokens>
```

## Ejemplos de formateo y parseo

Tendrás que hacer la siguiente inclusión:

``` xml
<%@ taglib prefix="fmt" uri="/WEB-INF/fmt-rt.tld" %>
```

Con el fmt, a parte de dar formato a los datos, también podrás recoger
un valor en string y **convertirlo** a integer o a date, para ello
tendrás que utilizar las tags ***fmt:parseNumber*** y
***fmt:parseDate***.

### Formatear valores numéricos

Podemos hacerlo de dos formas: *\<fmt:formatNumber
atributos\>número\</fmt:formatNumber\>* o *\<fmt:formatNumber
value=\"número\" atributos/\>*. Los atributos que acepta son:

-   **type** : \[number\|currency\|percent\] Indica el tipo de formato
    que aplicará.
-   **currencyCode** : El código que se aplicará cuando se formateen
    divisas. También existe **currencySymbol**
-   **groupingUsed** : \[true\|false\] Indica si se agrupará el número
    por partes: 1.000.200 o 10002000.
-   **minIntegerDigits** : Número con el mínimo de cifras representado,
    si necesita menos serán sustituidas por 0 a la izquierda. También
    existe **maxIntegerDigits**.
-   **maxFractionDigits** : Número de decimales máximo. También existe
    **minFractionDigits**.
-   **var** : La variable donde se volcará el resultado, si se
    especifica este atributo el resultado del formato no saldrá por la
    salida hasta que no saquemos dicha variable.
-   **scope** : De los scope de toda la vida
-   **pattern** : Indica un formato avanzado, de esta forma es posible
    personalizarlo; ello lo conseguimos siguiendo la siguiente tabla:

![](/sp/j2ee/jstl/patterntable2.png)

``` xml
<fmt:formatNumber value="14525.2334" type="number" groupingUsed="true" maxFractionDigits="2" var="r"/>
<c:out value="${r}" />
```

### Formatear fechas

Igual que con números, pero usando fmt:formatDate. Atributos:

-   **value**
-   **type** \[date\|time\|both\]
-   **dataStyle** \[default\|short\|medium\|long\|full\]
-   **timeStyle** \[default\|short\|medium\|long\|full\]
-   **timeZone**
-   **var**
-   **scope**
-   **pattern** La tabla para el formato personalizado de fecha es
    distinta. Es la siguiente:

![](/sp/j2ee/jstl/patterntable1.png)

``` xml
<jsp:useBean id="now" class="java.util.Date"/>
<fmt:formatDate value="${now}" type="time" timeStyle="medium" />
<fmt:formatDate value="${now}" type="date" dateStyle="full" />
```

## Lectura de XML

### XML de ejemplo

``` xml
<?xml version="1.0" encoding="ISO-8859-1"?>
<students>
 <student id="1">
  <name> 
   <first>John</first>
   <last>Smith</last>
   <middle>T</middle> 
  </name> 
  <grade> 
   <points>88</points> 
   <letter>B</letter> 
  </grade> 
 </student> 
 <student id="2"> 
  <name> 
   <first>James</first> 
   <last>Smith</last> 
   <middle>K</middle> 
  </name> 
  <grade> 
   <points>92</points> 
   <letter>A</letter> 
  </grade> 
 </student> 
 <student id="3">
  <name>
   <first>Kelly</first>
   <last>Lane</last>
   <middle>A</middle>
  </name>
  <grade>
   <points>72</points>
   <letter>C</letter>
  </grade> 
 </student>
</students>
```

### Tag c:import

La tag *c:import* vuelca sobre una variable el contenido de un fichero.
Nos va de puta madre para volcar un archivo .xml sobre una variable:

``` xml
<c:import url="http://www.google.es" var="google" />
<c:out value="${google}" escapeXml="false" />

<c:import url="students.xml" var="docXml" />
<c:out value="${docXml}" escapeXml="true" />
```

## Notas

-   El *\<c:out\>* también tiene un atributo llamado *escapeXml*, si se
    pone a false cuando queramos escribir un carácter prohibido (&, \<,
    \>\...) se escribirá, sino se codificará para el xhtml de la página.
-   Otra tag es *\<c:remove var=\"nombre variable\"\>* que elimina una
    variable asignada con c:set, para variables en las que su scope no
    sea la aplicación no es necesario eliminarlas, acabarán eliminandose
    solas.
