# Flex Xtra

## Controles

### Rellenar un combo con un array

``` xml
<mx:ArrayCollection id="countries">
    <mx:Object code="BDA" description="Bermuda"/>
    <mx:Object code="CAN" description="Canada"/>
    <mx:Object code="USA" description="United States"/>
    <mx:Object code="UK" description="United Kingdom"/>          
</mx:ArrayCollection>

<mx:ComboBox dataProvider="{countries}" labelField="description">
```

Aún así los `ArrayCollection` funcionan mejor como `dataProviders` ya
que los cambios internos en ellos se actualizan en el combo:

``` actionscript
var dp:ArrayCollection = new ArrayCollection(arr);
cmb.dataProvider = dp;
cmb.labelField = "denominacion";
```

## Acceso a servicios web

### Tipos de servicios

-   [Leer un JSON](/fw/as3corelib/as3corelib#deserializar_datos_json)

### Archivo crossdomain.xml

Es un archivo xml para definir los elementos Flash de qué dominios o IPs
pueden acceder al contenido del servidor y se ha de colocar en la raíz
del directorio\\site.\
Ejemplos:\
El siguiente sería el contenido de un crossdomain sin seguridad:

``` xml
<?xml version="1.0"?>
<cross-domain-policy>
   <allow-http-request-headers-from domain="*" headers="*" secure="false" />
   <allow-access-from domain="*" secure="false" />
</cross-domain-policy>
```

Cualquier subdominio de dominio2.com podrá acceder:

``` xml
<? xml version="1.0">
   <cross-domain-policy>
   <allow-access-from domain="*.dominio2.com" /></allow>
</cross>
```

O dar acceso a varios dominios\\IP\'s:

``` xml
<? xml version="1.0">
<cross-domain-policy>
   <allow-access-from domain="www.dominio2.com" /></allow>
   <allow-access-from domain="www.dominio3.com" /></allow>
   <allow-access-from domain="200.89.5.201" /></allow>
   <allow-access-from domain="*.dominio3.com" /></allow>
</cross>
```
