# Solr

## Básicos

### Instalación e inicio

-   [Web del proyecto](http://lucene.apache.org/solr/)
-   [Tutorial básico](http://lucene.apache.org/solr/tutorial.html)
-   [Wiki de Apache sobre Solr](http://wiki.apache.org/solr/FrontPage)

Solr es un sistema de recuperación de información. Se basa en un
servidor de búsqueda REST donde se indexan los documentos en formato
XML, JSON o HTTP para después realizar consultas sobre estos.\
Podemos descargarlo desde
[aquí](http://www.apache.org/dyn/closer.cgi/lucene/solr/) o, en una
distribución Linux, instalando el paquete `solr-common`.\
Requiere de un servidor de aplicaciones Java, aunque la descarga provee
un pequeño servidor ya configurado que podemos ejecutar desde la carpeta
examples mediante:

    $ java -jar start.jar

Y al cual accederíamos a partir de la url:
`http://localhost:8983/solr/admin/`\
Si en cambio lo instalamos en una distribución linux se serviría
mediante Tomcat, donde el puerto por defecto es 8080.\
Podemos configurar solr a partir del fichero `solrconfig.xml`.

### Acciones básicas

La acción de indexar crea el índice a partir de los ficheros indicados.
Una vez realizado el índice podremos consultar por sus ficheros (acción
de retrieval).\
La descarga de Solr viene con aplicaciones (`post.jar` y `post.sh`) para
la comunicación con el servidor. Por ejemplo\...\

#### Indexar

    $ java -jar post.jar solr.xml monitor.xml

#### Eliminar

Tras eliminar un elemento deberemos hacer un commit
(`$ java -jar post.jar` debería funcionar). Eliminar por identificador:

    $ java -Ddata=args -Dcommit=no -jar post.jar "<delete><id>SP2514N</id></delete>"

Eliminar por nombre:

    $ java -Ddata=args -jar post.jar "<delete><query>name:DDR</query></delete>"

#### Consulta de datos

-   `q=video&fl=name,id`, consulta por video sólo retornando los campos
    `name` e `id`.
-   `q=video&fl=name,id,score`, lo mismo que la anterior pero además
    mostrando el score dado.
-   `q=video&fl=*,score`, todos los campos indexados más el score.
-   `q=video&wt=json`, respuesta en formato json.
-   `q=video&sort=price desc`, respuesta devolviendo por precio
    descendente.
-   `q=video&sort=inStock asc, price desc`
-   `q=video&sort=score desc`

## Schema

-   [Página de documentación del
    schema](http://wiki.apache.org/solr/SchemaXml)

Es el elemento que define cómo se trata el indexado y la recuperación de
los datos. Podemos acceder a partir de: `<url solr>/admin/schema.jsp`.\
En el paquete descargable de Solr encontramos este fichero en la ruta:
`solr/conf`.

### Tipos de datos

-   <http://wiki.apache.org/solr/AnalyzersTokenizersTokenFilters>

Los tipos de datos posibles los encontramos dentro de la sección
`<types>`, en la lista `<fieldtype>`. Podemos configurar su
comportamiento (si los strings se comprimirán, si serán indexados\...) a
partir de aquí.

#### Indicar que se filtren stopwords

#### Indicar que se tenga en cuenta las mayúsculas y minúsculas

### Campos

En la sección `<fields>` se declaran elementos `<field>` que son lo que
se utilizará en tu aplicación.\
Cada `<field>` tiene un nombre y un tipo asociado.

#### Opciones comunes de los campos

-   `default`, valor por defecto del campo si no se da ninguno.
-   `indexed`, si se indexará.
-   `stored`, si se devolverá en la búsqueda.
-   `compressed`, si el valor ha de ser comprimido.
-   `compressedThreshold`, a partir de qué tamaño se comprimirá.
-   `multiValued`, si puede tener múltiples valores.

#### Opciones avanzadas

-   `omitNorms`
-   `omitTermFreqAndPositions`
-   `omitPositions`
-   `termVectors`
-   `termPositions`
-   `termOffsets`

#### Campos dinámicos

Definen campos que no están definidos (yeah!). Por ejemplo podríamos
decir que, cuando llegase un campo que acabase en \"\_i\" y no estuviese
explícitamente definido se crease:

``` xml
<dynamicField name="*_i"  type="integer"  indexed="true"  stored="true"/>
```

### Otra configuración

Más configuraciones que aparecen en el schema\...

-   `<uniqueKey>` indica que es un campo único, no puede haber otro
    igual en el índice. Si un documento se añade con el mismo valor en
    este campo que otro ya existente, el ya existente será eliminado.
-   `<defaultSearchField>` indica que campo es en el que se hará la
    búsqueda si en la query no se indica.
-   `<solrQueryParser defaultOperator="AND|OR" />`, indica cual de los
    dos operadores (AND o OR) se utiliza en las queries.
-   `<copyField>`
-   `<similarity>`

## Carga de documentos

### Otros formatos

#### Archivos .csv

-   <http://wiki.apache.org/solr/UpdateCSV>

#### Archivos json

-   <http://wiki.apache.org/solr/UpdateJSON>

## Retrieval

### Formato de queries

-   [Sintaxis de queries](http://wiki.apache.org/solr/SolrQuerySyntax)
-   [Parámetros de
    queries](http://wiki.apache.org/solr/CommonQueryParameters)

### Queries con relevancia

-   <http://wiki.apache.org/solr/SolrRelevancyFAQ>

### Queries avanzadas

-   <http://wiki.apache.org/solr/SolrRelevancyCookbook>

### Faceted search

## Uso de Solr desde programación

### SolrPy

-   [Web del proyecto](http://code.google.com/p/solrpy/)
-   [Documentación](http://packages.python.org/solrpy/)

Es una librería para el acceso a Solr desde Python. Es fácilmente
instalable (con `easy_install solrpy`) y un ejemplo de uso sería:

``` python
import solr
# create a connection to a solr server
s = solr.SolrConnection('http://example.org:8083/solr')
# add a document to the index
s.add(id=1, title='Lucene in Action', author=['Erik Hatcher', 'Otis Gospodnetić'])
s.commit()
# do a search
response = s.query('title:lucene')
for hit in response.results:
    print hit['title']
```

#### Métodos útiles

-   `delete(id, ids, queries)`
-   `delete_many(ids)`
-   `delete_query(query)`
-   `commit()`
-   `add(doc)`
-   `add_many(docs)`
-   `.query(q, fields=None, highlight=None, score=True, sort=None, sort_order="asc", **params)`

## Notas

### Documentos

-   ![Indexar textos y html con
    Solr](/sistemas/solr/index-text-html-solr.pdf)
