# LATEX

## Básico

### Estructura y formato de documento

``` latex
\documentclass[<formato>]{<tipo>}
<cabecera>
\begin{document}
<cuerpo>
\end{document}
```

Donde\...

-   *formato*: Qué formato de salida tendrá.
-   *tipo*: El tipo de documento que escribimos.
-   *cabecera*: Colocaremos las definiciones y requisitos del documento.
-   *cuerpo*: Es el texto del documento.

#### Formato

#### Tipo

### Cabecera

## Cuerpo del documento

### Estructurar el texto

Podemos estructurar el texto de la siguiente forma:

-   Por partes: `\part{title}`.
-   Por secciones: `\section{title}`
-   Por subsecciones: `\subsection{title}`

``` latex
\section{ Summary of round table conclusions }
This is our second document. It contains a title and a section
with text.
```

### Formato de texto

-   Cursiva: `\textit{italic}`
-   Negrita: `\textbf{bold}`
-   Combinación de negrita y cursiva: `\textit{\textbf{nested}}`

### Agregar imágenes

``` latex
\begin{figure}[htp]
\centering
\includegraphics[scale=0.4]{images/mcmc.png}
\caption{MCMC algorithm}
\label{mcmc}
\end{figure}
```

-   Es necesario añadir: `\usepackage{graphicx}`
-   Luego para hacer referencia a ella se haría: `\ref{graph}`

## Apartados especiales

### Bibliografía

``` latex
\begin{thebibliography}{9}

\bibitem{lamport94}
  Leslie Lamport,
  \emph{\LaTeX: A Document Preparation System}.
  Addison Wesley, Massachusetts,
  2nd Edition,
  1994.

\end{thebibliography}
```

-   Para hacer referencia a un *bibitem* haremos: `\cite{lamport94}`.

## Cómo\...

### Formato del documento

#### Utilizar UTF8

Agregando a la cabecera\...

``` latex
\usepackage[utf8x]{inputenc}
```

## Notas

### Editores

-   LyX

#### Linux

-   Gummi
-   LaTeXila
-   Texmaker
