# Python

-   [Documentación extra](/script/python/xtra)
-   [Documentos externos (artículos,
    tutoriales\...)](/script/python/docs)

## Básico

### Range

-   Para hacer un for del 0 al 10 podremos hacer:

``` python
for i in range(0,10)
```

-   El range(0,10) devuelve los números del 0 al 9 sin incluir el 10.
-   Lo que hace al llamar a la función range es devolver una lista con
    los números del 0 al 10, sin inculir el último.
-   Pero el mismo efecto haría si haces: range(10). Sólo con un
    parámetro.
-   Podemos llamar a range con 3 valores, el tercero son los pasos que
    por defecto es +1, pero si quisiesemos contar en negativo deberíamos
    hacer: range(0,-10,-1)

``` python
    range(0,10,3)
    [0, 3, 6, 9]
```

-   Al partir cadenas y estas cosillas relacionadas con el range, lo que
    se hace es llamar a un range interno:

``` python
    cadena[:]       # toda la cadena
    cadena[:-1]     # toda la cadena menos el último carácter
    cadena[3:]      # toda la cadena a partir del 3er carácter
    cadena[::-1]        # cadena invertida
```

-   Al hacer un range lo que se hace es crear una lista, si esta lista
    va a ser larga ocuparía espacio en memoria, para usarla
    temporalmete, como por ejemplo en un for usaremos la funcion xrange:

``` python
    for i in xrange(0,10):
        print i
```

### Condicionales y bucles

-   Los and, ors\...: and, or, not, ==, !=, \<, \>\...
-   El \'else if\' en python es \'elif\'
-   Existe el break y el while:

``` python
b = False
i = 0
while not b:
    print "hello"
    if (i >= 4):
        break
    i = i + 1
```

-   Un foreach sería: `for <var temp> in <agrupacion elementos>:`

## Orientado a objetos

### Clases

-   Para tener constructores con argumentos estos han de tener un valor
    por defecto, sino no furrulará:

``` python
    class cPrueba:
        def __init__(self, parA = 'Hola'):
    ....
```

-   O esto o dentro del constructor asignamos el parámetro en algún
    sitio:

``` python
    class cPrueba:
        def __init__ (self, parA):
            MyPar = parA
```

-   La herencia se hace indicando la clase base entre parentesis:

``` python
    class cPrueba2 (cPrueba):
        ...
```

-   ~~El orden de llamada a los constructores en las clases que
    participan en la herencia es el de siempre: primero el de la base y
    luego el de las heredadas.~~ MENTIRA!!, has de llamarlos tú:
    nombreBase.\_\_init\_\_(self))
-   Para acceder a la clase base de una derivada desde esta, no tenemos
    que hacer más que \<NombreClaseBase\>.\<NombreMetodo\>

#### Notas de clases

-   Si metes una propiedad dentro de una clase, le das un valor, creas
    objetos y luego la cambias. Esa propiedad será cambiada para todos
    los objetos.
-   Para poder comparar objetos de un mismo tipo debes definir el método
    `__cmp__`, que reciba los parámetros self y otro elemento. Si es
    mayor debe devolver un int \>0, si es menor \<0, si son iguales los
    dos objetos debe devolver un 0.
-   Otro método especial es el: `__repr__`, que se usa para mostrar una
    representación en string del objeto (p.ej. cuando no se use en un
    print y sólo se ponga su nombre).
-   Existen las siguientes funciones que son llamadas cuando se acceden
    a los elementos de la clase:

``` python
    def __setattr__(self, name, value):
    def __getattr__(self, name):
    def __delattr__(self, name):
```

## Funciones del lenguaje

### Función type

Mediante esta función enviandole una variable, se nos indicará el tipo
del cual es dicha variable:

``` python
    a = "afdsah"
    print type(a)       # type: str
```

Para comparar tipos deberemos importar el módulo types y comparar\...

``` python
    import types
    a = "askfdj"
    print type(a) == types.ModuleType   # Falso, no es un módulo
    print type(a) == types.StringType   # Verdadero, a es un string
    print type(types) == types.ModuleType   # Verdadero, types es modulo
```

También lo podemos hacer con objetos clases pero con el atributo
`__class__`

``` python
class Field:
    pass
f = Field ()
print f.__class__ == Field  # True
```

## Python avanzado

### Valores booleanos

-   Todos los valores pueden usarse como valores booleaos, valores
    vacíos como \[\], 0 o None corresponden a False. Si, en cambio, la
    variable contiene algún valor, su valor booleano será True.
-    Si nosotros evaluamos un and o un or, lo que ocurre al pedir:
    -   `i and b` -\> Si i es verdadero devolverá b, si no devolverá i.
    -   `i or b` -\> Si i es verdadero devolverá i, si no devolverá b.\

Ejemplo:

``` python
    i = 5
    b = 7
    print i and b       # 7
    print b and i       # 5
    print i or b        # 5
    print b or i        # 7
```

-   O por ejemplo, algo así:

``` python
    if a:
        print a
    else:
        print b
```

Podría sustituirse por:

``` python
    print a or b
```

### Variables globales

Desde una función podemos acceder a una variable global, fuera de dicha
función, pero no escribirla. Para ello, poder escribirla, debemos
acceder a esa variable desde la función habiendo indicado antes que es
la global, así: `global <variable>`

``` python
    NAME = "Manzana"
    def show_global():
        name = NAME
        print '(show_global) nombre: %s' % name
    def set_global():
        global NAME
        NAME = 'Naranja'
        name = NAME
        print '(set_global) nombre: %s' % name
    show_global()
    set_global()
    show_global()
```

Esto imprimiría:

    (show_global) nombre: Manzana
    (set_global) nombre: Naranja
    (show_global) nombre: Naranja

Pero:

``` python
    NAME = "Manzana"
    def show_global():
        name = NAME
        print '(show_global) nombre: %s' % name
    def set_global():
        NAME = 'Naranja'
        name = NAME
        print '(set_global) nombre: %s' % name
    show_global()
    set_global()
    show_global()
```

Imprimiría:

    (show_global) nombre: Manzana
    (set_global) nombre: Naranja
    (show_global) nombre: Manzana

### Namespaces

-   En python un namespace se refiere al lugar donde están disponibles
    variables y objetos, mediante la variable \_\_name\_\_ podemos saber
    en qué namespace nos encontramos, si es el que se ejecuta será
    llamado `__main__`.
-   Para comprobar los elementos de un namespace hacemos:
    -   `dir(math)` \<- Muestra los elementos del módulo math
    -   `dir()` \<- Muestra los elementos del módulo actual

#### Notas

**Método main**, un archivo de código .py puede ser llamado como módulo
o como ejecutable, para controlar si la forma de llamada ha sido por
como ejecutable:

``` python
if __name__ == "__main__":
    < código inicial >
```

### Módulo por defecto

El módulo `__builtin__` es el módulo que se carga inicialmente y por
defecto en python. Aún así, si queremos hacer referencia, en concreto a
ese haremos:

``` python
    import __builtin__
    __builtin__.<xxxx>
```

### Otros módulos

-   Existen módulos para controlar funciones del sistema operativo como:
    **sys** y **os**. Mira en la sección de
    [documentación](/script/python/docs#documentacion).
-   El módulo **gc** es el recolector de basura, puedes activarlo y
    desactivarlo
-   El módulo **pickle** nos permite guardar variables de tipos de datos
    \"especiales\" de python en ficheros.

## Notas

-   En cualquier momento puedes poner: `<>.__doc__` y accederás a la
    documentación de ese método\\propiedad:
    `print string.split.__doc__`{.python}
-   Parece ser que `None` equivale a `NULL`.
-   Python es tan flexible que podemos crear una función dentro de otra
    y llamarla:

``` python
    def Func (a):
        def func (a):
            return a * 3
        return func(a)
    print Func("Aa")
```

-   Podemos trabajar con números complejos, para ello usamos la \'j\'
    detrás del número: 3j \... o \... 2 + 4j
-   Para recoger los carácteres pulsados del teclado puedes hacerlo como
    si desde un fichero se tratase, usa el objeto \'stdin\' dentro del
    módulo \'sys\' de la siguiente forma:

``` python
print sys.stdin.readline()
```

-   Existe una función sumatorio, a la cual le pasas una lista y la
    suma: `sum(range(0,10))`
-   La función `mktmp()` del módulo tempfile devuelve una cadena con la
    dirección de un nombre de fichero que podría usarse como fichero
    temporal (que no tenga el nombre de otro).
-   Podemos hacer que el print, en vez de imprimir por pantalla lo haga
    por otro canal, para ello, en el módulo sys hay una propiedad que es
    stdout, por ahí es por donde escribirá el print. Para escribir el
    print usa un método write pasandole a este un string.
-   Si creas una clase con un método write, asignas un objeto de esta a
    sys.stdout al hacer print se llamará a ese método.

``` python
    sys.stdout = PrintRedirect('tmp.log')
```

-   `PrintRedirect` es una clase que guarda el string pasado por el
    constructor internamente. Cuando se llama a print también se llama
    al método write de PrintRedirect (def write(self, msg): \...) que
    escribe en el fichero que se llama como el string.
-   Para copiar un objeto lo que debemos hacer es usar el método copy
    del módulo copy:

``` python
    import copy
    ...
    p2 = copy.copy(p1)
```

-   Recuerda que puedes usar la clausula \'import\' dentro de una
    función (así no la dejas como global si sólo vas a usar unas pocas
    funciones del módulo).
-   Podemos ver las propiedades de una clase haciendo:
    `vars(nombreClase)`
-   Puedes acceder al nombre de la clase de un objeto haciendo:

``` python
obj.__class__
```

-   A Python también se le llama `CPython`, es la implementación por
    defecto del lenguaje y está escrita en C, además de este existen
    otros dos desarrollos importantes, el de Java (`Jython`) y el de
    .NET ([IronPython](/fw/ironpython/ironpython)).
