# Web components

UserWebComponent:

    <template>
      <div>
        <h1>My Vue Web Component</h1>
        <div>{{ msg }}</div>
      </div>
    </template>
    <script>
      export default {
        props: ['msg'] 
      }
    </script>

    $ vue-cli-service build --target wc --name user-component  --mode production ./src/UserComponent.vue

    <script src="https://unpkg.com/vue"></script>
    <script src="path/to/user-component.js"></script>
    <!-- use in plain HTML, or in any other framework -->
    <user-component msg="probando"></user-component>

-   <https://cli.vuejs.org/guide/build-targets.html#web-component>

:!: Take into account the compatibility of `window.customElements`:

-   <https://developer.mozilla.org/en-US/docs/Web/API/Window/customElements#Browser_compatibility>

## Varios en un único bundle

    vue-cli-service build --target wc --name foo 'src/components/*.vue'

Los componentes se inferirán a partir del nombre. `foo-user-component`
por ejemplo para UserComponent.

Se pueden pedir los componentes asincronamente si el bundle crece mucho
con\...

    vue-cli-service build --target wc-async --name foo 'src/components/*.vue'

## Otros parámetros a usar

    # Para producción
    --mode production
    # Para watchear
    --watch
    # Para escoger destino
    --dest ../

## Internamente hace\...

Algo parecido a esto:

    import Vue from 'vue';
    import wrap from '@vue/web-component-wrapper';
    import VueWebComponent from './components/VueWebComponent';
    const CustomElement = wrap(Vue, VueWebComponent);
    window.customElements.define('my-custom-element', CustomElement);
