# Flake8

## Basic usage

Documentation:

-   <http://flake8.pycqa.org/en/latest/>

Install:

    pip install flake8

To use it for a folder:

    # for the current path
    flake8
    # or
    python -m flake8
    # or
    flake8 /the/path

To use it for a file:

    flake8 path/to/file.py

The output format is:\
`file path : line number : column number : error code : short description`

Flake8 will exit with code 1 if there are errors. You can change this
using the parameter: `--exit-zero`

Error code prefix:

-   E\*/W\*: pep8 errors and warnings ─
    <https://pep8.readthedocs.io/en/latest/intro.html#error-codes>
-   F\*: PyFlakes codes ─
    <https://flake8.pycqa.org/en/latest/user/error-codes.html>
-   C9\*: McCabe complexity plugin mccabe
-   N8\*: Naming Conventions plugin pep8-naming ─
    <https://github.com/PyCQA/pep8-naming>

### Configuration

You can configure the flake8 analysis using its command parameters
(<http://flake8.pycqa.org/en/latest/user/options.html>) or placing them
in a file named `setup.cfg` in the project root.

    [flake8]
    exclude = .git,*migrations*
    max-line-length = 119

### Ignoring errors

Just add \# noqa in the end of the line.

    def ready(self):
        import cmdbox.profiles.signals.handlers  # noqa

Or you can pass the specific error code you want to ignore:

    import cmdbox.profiles.signals.handlers  # noqa: F401

### Using it with\...

-   Pycharm
    -   <https://foxmask.net/post/2016/02/17/pycharm-running-flake8/>
    -   <https://gist.github.com/tossmilestone/23139d870841a3d5cba2aea28da1a895>
-   Atom
    -   <https://atom.io/packages/linter-flake8>
-   Vim
    -   <https://github.com/nvie/vim-flake8>
-   SublimeText
    -   <https://github.com/dreadatour/Flake8Lint>
    -   <https://github.com/SublimeLinter/SublimeLinter-flake8>
-   Visual Studio Code
    -   <https://code.visualstudio.com/docs/python/linting>

### Interesting usages

Parameters:

-   `--count` to print the number of errors.
-   `--select=E4,E51,W234` to select which errors analyse.
-   `--ignore=E4,E51,W234` to select which errors ignore.
-   `--show-source` to show the code where the error was found.
-   `--output-file=OUTPUT_FILE` to redirect the output to a text file.
-   `--config=CONFIG` to select the config file.
-   `--statistics` to show statistics about errors and warnings.

#### Using hooks for version control

<http://flake8.pycqa.org/en/latest/user/using-hooks.html>

You can stop a commit if flake8 find errors.

### Plugins

To see which plugins are enabled:

    flake8 --version

To temporally enable disabled plugins:
`--enabled-extensions=ENABLED_EXTENSIONS`.
