# Preparing a Django project

## Pipeline


    poetry init

    poetry add django

    poetry run django-admin startproject {project} .

    - fix directory generation -

    touch README.md

    - copy the .gitignore -

    git init

    git add -A 

    git commit -m "first commit"

    git remote add origin {url}

    git push -u origin master

    - move settings to an inner package, renaming the file to 'default.py' -

    - Add a develop.py file -

    - In settings\__init__.py and in settings\develop.py add the line: from .default import * a

    - Change BASE_DIR like this: BASE_DIR = Path(__file__).resolve().parent.parent.parent

    - Add import os

    - Change: ALLOWED_HOSTS = ['0.0.0.0']

    poetry add whitenoise

    - Configure whitenoise

    - Add STATIC_ROOT = os.path.join(BASE_DIR, 'static')

    poetry env list --full-path

    - Change the config for running in that path: manage.py runserver 0.0.0.0:8000 --nostatic . Also add the DJANGO_SETTINGS_MODULE envvar as {project}.settings.develop

    poetry add psycopg2-binary

    poetry add gunicorn

    mkdir docker

    - Add the docker files

    docker-compose up postgres12

    docker exec -ti --user postgres postgres12 createdb {project}

    - Change the database configuration:

    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.postgresql',
            'NAME': '{project name}',
            'USER': 'postgres',
            'PASSWORD': 'mysecretpassword',
            'HOST': os.environ.get('DB_HOST', '127.0.0.1'),
            'TEST': {
                'NAME': '{project_name_test}',
            }
        }
    }

    ln -s ../daauth/daauth daauth

    - Remove admin from urls.py and from settings -

    - Add models.py, views.py and the package migrations. Also the apps.py. - 

    - Add to INSTALLED_APPS: daauth & {project}

    - Add the next lines to settings/default.py:
    AUTH_USER_MODEL = '{project}.User'
    LOGIN_REDIRECT_URL = '/'

    python manage.py migrate

    mkddir -p static/styles/sass

    touch static/styles/sass/main.scss static/styles/sass/stylesheet.scss

    - Add @import "stylesheet"; to main.scss

    sass --watch static/styles/sass/main.scss:static/styles/stylesheet.css

    - Add to repository those last files

    git commit

    mkdir -p {project}/templates

    touch {project}/templates/base.html



## Concrete

### .gitignore

    *.pyc
    .DS_Store
    env
    venv
    .idea/**
    node_modules
    *.sqlite3
    *.pyc
    **/__pycache__/*
    **/.sass-cache/*
    **/.env
    **/elm-stuff/**

    strit/migrations/**
    !strit/migrations/__init__.py

    strit/settings/**
    !strit/settings/default.py
    !strit/settings/__init__.py

    daauth
    /daauth/

### Whitenoise

-   <http://whitenoise.evans.io/en/stable/#quickstart-for-django-apps>

### app.Dockerfile

    FROM python:3.9-alpine
    ENV PYTHONUNBUFFERED 1

    ARG http_proxy
    ENV https_proxy=$http_proxy
    ENV http_proxy=$http_proxy
    ENV HTTP_PROXY=$http_proxy
    ENV HTTPS_PROXY=$http_proxy

    RUN apk update
    RUN apk add --no-cache python3-dev libffi-dev postgresql-libs postgresql-dev build-base cairo cairo-dev pango pango-dev fontconfig ttf-dejavu ttf-freefont
    RUN apk add --virtual build-deps gcc python3-dev musl-dev
    RUN apk add jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev py-pillow
    RUN apk add git


    RUN mkdir -p /srv/app
    WORKDIR /srv

    RUN pip install --upgrade pip
    RUN pip install poetry
    COPY pyproject.toml /srv/pyproject.toml
    COPY poetry.lock /srv/poetry.lock
    RUN poetry install

    CMD poetry run gunicorn strit.wsgi --bind 0.0.0.0:8000

### docker-compose.yml

    version: "3.3"

    services:
      postgres12:
        container_name: postgres12
        image: postgres:12
        volumes:
          - /srv/data/pg12:/var/lib/postgresql/data/
        environment:
          - POSTGRES_PASSWORD=mysecretpassword
        ports:
          - 5432:5432
      {project}:
        build:
          context: ..
          dockerfile: docker/app.Dockerfile
        ports:
          - 8000:8000
        container_name: {project}
        depends_on:
          - postgres12
        environment:
          - DB_HOST=postgres12
        volumes:
          - ..:/srv
        command: poetry run gunicorn {project}.wsgi --bind 0.0.0.0:8000

### apps.py

    from django.apps import AppConfig


    class {Project}Config(AppConfig):
        name = '{project}'

### models.py

    from django.db import models
    from daauth.models import BaseUser


    class User(BaseUser):
        class Meta:
            db_table = "users"

### base.html

-   <http://htmlshell.com/>

```{=html}
<!-- -->
```
    <!DOCTYPE html>
    <!--[if lte IE 6]><html class="preIE7 preIE8 preIE9"><![endif]-->
    <!--[if IE 7]><html class="preIE8 preIE9"><![endif]-->
    <!--[if IE 8]><html class="preIE9"><![endif]-->
    <!--[if gte IE 9]><!--><html><!--<![endif]-->
     {% load dutils %}
      <head>
        <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
      <meta name="viewport" content="width=device-width,initial-scale=1">
        <title>title</title>
      <meta name="author" content="name">
      <meta name="description" content="description here">
      <meta name="keywords" content="keywords,here">
      <link rel="stylesheet" href="{% dstatic 'styles/stylesheet.css' %}" type="text/css">
      </head>
      <body>
        aaaaa
      </body>
    </html>
