# Basic Pandas

## Basic navigation

See the first 3 rows: `df.head(3)`

Valores únicos de una columna `df.<columna>.unique()`

Coger solo unas columnas:

    df[['1990', '2000', '2010']]

Filter by a row value:

    is_1809 =  df['Mes'] == 'Septiembre 18'
    df[['Mes', 'Categoria', 'Real']][is_1809]

### To access data

`DataFrame.at` Access a single value for a row/column label pair

`DataFrame.iloc` Access group of rows and columns by integer position(s)

`DataFrame.xs` Returns a cross-section (row(s) or column(s)) from the
Series/DataFrame.

`Series.loc` Access group of values using labels

## Basic operations

Remove column from dataframe: `df.drop('column_name', axis=1)`. Also:
`df.drop(columns=['Esperado acumulado'])`

Remove row by index: `df.drop([0, 1])`

Eliminar una row cuando contenga valor en una columna (Categoria) vacío:

    df = df[df['Categoria'] != '']

### Pivot table

    pd.pivot_table(df, index=['Mes'], columns=['Categoria'], values=['Real'], aggfunc='sum')

### Change order

Re-Organize indexes:

    df.reindex(['Enero', 'Febrero', 'Marzo'])

### Stack and Unstack

![](/wiki2/pandas/reshaping_stack.png){.align-center width="300"}

![](/wiki2/pandas/reshaping_unstack.png){.align-center width="300"}
