# NodeJS Resources

## Body Parser

Con express:

    var bodyParser = require('body-parser');
    app.use(bodyParser.json());
    app.use(bodyParser.urlencoded({extended:false}));

## Nodemon

To mantain the server up: `npm install nodemon -g`. Now the app.js and
all its folder will be refreshed without needing to restart.

    $ nodemon

## ejs

`npm install ejs --save`\
Using files .ejs

    res.render('index', {
      title: 'Customers'
    });
    ...
    <h1><%= title %></h1>

### Partials

Header

    <html>
    <header></header>
    <body>...

Footer

    </body></html>

Body

    <% include partials/header %>
    <h1>...
    <% include partials/footer %>

### Iterations

    <ul>
    <% users.forEach(function(uer){ %>
      <li> <%= user.firstName %> </li>
    <% }) %>
    </ul>

## Express Validator

`npm install express-validator --save`

    var expressValidator = require('express-validator');

You will find some examples in its webpage:
<https://github.com/ctavan/express-validator>

    req.checkBody('Email', 'Email is required).notEmpty();
    var errors = req.validationErrors();
    if (errors) {

    } else {
      // success
    }

## MongoJS

`npm install mongojs --save`

    db.users.find(function (err, docs) {
      res.render('index', {
        title: 'Customers',
        users: docs
      });
    });

## Config JS

-   <https://www.npmjs.com/package/config-js>

```{=html}
<!-- -->
```
    var Config = require('config-js');
    var path = require('path');

    var config = new Config(path.join(__dirname, '/config/config.js'));

    var logOnOptions = {
      'accountName': config.get('steam.username'),
    };

    exports.config_file_path = function () {
        var path = require('path');
        var is = require('is2');

        var pathToConfigFile = path.join(__dirname, '/config/config#.js');
        var idx = pathToConfigFile.indexOf('#');
        var config_value = process.env.EBOT_CONFIG;
        if (config_value != undefined)
            config_value = '.' + config_value;
        else
            config_value = '';
        pathToConfigFile = pathToConfigFile.substr(0, idx) + config_value + pathToConfigFile.substr(idx+1);
        console.log(pathToConfigFile);
        return pathToConfigFile;
    }

## Mongoose
