# MySQL

## Create users

GRANT \[type of permission\] ON \[database name\].\[table name\] TO
'\[username\]'@\'localhost';

    mysql> CREATE USER 'finley'@'localhost' IDENTIFIED BY 'some_pass';
    mysql> GRANT ALL PRIVILEGES ON *.* TO 'finley'@'localhost' WITH GRANT OPTION;

Allow remote connections:

    mysql> CREATE USER 'finley'@'%' IDENTIFIED BY 'some_pass';
    mysql> GRANT ALL PRIVILEGES ON *.* TO 'finley'@'%' WITH GRANT OPTION;

For example, lets create an access for the user \'mantis\' with password
\'mantis\' only available to connect from 81.4.127.208 to the database
mantis:

    create user 'mantis'@'81.4.127.208' identified by 'mantis';
    grant all privileges on mantis.* to 'mantis'@'81.4.127.208' with grant option;
    flush privileges;

    FLUSH PRIVILEGES;

    DROP USER ‘demo’@‘localhost’;

## Entrar por consola con user y password

-h \<host\>

     mysql -u root -h 127.0.0.1 -p

    mysql -u root -ppassword

## Ejecutar commando

    mysql -u root -h 127.0.0.1 -ppassword -e "select * from users"

## Backups

    mysqldump database_name > database_name.sql

    mysqldump --databases database_one database_two > two_databases.sql

    mysqldump --all-databases > all_databases.sql

    mysql database_name < database_name.sql

**Create a database and load an sql file on it:**

    mysqladmin -u username -p"password" create newDbName
    mysql -u username -p"password" newDbName < oldDbName.sql

    mysql --one-database database_name < all_databases.sql
