# Networking tools in Linux

## Basic

-   `ip a` to see interfaces + ip addresses.
-   `ifw disable` disables the ubuntu firewall.

## iptables

## netplan

To change the network configuration in new Ubuntu versions.

There is an .yml software in `/etc/netplan`. To apply changes use the
next command:

    netplan apply

## Change IP

    network:
      version: 2
      renderer: networkd
      ethernets:
        enp3s0:
          addresses:
            - 10.10.10.2/24
          gateway4: 10.10.10.1
          nameservers:
              search: [mydomain, otherdomain]
              addresses: [10.10.10.1, 1.1.1.1]

### DHCP example

    network:
      version: 2
      renderer: networkd
      ethernets:
        enp3s0:
          dhcp4: true

### Using NetworkManager

    network:
      version: 2
      renderer: NetworkManager

## routes

### Which ip has a domain?

    alfred@Y50-70:~$ nslookup couch00.dev.getfinancing.us
    Server:     127.0.0.53
    Address:    127.0.0.53#53

    Non-authoritative answer:
    Name:   couch00.dev.getfinancing.us
    Address: 10.1.50.195
    Name:   couch00.dev.getfinancing.us
    Address: 10.1.51.200
    Name:   couch00.dev.getfinancing.us
    Address: 10.1.52.100

### What\'s your routing table?

    alfred@Y50-70:~$ route -n
    Kernel IP routing table
    Destination     Gateway         Genmask         Flags Metric Ref    Use Iface
    0.0.0.0         192.168.1.1     0.0.0.0         UG    100    0        0 enp9s0
    10.1.0.0        0.0.0.0         255.255.0.0     U     50     0        0 tun0
    34.231.231.68   192.168.1.1     255.255.255.255 UGH   100    0        0 enp9s0
    169.254.0.0     0.0.0.0         255.255.0.0     U     1000   0        0 virbr0
    192.168.1.0     0.0.0.0         255.255.255.0   U     100    0        0 enp9s0
    192.168.1.1     0.0.0.0         255.255.255.255 UH    100    0        0 enp9s0
    192.168.122.0   0.0.0.0         255.255.255.0   U     0      0        0 virbr0
    192.168.255.1   192.168.255.21  255.255.255.255 UGH   50     0        0 tun0
    192.168.255.21  0.0.0.0         255.255.255.255 UH    50     0        0 tun0

## DNS

You can query dns records with the dig command. To do that, for example,
for obtaining the CNAME record for url6816.alfredgg.dev:

    dig cname url6816.alfredgg.dev

## VPN with strongswan

### ipsec command

-   `ipsec status` tells you who is connected.
-   `ipsec reload` reloads the config.
-   `ipsec restart` restarts the service.

### Troubleshooting

## Mapping the network

## Which ports are open?

Locally and simply:

    nmap localhost

Remotely:

    nmap -Pn -p 51414 95.169.230.182

Comprueba el puerto 51414 de 95.169.230.182.

Hay la posibilidad de lanzarlo via web desde:
<http://nmap.online-domain-tools.com/>

### Discover IP\'s

    nmap -sP 192.168.1.*

    nmap -sn 192.168.1.0/24

## Emulate network problems

-   <https://medium.com/@docler/network-issues-simulation-how-to-test-against-bad-network-conditions-b28f651d8a96>
-   <https://wiki.linuxfoundation.org/networking/netem>

You will use \"tc\" command:

    sudo tc qdisc add dev eth0 root netem delay 1s
    sudo tc qdisc del dev eth0 root

For example, to simulate problems with dockers you will do the next:

1.  `docker inspect container` -\> And take the value for the IPAddress
2.  `route -n` -\> To see which device is used for that container
3.  `sudo tc qdisc add dev <device> root netem delay 1s`
4.  Test it with a ping.
5.  `sudo tc qdisc del dev <device> root`

### Other examples

    tc qdisc add dev eth0 root netem loss 5%
    tc qdisc change dev eth0 root netem corrupt 2%
    tc qdisc change dev eth0 root netem duplicate 1%

## How to\...

### Update DNS in Ubuntu 18.04

Previously you only need to edit the `/etc/resolv.conf`

In new versions Netplan manages the network. You can configure it on
files places on `/etc/netplan`; these have an yml format.

This is an example:

    network:
      version: 2
      renderer: networkd
      ethernets:
        ens3:
          dhcp4: no
          addresses:
            - 192.168.121.199/24
          gateway4: 192.168.121.1
          nameservers:
              addresses: [8.8.8.8, 8.8.4.4]

To update from changes do:

    netplan apply

To list dns entries:

    systemd-resolve --status

### \... know\...

#### \... The default gateway?

    $ route -n
    0.0.0.0         91.126.134.177  0.0.0.0         UG    100    0        0 ens18
