# Lets avoid jQuery

-   <https://htmldom.dev/>
-   <http://youmightnotneedjquery.com/>
-   <https://github.com/nefe/You-Dont-Need-jQuery> \|
    ![](/wiki2/js/you-dont-need-jquery-master.zip)
-   <https://news.ycombinator.com/item?id=19534060>

## Vanilla

Foreach:

    the_array.forEach(function(element) {
      console.log(element);
    });

## Typical jQuery

OnDocumentLoad:

    (function() {
       // your page initialization code here
       // the DOM will be available here
    })();

If supported, it tries the standard:

    document.addEventListener('DOMContentLoaded', fn, false);

with a fallback to:

    window.addEventListener('load', fn, false )

or for older versions of IE, it uses:

    document.attachEvent("onreadystatechange", fn);

with a fallback to:

    window.attachEvent("onload", fn);

## Selectores

document.getElementsByClassName(\'test\')

document.getElementsByClassName(\'red test\')

document.getElementById(\'main\').getElementsByClassName(\'test\')

document.getElementsByName(elementsName);

document.getElementById(resultId)

document.getElementsByTagName(\'span\')\[0\];

var i = btn.getElementsByTagName(\'i\');

## Elementos en el DOM

Crear elemento: `var d = document.createElement('div');`

Acceder al padre: `e.parentNode`

## Clases y CSS

document.getElementById(\"MyElement\").classList.add(\'MyClass\');

document.getElementById(\"MyElement\").classList.remove(\'MyClass\');

if (
document.getElementById(\"MyElement\").classList.contains(\'MyClass\') )
document.getElementById(\"MyElement\").classList.toggle(\'MyClass\');

To replace all existing classes with one or more new classes, set the
className attribute:
`document.getElementById("MyElement").className = "MyClass";`

To add an additional class to an element:
`document.getElementById("MyElement").className += " MyClass";`

## Eventos

Add event: \'\'
document.getElementById(\'the_id\').setAttribute(\'onchange\',
\'<javascript:loadElements(this>, event);\');\'\'

### Bloquear

``` javascript
    function filterKeys(ctrl, event) {
        if (event.key === ',') event.preventDefault();
    }
    <input type="text" value="tralara" width="100px" onkeydown="filterKeys(this, event)" />
```

Also: `event.stopPropagation()`

## Propiedades

### dataset

    <p id="parraf" data-id="1" data-source="component" .../>

Luego para acceder:

    var identifier = document.getElementsById('parraf').dataset.id;

## Eventos

    <... onchange="javascript:manageCheck(this, event);" />

    function manageCheck(element, event) {
      event.stopPropagation();
    }

## Requests

        var request = new XMLHttpRequest();
        request.open('GET', url, true);
        request.onload = function() {
          if (request.status >= 200 && request.status < 400) {
            var resp = request.responseText;
            modalDiv.innerHTML = resp;
            $(modalDivId).modal('show');
          } else {
          }
        };
        request.send();

## JSON

    var elems = [];
    elems.push('1');
    elems.push('2');
    elems.push('3');
    $('#input_hidden_field').val(JSON.stringify(elems)); //store array
    var value = $('#input_hidden_field').val(); //retrieve array
    value = JSON.parse(value);

## Notes

### Replace a tag

    var e = document.getElementsByTagName('span')[0];
    var d = document.createElement('div');
    d.innerHTML = e.innerHTML;
    e.parentNode.replaceChild(d, e);
