# Hadoop ecosystem

## HDFS y YARN

Yarn se utiliza para subir datos o directamente lanzar tareas en HDFS
(el sistema de archivos de Hadoop), que es distribuido. Esto acaban
siendo tareas en batch, que se van corriendo cada hora o cada día.

## Ambari

Es un frontend web para administrar el cluster de Hadoop

## Pig

Pig nos permite asignar un formato a los datos leídos y, con este, hacer
operaciones sobre los datos. Puede utilizar varios gestores de ejecución
como MapReduce o Tez (para executar en memoria, mucho más rápido).

## Spark

Es un motor para ejecutar programas sobre un cluster Hadoop. Substituye
al MapReduce que es únicamente para Java (a pesar de sus ports).

RDD es un objeto que internamente crea Spark para trabajar con datos.

## Hive

Es una forma de lanzar queries parecidas al SQL a un cluster hadoop.
Como Pig, puede ejecutarse sobre MapReduce o sobre Tez.

Se crean tablas de forma paecida al CREATE TABLE de SQL que definirán el
estilo de datos.

Se puede extender Hive con User Defined Functions. También puedes cargar
datos con varias aplicaciones o formatos (avro, xml\...). También se
puede usar con Spark (Spark puede usar Hive para obtener datos).

**Avro** es un formato optimizado para cargar en clusters. Otro formato
para Hadoop es el denominado **Parquet**, Apache Parquet is a columnar
storage format available to any project in the Hadoop ecosystem,
regardless of the choice of data processing framework, data model or
programming language.

## Formas de leer datos en real time

Otra forma distinta a Yarn para leer datos, en vez de hacerlo en batch,
es leerlos por streams. **Kafka** es perfecto para esto, una queue
pub-sub distribuida.

**Storm** puede procesar evento por evento. Se le puede añadir
**Trident**, que permite procesar múltiples eventos a la vez.

Los datos pueden venir de un flujo tipo **Flume**, Logstash, whatever y
se envían a una cola Kafka.

Para procesar los datos puedes hacerlo por eventos (con Storm), o por
pequeños batch (con Spark Streaming).

Para guardar los datos lo mejor es utilizar una base de datos
distribuida, tipo HBase o Accumulo.

## Kafka

Es un sistema distribuido de mensajes. Los procesos que envían datos,
pub, se les llaman produtores. Los que los leen, subs, consumidores.

Los nodos son llamados brokers; la conjunción de nodos Kafka cluster.
Zookeeper controla los mensajes y la sincronización.

## Storm

Procesa flujos de datos, es escalable, tolerante a fallos y garantiza
que los datos serán procesados.

Los datos le llegan como mensajes en formato tupla (la fuente puede ser
Kafka).

Los que consumen los streams (flujos) son llamados bolts, consumen
cualquier número de input streams, los procesan e incluso pueden emitir
streams. Ese procesamiento puede ser ejecutar un procedimiento, filtrar
mensajes, agregar flujos, conectar con la base de datos\...

**Trident** es otra interface que se puede usar en Storm y es más fácil
que este.

## Spark Streaming

Es una alternativa a storm y una de las más famosas librerías en apache.
Puede obtener datos de Kafka, flume, HDFS, ficheros\... Y guardarlos (o
inyectarlos) en HDFS, HBase, dashboards\...

Los datos que llegan en un continuo se les llama DStream (pueden venir
de Kafka).

También puedes guardar el estado (cómo está actualmente el sistema).
Puedes guardar metados en ese \"checkpoint\" y datos. Esto significa que
aunque se joda el sistema, al reiniciarlo mantiene lo que había
procesado.

## HBase & Phoenix

Es una NoSQL DB que utiliza HDFS para guardar los datos. Es perfecta
para acceder a los datos de forma aleatoria, para read/write y en real
time.

En HBase las columnas agrupan column families (CL). Las celdas pueden
tener varias versiones.

Existe una capa para convertir HBase en relacional denominada
**Phoenix**, esta activa SQL sobre HBase.

Phoenix permite crear índices sobre mutable e inmutable (que no van a
sufrir un update) columnas.

## Impala

Impala makes use of many familiar components within the Hadoop
ecosystem. Impala can interchange data with other Hadoop components, as
both a consumer and a producer, so it can fit in flexible ways into your
ETL and ELT pipelines.

## Apache Ranger

**Apache Ranger** permite asignar permisos y autenticación en hadoop.

## Apache Hue

**Hue** is a web-based interactive query editor that enables you to
interact with data warehouses.

## Apache Sqoop

Apache Sqoop is a tool that uses MapReduce to transfer data between
Hadoop clusters and relational databases very efficiently. It works by
spawning tasks on multiple data nodes to download various portions of
the data in parallel. When you\'re finished, each piece of data is
replicated to ensure reliability, and spread out across the cluster to
ensure you can process it in parallel on your cluster.

The nice thing about Sqoop is that we can automatically load our
relational data from MySQL into HDFS, while preserving the structure.

Hive and Impala also allow you to create a schema for the HDFS files
using `CREATE EXTERNAL TABLE` commands. However Sqoop does that
authomatically.

## Notes

-   **Cloudbase** is a group of tools already pre-installed on a Linux
    distribution to make easier the use of Hadoop technologies.
-   ![ETL and
    ELT](/wiki2/hadoop/traditional_etl_vs_elt_on_hadoop.pdf){.align-center}
