# Librerías en Go

## Configuración con Viper

Por ejemplo un fichero como este en `settings.config`:

    api:
      port: 8088
    db:
      connectionstring: 127.0.0.1
      database: marcarrodes

Puede ser leído:

    import "github.com/spf13/viper"

    func configure() {
        viper.AddConfigPath(os.Getenv("MARCARRODES_CONFIG"))
        viper.AddConfigPath("./settings/")
        err := viper.ReadInConfig()
        if err != nil {
            panic(fmt.Errorf("Fatal error config file: %s \n", err))
        }
    }

    func main() {
           ...
           configure()
           ....
           
    En otro módulo:
    config := &bongo.Config{
        ConnectionString: viper.GetString("db.connectionstring"),
        Database:         viper.GetString("db.database"),
    }
    con, err := bongo.Connect(config)
