# Docker Commands

## Basic

### Create and start a container

#### Creating a running a container from an image

`docker run <image name> command`

    docker run busybox echo hi there

#### Create a container

`docker create <image name>`

#### Start a container

`docker start <container id>`

#### Create an image and run a command over it without starting

    docker build -f dockerfile.app -t coop .
    docker run -ti coop python 

### Info about containers

#### See all containers

`docker ps --all`

#### Get the running containers

`docker ps`

#### Remove all containers

`docker system prune`

#### Retrieving logs

`docker logs <container id>`

First, if you just need to see less output, you can have docker only
show you the more recent lines:

    docker logs --since 30s -f <container_name_or_id>

Or you can put a number of lines to limit:

    docker logs --tail 20 -f <container_name_or_id>

### Stop containers

#### Stop a container

\'\' docker stop \<container id\>\'\'

#### Kill a container

`docker kill <container id>`

### Executing commands

#### On a running container

`docker exec -it <container id> <command>`

    docker exec -it b65878 redis-cli

Also\...

    docker exec -it 4e3d15 sh

#### So\...

The idea would be:

1.  `Build` an image.
2.  `Run` the container. Maybe in daemon mode (-d). It will give you an
    id.
3.  `Exec` a command, for example sh, into the container id.
4.  `Ps` the id if required.
5.  `Kill` the id.

```{=html}
<!-- -->
```
    docker build --build-arg http_proxy=http://192.168.40.110:3128 -t svn .
    LASTID=`docker run -d -p 80:80 svn`
    docker exec -ti $LASTID sh
    docker kill $LASTID

### Images

#### List images

    docker images
    docker images debian

#### Build the Dockerfile in the current path

    docker build .

Doing it setting a proxy:

    docker build --build-arg HTTP_PROXY=http://<ip>:<port> .

#### Tagging an image

`docker build -t alfred/redis:latest .`

> `docker build -t dockerid/projectname:version <directory>`

    docker build -t mine/redis:latest .
    docker run mine/redis:latest

#### Rename o re-tagging an image

    docker tag server:latest myname/server:latest

or

    docker tag d583c3ac45fd myname/server:latest

#### Basic commands with images

    docker image ls
    docker image --all # o -a, show intermediate images
    docker image prune 
    docker image prune -a # removes the unused
    docker image inspect # shows info about the image

### Stats and info

    docker stats

Info of sizes:

    docker system df -v

Info about containers:

    docker ps --size

## Docker compose

Build a docker-compose.yml: `docker-compose build`

Run a docker-compose.yml: `docker-compose up`

Build and run as daemon a docker-compose.yml:
`docker-compose up -d --build`

Run only one service: `docker-compose up app`

### docker-compose.yml

#### Set environment variables

    services:
      app:
        build: .
        command: gunicorn OpenAwards.wsgi:application --bind 0.0.0.0:8000
        volumes:
          - ./:/srv/app/
        environment:
          - DB_HOST=db
          - DJANGO_SETTINGS_MODULE=${DJANGO_SETTINGS_MODULE}
    ...

Then:
`env DJANGO_SETTINGS_MODULE=OpenAwards.settings.production docker-coompose up`

## Shortcuts

Imaginemos que tienes un Dockerfile sin **CMD** definido, podrías
construir el contenedor con:

    docker build -f Dockerfile.svn -t svn .

Y luego correr dentro de él con:

    docker run -ti svn sh
