# Docker Notes

## Dockerfile\'s examples

*Dockerfile.svn*

    FROM alpine:3.9

    RUN apk update
    RUN apk add subversion

    WORKDIR /srv

    CMD ["svnserve", "-d", "--foreground", "-r", "/srv"]

    # You can build it with:
    # docker build -f Dockerfile.svn --build-arg http_proxy=http://172.16.1.60:3128 -t svn .

    # Run it with:
    # docker run svn
    # Or even better:
    # docker run -p 3690:3690 -v /home/alfred/tmp/svnsrv:/srv --name svn svn

    # To enter to it you'll do:
    # docker run -ti svn sh

    # Then, to create repos:
    # docker exec svn svnadmin create new-repo

    # From now you can do:
    # svn checkout svn://127.0.0.1/new-repo

## docker-compose examples

    version: '2'
    services:
      mysql:
        image: mysql
        restart: always
        ports:
        - "3306:3306"
        volumes:
        - /home/alfred/tmp/data:/data/db
        environment:
        - MYSQL_ROOT_PASSWORD=the_pass
      php:
        image: my-php
        restart: always
        ports:
        - "8000:80"
        volumes:
        - /home/alfred/php/:/var/www/html
        links:
        - mysql

    version: '2'
    services:
      mysql:
        image: mysql
        restart: always
        ports:
        - "3306:3306"
        volumes:
        - /home/alfred/tmp/data:/data/db
        environment:
        - MYSQL_ROOT_PASSWORD=the_pass
        networks:
        - mynetwork2
      php:
        image: my-php
        restart: always
        ports:
        - "8000:80"
        volumes:
        - /home/alfred/php/:/var/www/html
        networks:
        - mynetwork2
    networks:
      mynetwork2:
        driver: bridge

    version: '2'
    services:
      mysql:
        image: mysql
        restart: always
        ports:
        - "3306:3306"
        volumes:
        - /home/alfred/tmp/data:/data/db
        environment:
        - MYSQL_ROOT_PASSWORD=the_pass
        networks:
          mynetwork2:
            ipv4_address: 10.5.0.5
      php:
        image: my-php
        restart: always
        ports:
        - "8000:80"
        volumes:
        - /home/alfred/php/:/var/www/html
        networks:
          mynetwork2:
            ipv4_address: 10.5.0.6
    networks:
      mynetwork2:
        driver: bridge
        ipam:
         config:
           - subnet: 10.5.0.0/16
             gateway: 10.5.0.1

You can set the property `container_name` to the service. In this way
you will be able to address that container without requiring
`docker-compose` command.

## Linux Alpine use

One of the most used Linux distro with Docker is Alpine. There are
several reasons:

-   It is smaller (30x less than Debian. Debian 123mb, Ubuntu 118mb,
    Alpine 4mb)
-   So it is fast to download.
-   So, not having so many libraries already installed, secure (exploit
    proof).

Alpine package names are [here](https://pkgs.alpinelinux.org/packages).

Alpine uses apk instead of apt-get. Comparison with apt-get:

  ------------------------------ ----------------------
  apt-get update                 apk update
  apt-get install \<packages\>   apk add \<packages\>
  ------------------------------ ----------------------

## Default environment variables in docker-compose

<https://docs.docker.com/compose/env-file/>

Compose supports declaring default environment variables in an
environment file named .env placed in the folder where the
docker-compose command is executed.

Compose expects each line in an env file to be in VAR=VAL format. You
can comment lines with `#`.

Values present in the environment at runtime always override those
defined inside the .env file.

## Trabajar con proxy

### Definir un proxy para las descargas

Para ello debemos editar el fichero
`/etc/systemd/system/docker.service.d/<cualquier-nombre>.conf`. Con el
contenido:

    [Service]
    Environment="HTTP_PROXY=http://proxy.ejemplo:666/"

Luego para reiniciar docker y que pille el proxy:

    $ sudo systemctl daemon-reload
    $ sudo systemctl restart docker

### Definir un proxy en el build

Por ejemplo, si vamos a usar apt con quien podemos definir una variable
de entorno `http_proxy` (para ello se usa el argumento build-arg)
haremos:

    docker build --build-arg http_proxy=http://<ip>:<puerto> .

## Notes

### Eliminar todas las imagenes y contenedores

    # Delete all containers
    docker rm $(docker ps -a -q)
    # Delete all images
    docker rmi $(docker images -q)

### Keep a container running

However, if you really need (or want) to run multiple service in your
Docker container, consider starting from \"[Docker Base
Image](https://phusion.github.io/baseimage-docker/)\", which uses runit
as a pseudo-init process (runit will stay online while Nginx and
Supervisor run), which will stay in the foreground while your other
processes do their thing.

If you are using a Dockerfile, try:
`ENTRYPOINT ["tail", "-f", "/dev/null"]`. You can also run plain `cat`
without any arguments.

If you are running your container with the -t and -d flag, it keeps
running. `docker run -td <image>`. The most important one is the -t
flag. -d just lets you run the container in the background. Here is what
the flags do (according to docker run \--help):

    -d, --detach=false         Run container in background and print container ID
    -t, --tty=false            Allocate a pseudo-TTY

### Mantener un contenedor abierto sin ningún comando

Dockerfile de ejemplo:

    FROM ubuntu:16.04
    # other commands
    CMD tail -f /dev/null

### Problema en docker-compose

Al hacer un `docker-compose up` puede aparecer el siguiente error:

    docker-compose: error while loading shared libraries: libz.so.1: failed to map segment from shared object

Es fácilmente solucionable ejecutando:

    mount /tmp -o remount,exec

### Fully reset the docker system

:!: This remove everything, even volumes.

    service stop docker
    rm -Rf /var/lib/docker
    service start docker

### Change the docker folder

Remember to do `service docker stop` and `service docker start`.

Edit or create the file `/etc/docker/daemon.json`:

    {
        "data-root": "/home/docker"
    }

Default: \"/var/lib/docker\"

## Related software

-   <https://www.portainer.io/> para gestionar los dockers de una
    máquina.

```{=html}
<!-- -->
```
    $ docker volume create portainer_data
    $ docker run -d -p 9000:9000 -v /var/run/docker.sock:/var/run/docker.sock -v portainer_data:/data portainer/portainer

## Problemas con los certificados

**Problema: x509: certificate signed by unknown authority**

<https://stackoverflow.com/questions/50768317/docker-pull-certificate-signed-by-unknown-authority/55260438#55260438>

Import the cert to system, saving the cert to the file:

    openssl s_client -showcerts -connect [registry_address]:[registry_port] < /dev/null | sed -ne '/-BEGIN CERTIFICATE-/,/-END CERTIFICATE-/p' > ca.crt

If the registry root is `arquitectura-public-registry.ajuntament.bcn`
then the address is: `arquitectura-public-registry.ajuntament.bcn:443`.

Copy it to `/usr/local/share/ca-certificates/`:

    sudo cp ca.crt /usr/local/share/ca-certificates/

Then:

    sudo update-ca-certificates

And finish restarting docker: `sudo service docker restart`

It also could require to add the registry to insecure registries in
`/etc/docker/daemon.json`:

    {
      "insecure-registries": [ "nexus.jamgo.org:5000", "hubapp.seuicab.net:5000" ],
      "features": { "buildkit": true }
    }
