# OpenFrameworks Snippets

-   Create image from code (color picker)

``` cpp
float w = ofGetWidth();
float h = ofGetHeight();
float cx = w/2;
float cy = h/2;

img.allocate(w,h,OF_IMAGE_COLOR);

for (float y=0; y<h; y++) {
    for (float x=0; x<w; x++) {
                    
        float angle = atan2(y-cy,x-cy)+PI;
        float dist = ofDist(x,y,cx,cy);
        float hue = angle/TWO_PI*255;
        float sat = ofMap(dist,0,w/4,0,255,true);
        float bri = ofMap(dist,w/4,w/2,255,0,true);
        
        img.setColor(x,y,ofColor::fromHsb(hue,sat,bri));
    }
}

img.reloadTexture();  
```

-   Get color from an image:

``` cpp
ofColor ofxGetPixelColor(ofBaseHasPixels &img, int x, int y, int w, int h, int bpp=3) {
    ofColor c;
    int i = y*w*bpp + x*bpp;
    c.r = img.getPixels()[i+0];
    c.g = img.getPixels()[i+1];
    c.b = img.getPixels()[i+2];
    if (bpp==4) c.a = img.getPixels()[i+3];
    return c;
}

ofColor ofxGetPixelColor(int x, int y) {
    ofImage img;
    img.grabScreen(x,y,1,1);
    return ofxGetPixelColor(img,0,0,1,1);
}
```

-   Juego con rangos de colores

``` cpp
ofBackground( 255, 255, 255 );
// Rango de negro a rojo
for ( int i=0; i<256; i++ ) {
    ofColor color = ofColor::red;
    color.setBrightness( i );
    ofSetColor( color );
    ofLine( i, 0, i, 50 );
}
// Rango de blanco a rojo
for ( int i=0; i<256; i++ ) {
    ofColor color = ofColor::red;
    color.setSaturation( i );
    ofSetColor( color );
    ofLine( i, 80, i, 130 );
}
// Toda escala de colores
for ( int i=0; i<256; i++ ) {
    ofColor color = ofColor::red;
    color.setHue( i );
    ofSetColor( color );
    ofLine( i, 160, i, 210 );
}
```

-   Jugar con noise

``` cpp
ofBackground(0,0,0);
ofSetColor(255);

ofNoFill();
ofBeginShape();
for (int i = 0; i < 500; i++){
    
    float x = i;
    float noise = ofNoise(i/10.0);
    float y = ofMap(noise, 0,1, 0, 100);
    ofVertex(x,y);
}
ofEndShape();

/* 
If you alter the i/10.0, you can adjust the scale of the noise, either zooming in (ie, i/100.0), so you see more details, or zooming out (ie, i/5.0) so you see more variation.

Or with:
float y = ofMap(noise, 0,1, 0, 3) + 10;
to emulate the XKCD trace.

Or with
float noise = ofNoise(i*ofRandomf()/10.0);
To make it animate. Or another way to animate it:
float x = ofMap( ofNoise( ofGetElapsedTimef()), 0, 1, 0, ofGetWidth());
ofCircle(x,200,30);
*/
```
