# YAML

Es otro formato de serialización cual intención es que sea fácilmente
leible por el ser humano.\
La extensión del archivo en el correspondiente formato es `.yaml` o
`.yml`

## Normas

-   El conjunto de carácteres será UTF-8 o UTF-16.
-   La estructura del documento se define indentandolo mediante espacios
    en blanco (no tabs).
-   Los comentarios se inician con `#` y son hasta el final de la línea.
-   Carácteres prohibidos: `@` y `` ` ``
-   Se pueden hacer subapartados iniciándolos con tres guiones `---` y
    finalizándolos con tres puntos `...`.
-   Se pueden incluir directivas precediéndolas por `%`. `%YAML`, por
    ejemplo indica la versión del documento.
-   Cuando se separa una lista con punto o coma el próximo valor deberá
    ser precedido de un espacio para que valores como 5,280 o
    http://www.wikipedia.org puedan ser escritos sin necesidad de
    comillas.
-   Los valores sencillos se pueden insertar sin comillas, pero también
    con comillas dobles o simples.
-   Las listas serán definidas por elementos precedidos por guión o se
    pondrán entre corchetes (\[ \]) y separados por coma.
-   Los arrays asociativos irán de la forma clave:valor. También pueden
    ir uno por línea entre llaves ({ }) y separados por comas. Sus
    valores vienen precedidos por un signo de interrogación ( ? ).
-   Cuando hay un valor entre comillas dobles se puede definir un
    carácter especial como si fuese en C, precedido de \\.

## Elementos

### Listas

    - Casablanca
    - Viridiana
    - Psicosis

O en formato línea:

    [leche, pan, huevos]

### Arrays asociativos (diccionarios)

    nombre: Pepe López
    edad: 33

O en formato de línea

    {nombre: Pepe López, edad: 33}

De listas:

    men: [John Smith, Bill Jones]
    women:
      - Mary Smith
      - Susan Williams

### Bloques de texto

Manteniendo los saltos de línea:

    |
     There was a young fellow of Warwick
     Who had reason for feeling euphoric
         For he could, by election
         Have triune erection
     Ionic, Corinthian, and Doric

Ignorando los saltos de línea:

    >
     El texto rodeado 
     será formateado 
     como un único
     párrafo
     Las líneas en blanco
     denotan saltos de párrafo.

### Forzar tipos

    a: 123                     # integer
    b: "123"                   # string
    c: 123.0                   # float
    d: !!float 123             # float explícito
    e: !!str 123               # string explícito
    f: !!str Yes               # string explícito
    g: Yes                     # boolean true
    h: Yes we have No bananas  # string

### Tipos especiales

    picture: !!binary |
      R0lGODlhDAAMAIQAAP//9/X
      17unp5WZmZgAAAOfn515eXv
      Pz7Y6OjuDg4J+fn5OTk6enp
      56enmleECcgggoBADs=mZmE

Tipo própio:

    myObject:  !myClass { name: Joe, age: 15 }

## Ejemplos

### Documento

    ---
    receipt:     Oz-Ware Purchase Invoice
    date:        2007-08-06
    customer:
        given:   Dorothy
        family:  Gale

    items:
        - part_no:   A4786
          descrip:   Water Bucket (Filled)
          price:     1.47
          quantity:  4

        - part_no:   E1628
          descrip:   High Heeled "Ruby" Slippers
          size:      8
          price:     100.27
          quantity:  1

    bill-to:  &id001
        street: |
                123 Tornado Alley
                Suite 16
        city:   East Centerville
        state:  KS

    ship-to:  *id001

    specialDelivery:  >
        Follow the Yellow Brick
        Road to the Emerald City.
        Pay no attention to the
        man behind the curtain.
    ...

### Inserción de XML

    example: >
            HTML goes into YAML without modification
    message:  |
            <font name='times' size=10>
             <p><i>"Three is always greater than
                    two, even for large values of two"</i>
              </p><p>    --Author Unknown    </p></font>
    date: 2007-06-01

## Notas

-   [PyYAML](/script/python/new/xtra#pyyaml) para leer archivos YAML con
    Python.
