# KML

El formato KML (Keyhole Markup Language) es un estandard basado en XML
utilizado para mostrar información geográfica. Permiten identificar
ubicaciones, añadir imágenes, presentar datos detallados\... Existe una
variante de KML comprimida que es la denominada KMZ.

-   [Referencia](http://code.google.com/intl/en/apis/kml/documentation/kmlreference.html)

## Estructura

### Marcas de posición

Las marcas de posición o placemark permiten marcar una posición
concreta. Incluyen únicamente el elemento \'punto\' (`<Point>`).\
La estructura es la siguiente:

1.  Un encabezado XML, que ha de ser la primera línea del archivo.
    `<?xml version="1.0" encoding="UTF-8"?>`
2.  Una declaración de código kml, la línea
    `<kml xmlns="http://www.opengis.net/kml/2.2">` es la indicada para
    archivos KML 2.2.

``` xml
<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2">
  <Placemark>
    <name>Simple placemark</name>
    <description>Attached to the ground. Intelligently places itself 
       at the height of the underlying terrain.</description>
    <Point>
      <coordinates>-122.0822035425683,37.42228990140251,0</coordinates>
    </Point>
  </Placemark>
</kml>
```

En el ejemplo anterior se define una marca de posición con los
siguientes elementos:

-   Nombre.
-   Descripción.
-   Un punto, que especifica la posición en la superficie de la Tierra
    (longitud, latitud y, opcionalmente altitud).

#### Agregar HTML a una marca de posición

Podemos agregar código html utilizando `<![CDATA[` y `]]>` en la
descripción.

``` xml
<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2">
  <Document>
    <Placemark>
      <name>CDATA example</name>
      <description>
        <![CDATA[
          <h1>CDATA Tags are useful!</h1>
          <p><font color="red">Text is <i>more readable</i> and 
          <b>easier to write</b> when you can avoid using entity 
          references.</font></p>
        ]]>
      </description>
      <Point>
        <coordinates>102.595626,14.996729</coordinates>
      </Point>
    </Placemark>
  </Document>
</kml>
```
