# (X)HTML & CSS

## (X)HTML

### Formato de un documento

Un documento xhtml contiene tags (elementos entre los signos `<` y `>`).
Es decir, está basado en [XML](/tags/xml), por lo tanto sigue su
especificación.\
La base de un documento xhtml cualquiera consiste en una tag principal,
**html**, y dentro de esta el **head** y el **body**. En el body se
encuentra todo el contenido de la web.\
La primera línea que debe contener un fichero xhtml (como todo documento
basado en [XML](/tags/xml) es cualquiera de las dos siguientes, según la
codificación elegida:

``` xml
<?xml version="1.0" encoding="ISO-8859-1"?>
<?xml version="1.0" encoding="UTF-8"?>
```

Si el documento es un .php puede que nos sea más útil (para que no haya
problemas con el parser) utilizar en el bloque `head` el equivalente,
que sería:

``` html
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
```

Para indicar el idioma de la página (es, en, fr, ca\...) lo pondremos
como propiedad en el html:

``` html
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
```

#### Contenido dentro del head

Podemos encontrarnos tags como:

-   **title**: Título del documento.

#### El DOCTYPE

La segunda línea que debe de contener un documento xhtml es la que
indique qué tipo de documento y versión es. De esta forma la página web
puede validarse y a la vez la fuerza a seguir el standard. Las
definiciones más comunes de DOCTYPE son:

-   **strict**

``` html
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/xhtml1-strict.dtd">
```

Ideado para combinar el xhtml con una hoja de estilos CSS, por lo que no
permite tags como **font**, **center**\...

-   **frameset**

``` html
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/xhtml1-frameset.dtd">
```

Una variante del strict pero que permite frames.

### Escribir\\formatear texto

-   **hX**: Todo lo que encierra la tag `<hX>`, siendo *X* un número del
    1 al 6, corresponden a títulos\\cabeceras del documento. A más
    grande la *X* el título será más importante.
-   **p**: Para dividir el texto en párrafos.
-   **blockquote**, **cite** o **q**: Para escribir frases célebres,
    citas\...
-   **sub** y **sup**: Para subíndices y superindices\...
    respectivamente.
-   **del**: Texto tachado.
-   **pre**: Muestra el texto tal y como está escrito, con tabulaciones,
    saltos de línea\...
-   **code**: Para colocar código de programación.
-   **acronym** y **abbr**: Para añadir un acrónimo o una abreviación al
    texto, pondremos la aclaración de lo que significan en la propiedad
    **title**.
-   **br**: Añade un salto de línea, se cierra en la misma tag que se
    abre: **\<br /\>**
-   **hr**, al igual que el br se cierra en la misma tag, coloca una
    línea horizontal.
-   **strong** Para texto en negrita.
-   **em** Para texto enfatizado\... Es decir, cursiva.

``` html
Mi ordenador tiene 512 <abbr title="Megabytes">Mb</abbr> de memoria <acronym title="Random Access Memory">RAM</acronym>.
```

### Listas

Con las tags **ul** y **ol** podemos crear listas; el primero (ul) lo
utilizaremos para listas desordenadas, estas aparecerán con signos como
rombos, cuadrados\..., el segundo (ol) para ordenadas, las cuales
seguirán una numeración.\
Cada elemento de una lista irá entre el tag **il**.

``` html
<h2>Animales:</h2>
<ul>
    <li>Tigre</li>
    <li>Pantera</li>
    <li>...</li>
</ul>
<h2>Cosas a hacer por las mañanas:</h2>
<ol>
    <li>Levantarse</li>
    <li>Desayunar</li>
    <li>Ir al curro</li>
</ol>
```

Podemos anidar listas creando sublistas, únicamente tenemos que insertar
una tag **ul** o **ol** dentro de un **li**.

#### Formatear listar ordenadas

La tag **ol** permite la propiedad **type**, esta formateará los
elementos de la lista según su valor:

-   I: Números romanos en mayúsculas.
-   i: Números romanos en minúsculas.
-   1: Números.
-   A: Letras mayúsculas.
-   a: Letras minúsculas.

``` html
<ol type="i">
    <li>Levantarse</li>
    <li>Desayunar</li>
    <li>Ir al curro</li>
</ol>
```

#### Formatear listas desordenadas

Al igual que **ol**, **ul** también permite la propiedad **type** con
valores que representan el tipo de forma que aparecería:

-   square
-   circle
-   disk

#### Listas de definiciones

Para una lista de definiciones utilizaremos la tag **dl**, a partir de
entonces utilizaremos **dt** (para un término) y **dd** (para una
definición).

``` html
<dl>
    <dt>HTML</dt>
    <dd>HyperText Markup Language</dd>
    <dt>Element</dt>
    <dd>Describes document content.</dd>
</dl>
```

### Tablas

Para organizar los datos en tablas utilizaremos la tag **table**. Una
tabla contiene filas y una fila contiene celdas, en xhtml todas las
filas deben de contener el mismo número de celdas (a no ser que se
especifique lo contrario). Para poder montar la tabla utilizaremos las
tags **tr** y **td**; dentro de la table abriremos y cerraremos los
tr\'s y dentro de cada tr abriremos y cerraremos los td\'s, estos
útlimos corresponden a las celdas.

``` html
<table>
    <tr> <td>A</td> <td>B</td>
    <tr> <td>C</td> <td>D</td>
</table>
```

Dentro de una table podemos añadir otro tipo de tags:

-   Un título mediante la tag **caption**.
-   Una cabecera,título de columnas, si la primera fila en vez de estar
    compuesta por td está compuesta por **th**.

``` html
<table>
    <caption>How to Use Tables</caption>
    <tr> <th>Col 1</th> <th>Col 2</th> <th>Col 3</th> </tr>
    <tr> <td>X</td> <td>X</td> <td>X</td> </tr>
    <tr> <td>X</td> <td>X</td> <td>X</td> </tr>
</table>
```

-   Podemos predefinir las columnas mediante tag **col** y agrupar
    columnas con **colgroup**:

``` html
<table>
    <col width="50px" />
    <colgroup>
        <col width="30px" />
        <col width="30px" />
    </colgroup>
    <tr> <th>Col 1</th> <th>Col 2</th> <th>Col 3</th> </tr>
    <tr> <td>X</td> <td>X</td> <td>X</td> </tr>
    <tr> <td>X</td> <td>X</td> <td>X</td> </tr>
</table>
```

#### Propiedades de table

-   **border**, admite un número y corresponde al ancho del borde.
-   **cellpadding** es el margen entre el borde de una celda y su
    contenido.
-   **cellspacing**, es un número y corresponde a la distancia entre
    celdas.

#### Propiedades de td

-   **colspan** es el número que se amplia la columna, es decir, cuantas
    columnas se extiende.
-   **rowspan** número de filas que se extiende la celda.

### Enlaces y anclas

Para un enlace utilizamos la tag **a**, la página donde apunta estará
indicada en su propiedad **href**:

``` html
<a href="www.google.es">Buscador</a>
```

Podemos poner un tooltip al enlace mediante la propiedad **title**.\
Podemos hacer un link a una parte de la misma página (ancla) añadiendo
una almoadilla al principio de la dirección. La dirección será el
identificador (definido por la propiedad **id**) de la tag:

``` html
<!-- pagina1.html -->
...
<h2 id="comentarios">Comentarios</h1>
...
<a href="#comentarios">Ir a comentarios en esta página</a>
<!-- pagina2.html -->
...
<a href="pagina1.html#comentarios">Ir a comentarios en otra página</a>
```

Existe otra forma de crear un ancla utilizando la tag **a**, para ello
no definiremos la propiedad **href** pero sí la **name**:

``` html
<a name="comentarios" />
```

### Imágenes

Para incrustar imágenes utilizaremos la tag **img**; para ver
exáctamente cómo funciona echemosle un vistazo a sus propiedades:

-   **src**: Indica la dirección de la imágen.
-   **alt**: Una descripción para la imágen que se mostrará cuando no se
    cargue la imágen (obligatorio por razones de accesivilidad).
-   **width** y **height**: El tamaño de esta. Podemos asignar
    porcentajes: `width="50%"`.
-   **title**: El texto del tooltip.

``` html
<img src="imagen.gif" alt="Una imágen cualquiera" /></html>
```

Si quisiesemos que la imágen funcionase como un link deberemos anidar el
tag **img** dentro del **a**.

### Formularios

Los formularios se montan dentro de la etiqueta **form**, a esta
etiqueta podemos añadirle las siguientes propiedades:

-   **action** indica que se hará una vez finalizada la introducción de
    datos; su valor puede ser la dirección de un script al cual se
    enviarán, una función de javascript\...
-   **method** admite los valores *get* o *post*.
-   **enctype** es la codificación del envio de los datos. Con
    `text/plain` enviará texto plano, uo uo uooooo!!!

#### Introducción de datos

A partir de aquí los campos que tendrá el formulario vendrán dados por
la tag **input** y el tipo se distinguirá según el valor de la propiedad
**type** que podrá ser:

-   **text**, se creará un cuadro de texto. Podemos definir un valor por
    defecto asignándolo a la propiedad **value** o, también, definir un
    tamaño máximo asignandolo a la propiedad **maxsize**.
-   **password** mostrará un cuadro de contraseña, funciona igual que el
    de texto sólo que sus letras aparecerán como asteriscos.
-   **checkbox** un cuadro de verificación.
-   **radio** para radiobuttons.
-   **submit** un botón que al clickar se envían los datos.
-   **reset** un botón que al clickar se borran los datos, se resetea el
    formulario.
-   **file** un botón para escoger un fichero.

Según el tipo de campo la tag **input** admite también la propiedad
**size** que corresponde al ancho de este.

#### Otros tipos de campos

Existe otro elemento llamado **textarea** que sustituye al **input
type=\"text\"**, este permite introducir texto en varias líneas. Para
indicar su tamaño utilizaremos sus propiedades **cols** y **rows**.\
Otro campo posible es el combo, para utilizarlo usaremos la tag
**select** y, anidados, todos los elementos del combo en tags
**option**. Una **option** puede tener un **value** que correspondrá al
valor que enviará si esa es seleccionado.

``` html
<select name="peli" id="peli">
   <option value="hope">A New Hope</option>
   <option value="empire">The Empire Strikes Back</option>
   <option value="jedi" selected ="selected">The Return of the Jedi</option>
</select>
```

#### Referenciar datos

Existen, también, otras propiedades que pueden sernos de utilidad a la
hora de tratar los datos que contienen. **name** nos servirá para crear
una variable que tendrá como valor el contenido del campo, para
referenciar esa variable tendremos que hacerlo por el valor de esta
propiedad. **id**, en cambio, será un identificador el cual no podrá
estar repetido en todo el documento.

#### Labels

La forma para asignar un texto que acompañe a un campo de texto es
utilizando la tag **label**, esta permite la propiedad **for** a la cual
asignaremos el nombre del campo que acompañará:

``` html
<label for="nombre">Nombre:</label>
<input type="text" name="nombre"/>
```

#### Fieldsets

Existe una tag, la llamada **fieldset**, que engloba elementos
relacionados de un formulario. A esta agrupación podemos asignarle un
título con la tag **legend**:

``` html
<form>
 <fieldset>
  <legend>Titular:</legend>
  <label for="nombre">Nombre:</label><input name="nombre" type="text" value="" />
  <label for="apellido">Apellido:</label><input name="apellido" type="text" value="" />
 </fieldset>
</form>
```

### Meta tags

Las meta tags son unas tags que se colocan en el **head** a parte de la
**title**, **style** o **script**. Algunas tienen un uso funcional
respecto a la página, es decir, que realizan acciones sobre esta; otras
contienen información general sobre la página muy útil para los
buscadores.

-   `<meta name="keywords" content="las palabras separadas por comas" >`,
    palabras clave que los buscadores utilizarán para la página.
-   `<meta name="description" content="descripción de la página" >`, una
    descripción concisa y clara sobre la web, utilizando un par o tres
    de las keywords más relevantes.
-   `<meta name="robots" content="X">`, para indicar cómo deben actuar
    los robots de búsqueda frente a tu página, siendo X:
    -   *all*, para que el robot indexe y siga los links (valor por
        defecto).
    -   *none*, para que el robot ni indexe ni siga los links.
    -   *noindex*, para que el robot no indexe la página.
    -   *index*, para que el robot indexe la página.
    -   *follow*, para que el robot siga los links.
    -   *nofollow*, para que el robot no siga los links.
-   `<meta http-equiv="refresh" content="30;URL=./index.html" >`, hace
    que se refresque la página cada 30 segundos.

## Trucos (X)HTML

-   Existe la tag **span**, esta no representa gráficamente nada, se usa
    para elegir una porción del contenido y aplicarle un estilo concreto
    ya que soporta las propiedades **id** y **class**.
-   Los comentarios se realizan entre `<!-- ... -->`
-   Si quieres poner un icono en la barra de direcciones (debe de ser de
    16x16) tendrás que usar la siguiente línea en la cabecera:

``` html
<link href="imgs/tiny.ico" rel="icon"/>
<link href="imgs/tiny.ico" rel="shortcut icon" />
<link rel="shortcut icon" href="imgs/tiny.ico" type="image/x-icon" />
```

-   Todos los elementos tienen una propiedad denominada **media**,
    mediante esta indicamos cuando un elemento es visible en pantalla o
    al imprimir. Acepta *print*, *screen* o *all*.
-   Para insertar una imágen .svg utilizamos la siguiente línea:

``` html
<object type="image/svg+xml" data="firewall.svg" width="50" height="50" />
```

-   Podemos desabilitar fácilmente el menú que coloca el IE en las
    imágenes desde la misma imágen o desde la cabecera de la página:

``` html
<!-- deshabilita el toolbar en imagen.gif, pero el html no validará -->
<img src="imagen.gif" galleryimg="no" />
<!-- deshabilita el toolbar en todas las imágenes -->
<meta http-equiv="imagetoolbar" content="no" />
```

## CSS

Una declaración css puede ser añadida en una misma tag o hacerla a
parte.

-   En una misma tag, utilizando la propiedad **style** de esta:
    `<hair style="color:red"`
-   Aparte: `hair {color:red}`

Todo valor de cualquier propiedad se define como `propiedad:valor`, y si
queremos incluir más propiedades las separaremos por `;`:
`propiedad:valor;propiedad:valor;propiedad:valor`.\
Si los estilos los especificamos de forma externa a la tag podremos
ubicarlos en\...

-   Un archivo .css aparte, dentro del head incluiremos:

``` html
<link href="hoja_estilos.css" rel="stylesheet" type="text/css"/>
```

-   En un bloque del head específico para css y sólo accesible por ese
    .html, utilizando el tag: **style**.
    `<style type="text/css"> ... </style>`

Podemos también \"importar\" otra página de estilos, es decir, ponerla
al principio usando `@import url`:

``` css
@import url("prueba2.css");
```

La etiqueta **style** o la **link** permiten la propiedad **media**, con
esta podemos indicar si se aplicará una hoja de estilos cuando se vaya a
imprimir u otra:

``` html
<link rel=”stylesheet” type=”text/css” media=”screen” href=”screen.css” />
<link rel=”stylesheet” type=”text/css” media=”print” href=”print.css” />
<!-- o -->
<style type=”text/css” media=”screen”>@import url(“screen.css”); />
<style type=”text/css” media=”print”>@import url(“print.css”); />
```

### Cómo se definen?

Los colocaremos en la tag **style** o en el archivo .css y en ellos
crearemos bloques del estilo siguiente:

``` css
body {
  background-color: #fff;
  color: #666;
  font-family: Arial, sans-serif;
  font-size: 10 pt;
}
```

La estructura es un selector del bloque, abrimos corchete, propiedades y
valores separados por puntos y coma, y cerramos el corchete. Si el
selector es\...

-   Nombre de una tag de xhtml hace que toda tag reciba ese estilo. El
    ejemplo anterior definía el estilo para todo el body de la página.
-   Nombre precedido por almoadilla (#) se aplicará a todas las tags con
    **id** idéntico al nombre (sin almoadilla).
-   Nombre precedido por punto (.), se creará una clase con ese nombre,
    para aplicarla a los elementos xhtml deberemos usar la propiedad
    **class** de estos y como valor el nombre (sin punto).
-   Dos nombres de tags separados por espacios aplicará el estilo al
    segundo cuando esté anidado en el primero. En el ejemplo 1 se
    aplican a los li que estén dentro de ul.
-   Dos nombres separados por dos puntos (:), el primer nombre
    correspondiente a una tag y el segundo a un estado de esta, por
    ejemplo: `a:visited` o `a:hover`.
-   Dos nombres separados por una almoadilla (#), el primer nombre una
    tag, el segundo un nombre de un id, modifican los elementos de esa
    tag y con esa clase.
-   Dos nombres separados por un punto (.), el primero un nombre de tag
    y el segundo de clase, modificará elementos de esa tag y con esa
    clase concreta.
-   Dos nombres separados por una coma (,), se aplica el estilo a los
    dos nombres de tags.

*Ejemplo 1:*

``` css
ul li {
  color: red;
}
```

La herencia en CSS se basa en que si damos un estilo a un elemento
contenedor todos los elementos dentro de este lo heredarán también. Por
ejemplo si damos un color al texto del body, los textos de las tablas,
de los párrafos y demás también pillarán ese color.\
La cascada aparece cuando dos selectores se especifican sobre un mismo
elemento, entonces se aplica el último definido.

#### Selectores extendidos

-   El \* equivale a algo así como \'todo\', es decir si definimos
    \'\'\* { \... } \'\' estamos diciendo que todo lo que va entre
    corchetes es para toda la página. `form * { ... }` sería todo
    elemento anidado en una tag form.
-   El símbolo \> separa dos nombres de tags, quiere decir que todo
    segundo tag anidado directamente en el primero recibirá el estilo.
    Por ejemplo definir `body > p { ... }` equivale a indicar todos los
    párrafos en el body, pero no en divs.
-   El símbolo + separa dos nombres de tags, indica que sólo se aplicará
    al segundo cuando siga al primero, es decir si hay otro elemento por
    medio no recibirá el estilo: `h1 + h2 { ... }` se aplica a los h2
    posteriores a h1.
-   Podemos especificar a qué tags aplicaremos el estilo según las
    propiedades definidas\...
    -   `p[align] { ... }`, aplica el estilo a los *p* que definen
        *align*.
    -   `p[title=perro viejo]`, aplica el estilo a los *p* que tengan
        definido el valor del *title* como \"perro viejo\".
    -   `p[title~=viejo]`, aplica el estilo a los *p* que tengan
        definido dentro del valor del *title* una palabra \"viejo\".
    -   `p[title|=pe]`, aplica el estilo a los *p* que su valor del
        *title* empiece por \"pe\".

:!: No he conseguido que funcionen: **p\[title=perro viejo\]**,
**p\[title\~=viejo\]** ni **p\[tittle\|=pe\]**.

### Como\...

-   **Indicar colores\...**
    -   Usando sus nombres a saco: *red, blue, black*\... (La tabla de
        colores está al final de esta sección)
    -   Usando código hexadecimal, colocando al principio de su valor
        una almoadilla y luego el código: `#ffff00`
    -   Hexadecimal abreviado, usando hexadecimal de 3 cifras: `#ff0`
-   **Indicar fuentes de texto\...**
    -   Poniendo el nombre de la fuente.
    -   Podemos indicar varias fuentes separándolas por comas, el
        cliente elegirá la primera per si no la encuentra pasará a la
        segunda y así\...
    -   Existen fuentes genéricas: // serif, sans-serif, monospace,
        cursive, fantasy//.
-   **Indicar tamaños\...**
    -   Con píxels, colocando `px`detrás del número: `20px`
    -   Con porcentajes, colocando `%` detrás del número: `30%`
    -   Si es un tamaño de fuente, con puntos, añadiendo `pt` detrás del
        número: `10pt`
    -   Relativos, utilizamos `em` al final del núemero: `1em`. 1m
        significa que es igual al \'por defecto\', 2em el doble que el
        \'por defecto\'\... El \'por defecto\' puede ser el configurado
        del navegador o el del elemento en el que está anidado quien
        recibe esta propiedad. `.5em` es la mitad.
    -   También podemos utilizar palabras clave para los tamaños:
        *xx-small, x-small, small, medium, large, x-large, xx-large*.
-   **Indicar posiciones\...**
    -   Utilizando *top, bottom, left* o *right*.
-   **Poner comentarios\...**
    -   Colocándolos entre: `/* ... */`
-   **hacer cosillas como\...**
    -   Colocar una imágen: Utilizando la notación siguiente:
        `url(imagen)`
    -   Indicar coordenadas: Poniendo dos números separados por coma:
        `20,30`

\*\*Tabla de colores: \*\* ![](/tags/html/csscolors.png){.align-center
width="200"}

### Estilos para contenedores

En los contenedores de las páginas (tags como *body, div*\...)
utilizaremos los siguientes estilos:

-   **background-color** para indicar el color de fondo.
-   **background-image** para indicar la imágen de fondo.
-   **background-attachment** *(fixed \| scroll)*, indica si el fondo es
    fijo o se podrán aplicar scrolls.
-   **background-repeat** *(repeat \| no-repeat \| repeat-x \|
    repeat-y)*, para indicar si queremos que la imágen de fondo se
    repita, no se repita, sólo se repita en horizontal o en vertical.
-   **background-position** para indicar la posición con las palabras
    predefinidas o con dos cantidades o utilizando coordenadas.
-   **visibility** *(inherit \| visible \| hidden )* indica la capacidad
    de visualización del elemento.
-   **cursor** *(inherit \| auto \| crosshair \| pointer \| help \|
    text\...)* Cómo cambia el cursor cuando se pone sobre el contenedor.

Si por ejemplo queremos colocar una imágen en el borde superior haremos
algo así:

``` css
background-image: url(comillas.gif);
background-position: top left ;
background-repeat: no-repeat;
```

-   Podemos indicar también que delante o detrás de un bloque,
    texto\.... se incluya un contenido específico (texto, o una imágen):
    -   Para incluirlo delante: `p:before { ... }`
    -   Para incluirlo detrás: `p:after { ... }`
    -   Para incluir texto propiedad: `content: "texto";`
    -   Para incluir una imágen: content: `url("dibu.gif");`

### Estilos para texto

En tags como *p* y también pueden ir en contenedores como *body,
div*\...

-   **text-align** *(center \| right \| left \| justify)*, para la
    alineación del texto.
-   **font-family** para indicar el tipo de letra.
-   **font-size** el tamaño del texto.
-   **color** indica el color de los carácteres.
-   **text-decoration** *(none \| underline \| overline \|
    line-through)*, para la decoración del texto.
-   **text-transform** *(lowercase \| uppercase \| capitalize)*
    transformación del texto, todo en minúsculas, mayusculas\...
-   **word-spacing** espaciado entre palabras.
-   **letter-spacing** espaciado entre letras.
-   **font-style** *(italic \| normal \| oblique)* para elegir el estilo
    (oblique más cursiva que italic).
-   **font-weight** *(normal \| bold)* para elegir si la fuente será en
    negrita.
-   **text-indent** asigna la distancia que se añadirá al principio de
    la primera línea de un párrafo.

Estados o pseudo elementos:

-   **p:first-letter**: Primera letra de un párrafo.

### Estilos para\...

#### Links

Un link dispone de cuatro estados **link** (normal, sin visitar),
**visited** (visitados anteriormente), **hover** (cuando pasamos el
mouse por encima) y **active** (al hacer click); y, debido a fallos con
algunos navegadores, estos han de definirse en el orden en el que se han
nombrado. Por ejemplo, si queremos que los links sean verdes y al pasar
el mouse por encima rojos:

``` css
a:link {
  color:#0f0;
}
a:hover {
  color:#f00;
}
```

Si queremos quitar el subrayado de un link tenemos que definir el estilo
`text-decoration:none;`.

#### Elementos de un formulario

-   Los **input**, **textarea** y controles del estilo permiten jugar
    con el estado **focus**, correspondiente cuando estos tienen el
    foco.
-   Permiten propiedades como **border**, **border-size**,
    **border-color**, **font**, **background**\...

#### Listas

-   Para definir el elemento que se utilizará para marcar los
    componentes de una lista utilizaremos **list-style-type** que acepta
    *none \| disc \| circle \| square \| decimal*\... entre otros.
-   Para indicar el estilo de sublistas haremos algo parecido a
    `OL OL {list-style-type: decimal}`
-   Podemos dar nuestro marcador de componente con una imágen utilizando
    el estilo: **list-style-image**, que acepta *none \| una url \|
    inherit*.
-   Para indicar el primer elemento de una lista usa el pseudo-elemento:
    `first-child`. (li:first-child)

#### Tablas

## \<div\>

La tag de xhtml **div** crea un bloque\\contenedor en la página, es muy
útil en el momento de agrupar elementos con el mismo formato.\
Sólo una propiedad habita en el maravilloso mundo de las propiedades del
div (a parte, claro está, del id, title, class), esta es **align** y
permite indicar cómo se alineará el contenido de este bloque, admite los
valores: *bottom, left, right, top*.\

### Estilos

-   **width** y **height** tamaño de este.
-   **padding-(top \| bottom \| left \| right)**: Cada una de estas
    propiedades indica el espacio que hay entre el contenido de una div
    y el borde de esta. Podemos definir cada uno de los lados
    individualmente o ponerlo seguido: `padding: 50px 50px 20px 10px;`.
    Esto indica un padding de arriba y abajo de 50px y de los lados de
    20 y 10.
-   **border-width** *(thin \| medium \| thick \| cantidad
    especificada)* grosor del borde.
-   **border-style** *(solid \| dashed \| dotted \| double)* estilo del
    borde.
-   **border-color** para el color del borde.
-   Podemos indicar específicamente que parte queremos cambiar añadiendo
    tras border *-top, -bottom, -left o -right*:
    `border-bottom-color: red;`. También podemos especificar las
    propiedades separadas por espacios:
    `border-bottom: 1px solid black;` o símplemente
    `border: 1px solid black;`. O podemos eliminar el borde con:
    `border: none`.
-   **margin** *que puede ser seguido por: -top, -right, -bottom o
    -left* distancia entre el borde del div y los elementos que la
    rodean.
-   **max-width**, **min-width**, **max-height** y **min-height** para
    definir los anchos y altos mínimos y máximos.
-   **vertical-align** *(baseline \| sub \| super \| top \| text-top \|
    middle \| bottom \| text-bottom)* Indica el alineamiento vertical
    dentro de la div.

### Maquetar con divs

#### Tipos

Existen dos tipos de divs las **inline** y las **block**, las block se
insertar entre el contenido de la página (como si fuesen un párrafo)
separando el contenido anterior del posterior, las inline aparecerían
como una palabra dentro de un párrafo (como\... como un toro, no?), sin
\"romper\" el flujo de la página. Los block no podrían estar uno al lado
de otro. Para definir el tipo, en el estilo de la div usaremos la
propiedad **display** la cual acepta *block* o *inline*.\
Si no se indica lo contrario, las div block irán colocándose una debajo
de otra y las inline una al lado de otra.

``` html
<span style="display:inline">hola</span><span style="display:inline">adios</span>
<br />
<span style="display:block">hola</span><span style="display:block">adios</span>
```

Todos los elementos de xhtml son inline o block. Las características de
los block son:

-   Siempre empiezan al principio de una línea.
-   La altura, el interlineado, los márgenes de arriba y abajo pueden
    ser manipulados.
-   La anchura por defecto es el 100% de su contenido a menos que su
    `width` sea especificada.

Las de los inline:

-   Empiezan en la misma línea que el elemento anterior.
-   Altura, interlineado, márgenes de arriba y abajo no pueden ser
    cambiados.
-   La anchura por defecto es el tamaño de su contenido y no puede ser
    manipulada.

Existen otras posivilildades a parte del block o del inline más
específicas: *none, list-item, run-in* (se mostrará como block o como
inline dependiendo del contexto)*, compact* (se mostrará como block o
como inline dependiendo del contexto)*, marker, table, inline-table,
table-row-group, table-header-group, table-footer-group, table-row,
table-column-group, table-column, table-cell* (necesario si quieres
alinear el texto en vertical)*, table-caption*.

#### Colocación

Las divs permiten la propiedad **position**, esta indica cómo se
colocará la div en la página. Acepta *static* (valor por defecto),
*relative* (la posición del div se define a partir de la posición que le
tocaría), *absolute* (se posiciona en la posición x,y dada por las
propiedades top y left) y *fixed* (calculada a partir de un punto
concreto del browser, si el usuario mueve el scroll la div seguirá
ahí).\
Para indicar posiciones a partir de un punto del div usaremos las
propiedades **top**, **bottom**, **left** y **right**.\
\
Por ejemplo, teniendo:

``` css
div {
 background-color:white; 
 width:100px; 
 height:100px; 
 border: 1px solid black; 
 display: block;
}
```

-   Si queremos colocar una div fija en la esquina inferior derecha
    daremos el valor fixed a la propiedad position y el valor 0 a top y
    right.

``` css
esquina {
 position: fixed;
 bottom: 0px;
 right: 0px;
}
```

-   Si queremos poner una div 10px más abajo de donde sale (pero piensa
    que las siguientes seguirán poniendose donde les toca):

``` css
capa {
 position: relative;
 top: 10px;              /* también podrías usar números negativos */
}
```

-   Si quisiésemos colocar una capa en una posición concreta, pues
    propiedad position a *absolute* y definiríamos top y left también.

#### z-index y overflow

Otra propiedad\... **z-index**. Cuando dos divs se solapan (esto pasa
cuando definimos nosotros la posición) podemos indicar cual estará sobre
la otra, sólo es aplicable a aquellos *div* que tengan position definida
como *absolute* o *relative*. El valor que se le asigna es un número,
mientras más grande sea este más cercana será la capa.\
La propiedad **overflow** corresponde a cómo reaccionará la div si su
contenido sobresale de esta, acepta los valores *visible* (si el
contenido continuará visible por mucho que sobresalga), *hidden* (el
contenido se corta), *scroll* (aparece un scroll que se activa si el
contenido sobresale) o *auto* (como *scroll*, pero sólo saldrá la barra
de scroll sí y sólo sí el contenido sobresale).

#### float y clear

La propiedad **float** no sólo puede aplicarse a divs, también a
párrafos, títulos, imágenes\... su función es que el contenido en vez de
seguir hacia abajo siga hacia otra dirección; acepta *left, right, none*
e *inherit*. Por defecto está a none y, si por ejemplo, tenemos una
div\\imágen y luego un párrafo, si esa div\\imágen tiene `float:left` el
párrafo se colocará a la derecha (recuerda, también podríamos ponerle
padding), y si ponemos `float:right` el texto se colocará a la izquierda
de esta.\
Para complementar a float existe la **clear**, que más que
complementarlo lo que hace es anularlo. Acepta *left, right, both* y
*none*, funciona, utilizando el ejemplo anterior de una imágen con
`float:left` y un párrafo que se coloca a la derecha, añadiendo a las
propiedades del párrafo `clear:left`, entonces se anula el float de la
imágen y el párrafo se coloca abajo en vez de a la derecha. *left* anula
el float del elemento a la izquierda, *right* el de la derecha, *both*
el de ambos y *none* no anula float alguno.\
El float y el clear se han explicado para imágenes y párrafos, pero es
totalmente válido para capas. Por ejemplo podríamos poner 5 capas: una
para título con float a none, 3 para contenido, con float a left y un
pie de página con clear a both. Nos quedaría arriba la cabecera, en
medio las capas y abajo el pie.

``` css
div {
    background-color:white; 
    width:100px; 
    height:100px; 
    border: 1px solid black; 
    display: block;
    overflow: auto;
}
.cabecera {
    width: 300px;
}
.contenido {
    float: left;
    height: 300px;
}
.pie {
    width: 300px;
    clear: both;
}
```

-   Cuando se indica el `float` de un objeto, este se colocará en la
    posición indicada de su contenedor, lo más lejos posible (menos el
    padding), si no existe otro elemento \"flotando\" en ese lado, si es
    así se irá apilando hasta que no quede más espacio en el lado
    contrario donde se indica la \"flotación\". Cuando se acabe el
    espacio pasará a la línea de abajo.

## Trucos CSS

-   Eliminar el borde que añaden los navegadores a las imágenes:
    `img { border: none }`
-   Para cambiar el color del subrayado de un link debemos quitar el
    subrayado por defecto (`text-decoration:none;`) y luego jugar con el
    borde, cuando en enlace está en el estado **link** haremos
    `border-bottom-color:red;` y cuando esté en **hover** haremos
    `border:none;`. Con esta idea y jugando con el padding y el tipo de
    borde puedes personalizar los subrayados.
-   Podemos asignar imágenes de fondo definiendo el **background-image**
    de divs, párrafos, títulos\...
-   Para hacer que las listas se muestren en horizontal haremos:
    `li {display: inline; }`
-   Para que una capa esté centrada le pondremos la propiedad:
    `margin: auto;`\... O\... `margin-left:auto; margin-right:auto;`,
    que es lo mismo.
-   Si vamos colocando elemento tras elemento con (por ejemplo)
    `float:left`, cuando queramos que el siguiente vaya en otra línea
    haremos: `<br style="clear:both" />`
-   Para eliminar el interlineado que queda entre un h1 y un párrafo\...
    -   Definiremos: `h1 {margin-bottom: 0; }` y
        `h1+p {margin-top: 0; }`
    -   O con un margen negativo: `h1 {margin-bottom: 0.5em;}`
-   Puedes aplicar estilos a los **hr**, pudiendo asignar color, borde,
    anchura (en porcentage)\... Pudiendote quedar una línea mu chula.
-   Si asignas el `list-style-image` a un **ol** o **ul** los **li** lo
    heredarán y no necesitarás definir las propiedades de estos. Lo
    mismo que si asignamos una propoiedad (como por ejemplo, color de
    fondo) al **tr** de una tabla, por herencia se le asignará también a
    sus **td** (*recuerda que el `tr` también tiene `hover`*).
-   Eliminar los margenes y el padding \"por defecto\": \'\'html, body {
    margin: 0; padding: 0; } \'\' o \'\'\* { margin: 0; padding: 0; }
    \'\'
-   Añadir bordes a las imágenes: `img {border: 1px solid #000000; }`
-   Para hacer que un link dentro de un contenedor (lista, div\...)
    convierta al contenedor en un botón (cuando se clike en cualquier
    parte de este se llame al enlace) tendrás que adaptar el tamaño del
    link a todo el contenedor asignando: `width:100%; height:100%`.
-   Para que los elementos de un formulario se coloquen seguidos:
    `form {display: inline;}`
-   Para hacer que un botón parezca texto llano o símplemente para
    colocar una imágen anularemos las propiedades `background-color`,
    `border` y `padding`:

``` html
<input style="background-color:transparent; border:0; padding:0; cursor:pointer;" type="submit" value="Enviar >>" />
```

-   Para poner fondos con degradados utiliza una imágen tan larga como
    quieras, pero muy delgada. Y luego:
    `body { background-color: white; background-image: url(background.png); background-repeat: repeat-x; }`.
-   Para hacer dos columnas, una con una imágen y la otra con texto,
    tendrás que envolver el texto en una div y a la imágen asignarle la
    propiedad: `float:left;`. Probablemente necesites también en la div
    el `overflow:hidden`.
-   Una forma para eliminar el margen izquierdo en listas es darles la
    propiedad: `text-indent: -4em;`.

### Botones

#### Anterior\\Siguiente

![ej01.png](/tags/html/ej01.png){.align-center width="150"} Si queremos
hacer un \"menú\" de dos botones (anterior y siguiente) empezaremos,
como en cada menú que se precie, utilizando una lista:

``` html
<ul id="navigation">
 <li class="left"><a href="#">Back</a></li>
 <li class="right"><a href="#">Next</a></li>
</ul>
```

1.  Quitaremos el adorno de la lista:
    `ul#navigation { list-style-type: none; }`
2.  Le quitaremos también la apariencia de lista haciendo que queden los
    dos elementos uno abajo del otro como si fuesen textos
    independientes añadiendo: `margin: 0; padding: 0;`
3.  Colocaremos cada elemento a un lado añadiendo dos definiciones de
    clase más:
    -   `ul#navigation .left { float: left; width: 5em; }`
    -   `ul#navigation .right { float: right; width: 5em; }`
4.  La colocación de una línea sobre ellos no es mala idea, en la clase
    de la lista añadiremos: `border-top: 1px solid #666`
5.  También indicamos en la clase de la lista que haya algo de espacio
    entre la línea y los elementos pero ninguno entre los elementos y
    los bordes modificando el padding: `padding: .5em 0;`
6.  Damos un formato a los elementos de la lista para que se muestren
    como botones:
    -   `ul#navigation li a {display: block; width: 5em; color: #FFF; background-color: #036; padding: .2em 0; text-align: center; text-decoration: none; }`
7.  Y para que quede más bonito, cuando el ratón pase encima del
    elemento que su fondo cambie de color:
    -   `ul#navigation li a:hover {color: #FFF; background-color: #69C; }`

#### Crear botones 3d a partir de links

``` css
a {
    display: block;
    border: 1px solid;
    border-color: #aaa #000 #000 #aaa;
    width: 8em;
    background: #fc0;
}

a:hover {
    position: relative;
    top: 1px;
    left: 1px;
    border-color: #000 #aaa #aaa #000;
}
```

### Menús

#### Menú horizontal

![ej02.png](/tags/html/ej02.png){.align-center width="150"} Tenemos un
menú en forma de lista:

``` html
<ul id="navlist">
 <li><a href="#">Item one</a></li>
 <li><a href="#">Item two</a></li>
 <li><a href="#">Item three</a></li>
</ul>
```

1.  Quitaremos el formato de lista:
    -   \'\' ul#navlist { padding: 0; margin: 0; list-style-type: none;
        }\'\'
2.  Indicamos que los elementos de la lista son elementos *inline*, para
    que se coloquen uno al lado del otro:
    -   `ul#navlist li { display: inline; }`
3.  Hacemos que los links tengan forma de botones:
    -   \'\' ul#navlist li a { float: left; width: 5em; color: #fff;
        background-color: #036; padding: 0.2em 1em; text-decoration:
        none; border-right: 1px solid #fff; } \'\'
4.  Hacemos que los botones cambien al posicionarse el cursor sobre
    ellos:
    -   \'\'ul#navlist li a:hover { background-color: #369; color: #fff;
        } \'\'
5.  Damos a la lista un parecido a menú añadiendo las siguientes
    propiedades a su clase: \'\' float: left; width: 100%; color: #fff;
    background-color: #036; \'\'

### Maquetar

-   Si tenemos tres imágenes y un texto y queremos que a la derecha de
    la página se coloquen las imágenes en columna cambiaremos el estilo
    de estas poniendo `float:right; clear:right;`.

#### 3 columnas

![](/tags/html/ej03.png){.align-center width="150"} Utilizaremos los
siguientes divs:

1.  Uno que lo contenga todo, contenedor.
2.  Uno para el título principal.
3.  Dos para las columnas izquierda y derecha.
4.  Uno para el contenido principal.
5.  Y otro para el pie de página.

``` html
<div id="container">            <!-- 1 -->
 <div id="top"><h1>Header</h1></div>    <!-- 2 -->
 <div id="leftnav">         <!-- 3 -->
  <p>Lorem ipsum ...</p>
 </div>
 <div id="rightnav">            <!-- 3 -->
  <p>Lorem ipsum ...</p>
 </div>
 <div id="content">         <!-- 4 -->
  <h2>Subheading</h2>
  <p>Lorem ipsum dolor...</p>
  <p>Ut wisi enim ...</p>
 </div>
 <div id="footer">Footer</div>      <!-- 5 -->
</div>
```

1.  Empezaremos formateando el contenedor (centrándolo, dándole color,
    incrementando el interlineado\...):
    -   `#container { width: 90%; margin: 10px auto; background-color: white; border: 1px solid gray; line-height: 130%; }`
2.  Ahora formateamos el título:
    -   Primero la div:
        `#top { padding: .5em; background-color: #ddd; border-bottom: 1px solid gray; }`
    -   Luego el título en sí: `#top h1 { padding: 0; margin: 0; }`
3.  Colocamos las columnas de la izquierda y de la derecha:
    -   `#leftnav { float: left; width: 160px; margin: 0; padding: 1em; }`
    -   `#rightnav { float: right; width: 160px; margin: 0; padding: 1em; }`
4.  La columna correspondiente al contenido la adornamos un poco,
    añadimos un par de rayitas a los lados para que quede bien y
    potito\...
    -   `#content { margin-left: 200px; border-left: 1px solid gray; margin-right: 200px; border-right: 1px solid gray; padding: 1em; }`
5.  Y damos el estilo al pie:
    -   `#footer { clear: both; margin: 0; padding: .5em; color: #333; background-color: #ddd; border-top: 1px solid gray;}`
6.  Y para finalizar\...
    -   Empequeñecemos la columna del contenido añadiendo a su clase:
        `max-width: 36em;`
    -   Dejamos tó cucos los márgenes con dos nuevas clases:
        -   `#leftnav p, #rightnav p { margin: 0 0 1em 0; }`
        -   `#content h2 { margin: 0 0 .5em 0; }`

### Estética

#### Bordes redondeados

![](/tags/html/ej04.png){.align-center width="150"} En CSS2 no existe la
posivilidad (de forma stándard) de redondear los bordes de las div, como
mucho puedes utilizar las
[extensiones](/tags/html5css3#bordes_redondeados) que te dan los
navegadores. Aún así existe el truco de colocar 4 imágenes en los
vertices con lo que serían los bordes redondeados de estos, entonces
pinar el fondo del div de ese color y\... tachán! un div de bordes
redondeados!!!.\
Dejo aquí unos posibles bordes: ![link](/tags/html/rounded_border.zip).\
En el ejemplo siguiente se utilizan dos elementos **div** donde se
colocarán los bordes y se colocarán, uno en la parte superior de otra
que sería la contenedora de los datos y el otro en en la inferior. Para
colocar las dos imágenes que representarán los bordes utilizaremos un
elemento **img** para una y para la otra aprovecharemos la propiedad
background de una div, aunque bien podríamos hacerlo con otro img. El
código xhtml es el siguiente:

``` html
<div class="rndbox">
  <div class="rndtop"><img src="top-left.gif" alt="" width="18" height="19" /></div>
  <p>Lorem ipsum dolor sit amet, a at ac aliquet eu nulla nec, consequat cras nulla magna ut, cum incepto. </p>
  <div class="rndbottom"><img src="bottom-left.gif" alt="" width="18" height="19" /></div>
</div>
```

1.  Configuramos el fondo de la página para que coincida con el de los
    bordes: `body {background: white;}`
2.  Añadimos el color de fondo a la div que contiene los bordes
    redondeados: `.rndbox { background: #89AC10; width: 300px; }`
3.  Damos las propiedades a las div superior e inferior, asignándoles la
    imágen de fondo:
    -   \'\'.rndtop { background: url(top-right.gif) no-repeat right
        top; } \'\'
    -   `.rndbottom { background: url(bottom-right.gif) no-repeat right bottom; }`
4.  Acabamos con los últimos retoques, asignando los márgenes al texto y
    colocando el display de la imágen como block:
    -   `.rndbox p { margin: 0 0.4em 0 0.4em; }`
    -   `.rndbottom img { display:block; }`

#### Gráfico dinámico

Podemos crear un gráfico dinámico cogiendo una imágen como la siguiente:
![](/tags/html/slices.gif){.align-center width="150"} Esta tiene una
estructura\... uniforme. Son 20 cuadrados de 30x30 seguidos, por lo que
podemos calcular más o menos a ojo qué porción le toca a qué porcentaje.
Ahora sólo debemos crear una **div** de 30x30 y añadirle una imágen de
fondo, esta estará a una distancia a la derecha concreta, asignada según
qué gráfico queramos añadirle:

``` css
div {
    width: 30px; height: 30px;
    border: 1pt solid black;
    background-image: url('slices.gif');
    font-size: 10pt;
    text-align: center;
}
.graff {
    background-position: -150px 0;
}
```

``` html
<div class="graff">37%</div>
```

De la misma forma podríamos utilizar una barra horizontal para
representar porcentajes. Tendríamo una imágen de, por ejemplo 100x10,
entonces crearíamos una div del mismo tamaño, le asignaríamos como
imágen de fondo la barra pero su posición sería \[el tanto por ciento
que debe representar\] - 100.

### Consejos

-   A un elemento con la propoiedad `float` definida deberías de
    asignarle siempre un width (a no ser que sea una imágen), si no, no
    se sabe cómo reaccionará el navegador.
-   Puedes añadir un `background-color` a los textos (títulos,
    párrafos\...), tal vez te interese ajustar el padding para que
    queden bien.
-   Piensa que siempre es mejor utilizar medidas relativas a fijas, y
    hay casos concretos en los que es obligatorio (por ejemplo en los
    `line-heigh`).
-   Cuando empieces una página resetea los valores \"por defecto\" de
    los navegadores.
-   Separa el documento de estilos en bloques: los de la página, los de
    de tipografía y posición\...
-   Organiza el código css en un sólo documento maestro, a partir de él
    importa otros (reset.css, global.css, flash.css,
    estructura.css\...).
-   Intenta colocar los mínimos contenedores posibles, a veces párrafos,
    textos, imágenes\... pueden colocarse de la misma forma sin
    necesidad de una div.
-   Intenta utilizar el menor número de propiedades CSS, recuerda que
    hay algunas que se pueden agrupar en una (`border`,
    `background`\...).
-   Cuando vayas a utilizar los estados del link recuerda su orden:
    LoVe\\HAte (*link, visited, hover, active*).
-   Configura la página para que pueda ser correctamente imprimble.
-   Si el contenedor tiene un ancho variable define un `min-width` para
    este.

## Notas

-   Recuerda, en css, propiedades como el padding, el float\... Pueden
    aplicarse a otros elementos como los textos, las imágenes\...
-   Cuando se define el `float` de un elemento se crea algo llamado
    **inline box**, esto es, un rectángulo imaginario en el cual van
    colocándose los elementos a los que afecta este `float`.
-   Existe el color: `transparent`. Lo digo porque puedes asignarlo como
    `border-color`, `background-color`\... Y hasta aquí puedo leer.
-   Las tags **div** y **span** son elementos neutros, contenedores
    block (div) o inline (span).
-   El id debe de ser único en el documento, por ello al utilizar un
    **#selector** debe ser para un único elemento. En cambio las clases
    **.selector** son para varios tipos.
-   Recuerda, el `margin` corresponde a la distancia que se deja entre
    el borde y el margin del siguiente elemento. El padding es la
    distancia de los datos de un contenedor con el borde de este.
-   Cuando crees una div `inline` con tamaño, para que este sea
    utilizable, selecciona también su float.
-   Recuerda que si quieres alinear el texto en vertical en una div
    tendrás que dar la propiedad `display:table-cell` a la div.
-   Puedes validar un formulario desde una función javascript agregando
    el evento `onSubmit="return funcion()"` al form. Si la función
    retorna false el formulario no se enviará.
-   Recuerda que para poner el cursor como una mano sería:
    `cursor: pointer;`

### Orden de propiedades

Por si quieres ponerlas en una sola línea:

-   *border:* border-width border-style border-color
-   *background:* background-color background-image background-repeat
    background-attachment background-position
-   //margin: // margin-top margin-right margin-bottom margin-left
-   //padding: // padding-top padding-right padding-bottom padding-left

### Enlaces

-   [Web de referencia de
    CSS](http://www.w3schools.com/css/css_reference.asp)
-   [Otra web de referencia de
    CSS](http://www.htmldog.com/reference/cssproperties/)
-   [Esta de tags XHTML](http://www.htmldog.com/reference/htmltags/)
