# Vim

El editor `vi` podemos encontrarlo en dos comandos: la primera versión
`vi` y una versión actualizada `vim`. Utilizaremos la segunda versión.\
Para editar un archivo lo utilizaremos de la siguiente forma:
`$ vim nombre_archivo`.\

## Modos

Vim puede alternar entre distintos modos:

  ----------- ---------------------
  **Tecla**   **Modo**
  `i`         Edición o inserción
  `Esc`       Modo comando
  ----------- ---------------------

## Comandos

  ------------------------ --- ---------------------------------------------------
  \*\*De movimiento \*\*       
  h k l j                      En este orden: izquierda, arriba, derecha, abajo
  cursores                     También pueden ser usados para moverse
  :2                           Va a la línea 2
  \$                           Se posiciona al final de la línea
  0                            Se posiciona al principio de la línea
  w                        b   Salta hacia alante (o hacia atrás) entre palabras
  ------------------------ --- ---------------------------------------------------

  --------------- --------- --------------------------------------------
  **Generales**             
  :q              :q! :wq   Salir, Salir sin guardar y salir guardando
  :e fichero                Abrir fichero
  :w                        Guardar cambios
  --------------- --------- --------------------------------------------

  ------------- -------- --------------------------------------------
  **Edición**            
  dd            3dd      Eliminar línea actual, o eliminar 3 líneas
  D                      Borrar hasta el final de la línea
  u             ctrl+r   Deshacer o hacer
  ------------- -------- --------------------------------------------

  -------------- ------- --------------------------------------------------------
  **Búsqueda**           
  /word          ?word   Busca la palabra de arriba a abajo o de abajo a arriba
  \*                     Va a la siguiente palabra igual en el texto
  n              N       Siguiente o anterior resultado
  -------------- ------- --------------------------------------------------------

  ----------------------------- ---------- -----------------------------------------------------------
  **División de la pantalla**              
  :sp file                      :vs file   Divide la pantalla (horizontal o vertical) y abre fichero
  ctrl+w cursor                            Mueve entre divisiones de pantalla
  :q                                       Cierra la división actual
  ----------------------------- ---------- -----------------------------------------------------------

## Notas

### Cheat sheets

-   ![Cheat sheet 1](/sistemas/doc/vi_cheat_sheet.pdf)
-   ![Cheat sheet 2](/sistemas/doc/vimqrc-es.pdf)
