# En resumen: Linux (old)

## Documentación

### Organización del manual

El manual de linux está dividido en en pequeños manuales
correspondientes a cada uno de las herramientas instaladas, para acceder
al manual de una herramienta haremos: `man grep`, siendo grep la
herramienta que queremos consultar. Cada uno de estos manuales se
agrupan por las siguientes secciones:

1.  Comandos de shell
2.  Llamadas al sistema
3.  Llamadas a librerías
4.  Ficheros especiales (generalmente los de /dev)
5.  Formatos y convenciones
6.  Juegos
7.  Miscelania
8.  Rutinas no standard del kernel

-   Cuando consultemos una herramienta nos aparecerá su nombre y un
    número entre paréntesis: *grep(1)*, este corresponde a la sección
    que estamos mirando actualmente.
-   Puede ser que una herramienta esté en varias secciones, para saber
    en qué secciones se encuentra esa herramienta haremos:
    `man -f grep`. Si queremos acceder a un manual en una sección
    distinta haremos: `man 6 grep`.

### Más sobre el manual

Si buscamos unas páginas del manual correspondientes a un tema pero no
sabemos qué herramientas estan relacionadas con este utilizaremos
cualquiera de los siguientes comandos. Por ejemplo buscamos un manual
sobre *count words*:

-   `apropos count words`
-   `man -k count words`\

Para saber la ubicación de los archivos del manual edita el documento:
`/etc/manpath.config`\
Para formatear una página del manual para hacerla imprimible utiliza el
parámetro `-t`.

### Errores en el manual

-   Si sabes hemos instalado un programa pero man no nos encuentra su
    manual, podremos hacer varias cosas:
    -   Buscar el archivo del manual: `whereis -m cat`
    -   Cargar el archivo encontrado: `man dirección_del_archivo`
    -   Reconstruir la base de datos del manual: `mandb`
-   Si no podemos utilizar el comando `man` existen otros que pueden
    sernos de utilidad: `zless` y `zcat`. Los cuales sirven para leer
    archivos de texto comprimidos.

### Uso del \'info\'

Existe otro comando para leer en otro el manual de linux, este es
`info`.

-   `info comando` nos mostrará el manual para dicho comando.
-   La salida de info es imprimible por defecto.

## Logs

El sistema de logs se arranca con `/etc/init.d/sysklogd` el cual inicia
dos daemons:

-   **syslogd**, que gestiona los logs del sistema (mensajes a archivos,
    tuberías, usuarios\...) usando la config en `/etc/syslog.conf`.
-   **klogd**, que gestiona los logs del kernel.

Los logs se guardan en el directorio `/var/log`, pueden crecer tanto que
pueden llegar a ser muy extensos de ahí que exista una tarea
(`/etc/cron.daily/logrotate` que los comprime y aplica una rotación).
Los logs más importantes son:

-   `/var/log/messages`: Log global.
-   `/var/log/kern.log`: Log del kernel.
-   `/var/log/auth.log`: Log de logins del sistema (fallos de
    acceso\...).
-   `/var/log/dmesg`: Log que almacena la información del kernel durante
    el arranque del sistema. Podemos ver su contenido con el comando
    `dmesg`.
-   `/var/log/boot.log`: Log de arranque.

## Otros

### AWK

      awk '{print}' txt
          Hace un print del archivo txt
      echo askfdjkls | awk '{print length($0)}'
          Nos devuelve el tamaño de 'askfdjkls'
      echo hola pepe tas bien | awk '{print index($0, "a")}'
          Devuelve la primera posición de 'a'
      echo $caption | awk '{print substr($0,12,8)}'
          Hace un substr del valor de caption, desde la posición 12, 8 carácteres
      awk -F: '{print $1}' /etc/passwd > user.txt
          Recoge el fichero /etc/passwd y escribe lo que hay antes de ':' en user.txt
      du -a | awk 'BEGIN {s=0} {s = s + 1} END {print s}'
          Cuenta las líneas del retorno del du -a

## Comandos

  ------------------------------------------------------------ -----------------------------------------------------------------------------------------------------------------------
  **Comandos para la navegación por directorios y ficheros**   
  pwd                                                          Directorio donde estamos
  ls -a                                                        Nos lo muestra todo todo todo de ese directorio
  ls -l sudoers                                                Podemos ver propietario, grupo, permisos\... de sudoers
  file fi                                                      Muestra información sobre el fichero \'fi\'
  cd                                                           Volver a la home, igualmente esta queda representada como `~`, es decir, es equivalente a `cd ~`
  whereis python                                               Indica donde está el ejecutable de \'python\'
                                                               
  \*\*Comandos para archivos \*\*                              
  du -sh                                                       Devuelve la cantidad de espacio usada por un archivo
  rm -R directorio                                             Elimina todo el directorio de forma recursiva
  touch n                                                      Crea un archivo vacío llamado \'n\'
  wc txt                                                       Nos dá del fichero txt: nº de lineas, nº de palabras, nº de caracteres
  chown root:root sudoers                                      Cambia el propietario y el grupo de sudoers a root
  chmod 704 sudoers                                            Cambia los permisos de sudoers
  mv perro gato                                                Renombra el archivo con el nombre perro a gato
  ln -s origen destino                                         Crea un enlace simbólico
                                                               
  **Comandos de información del sistema**                      
  uname -r                                                     Versión del kernel (también puedes usar kernelversion), -a muestra información extra
  free                                                         Muestra la memoria usada, para que la muestre en megabytes: `-m`
  df -hT                                                       Muestra la cantidad de HD usada
  ps -aux                                                      Ver los procesos activos
  jobs                                                         Ver trabajos
  whoami                                                       Devuelve el nombre del usuario logueado
  hostname                                                     Devuelve el nombre de la máquina
  id usuario                                                   Devuelve el UID, GID del usuario indicado.
  fdisk -l                                                     Se nos muestra un listado con la información actual de los discos insertados en el sistema.
  date                                                         Devuelve la fecha del sistema.
  time                                                         Devuelve la hora del sistema.
  time ls                                                      Devuelve el tiempo que tarda en ejecutarse un ls
  history                                                      Devuelve los últimos comando ejecutados.
  top                                                          Lista de procesos ordenados por consumo de cpu
  lspci                                                        Lista los dispositivos pci instalados en el ordenador
  uptime                                                       Indica el tiempo que lleva el sistema encendido
  lsusb                                                        Lista los puertos usb disponibles
                                                               
  **Comandos de sistema**                                      
  kill 4%                                                      Elimina el job 4.
  kill -9 233                                                  Elimina el proceso 233
  fsck\\reiserfsck                                             Comandos para comprobar el hd
  shutdown \[-h\|-r\] now                                      \[-h: Apaga el sistema \| -r: Reinicia el sistema\] (aunque puedes usar halt o reboot directamente)
  chroot directorio                                            Cambia el directorio raíz actual por el indicado.
  sync                                                         Sincroniza un dispositivo, útil antes de desmontar un pendrive.
  lsof \| grep /dev/hda1                                       Muestra qué comando está utilizando /dev/hda1
  hdparm -w /dev/hda1                                          Desbloquea una unidad, en este caso /dev/hda1
  chkconfig                                                    Devuelve información del estado de los servicios.
  dmesg                                                        Devuelve los últimos mensajes de error del sistema (del último comando).
  e2label                                                      Asigna la etiqueta de una partición.
                                                               
  **Comandos de sesión**                                       
  su                                                           Conmutar a modo superusuario
  login                                                        Loguearse
  exit                                                         Acabar sesión
                                                               
  **Comandos útiles**                                          
  clear                                                        Borra la consola
  ls \> fi                                                     Mete la salida del ls en un fichero \'fi\' borrando su contenido
  ls \>\> fi                                                   Mete la salida del ls en un fichero \'fi\' sin borrar su contenido
  man -k init.d                                                Busca las páginas del manual que contienen \'ini.d\'
                                                               
  **Comandos para internet y redes**                           
  wget httpfile                                                Descarga un archivo de una dirección http
  w3m                                                          Navegación http por consola
  netstat                                                      Muestra información sobre la red, puedes usar los parámetros: -putan
  ip addr                                                      Muestra información sobre la IP asignada. `ip addr show eth1` Muestra la del dispositivo eth1
  ifconfig                                                     Muestra información de las interfaces de red.
  iwconfig                                                     Configura una red inalámbrica. Indicas todas sus propiedades (ssid, clave\...) y luego haces un commit.
  iwlist                                                       Si dispones de una interface de red wifi, este comando listará por esa interface las redes inalámbricas enconctradas.
  ------------------------------------------------------------ -----------------------------------------------------------------------------------------------------------------------

# Linux - Notas

### Recuperar GRUB tras instarlar Windows

1.  Ejecutaríamos un live cd y entraríamos a la consola.
2.  Entraremos como root: `sudo su`
3.  Montaremos la partición donde está instalado el sistema operativo:
    `mount /dev/sda6 /mnt`
4.  Lanzaremos la siguiente orden:
    `sudo grub-install --root-directory=/mnt/boot /dev/sda`
5.  O si no funcionase:
    `sudo grub-install --root-directory=/mnt/boot /dev/sda --recheck`

### Varias

#### Montar una ISO

    mount "AI Techniques Examples.iso" /mnt -o loop
    umount /mnt

#### Contar el número de líneas de código

    $ cat `find . -name *.java` | egrep ";" | wc -l

### Accesos directos

1.  Redireccionar la salida de un comando a otro: `ls | sort`
2.  Guardar en un fichero la salida de un comando, eliminando el
    contenido: `ls > fichero`, añadiendo a lo que ya hay `ls >> fichero`
3.  Llamar a comando anteriores con los cursores o escribiendo las
    primeras letras y haciendo repetidamente `ctrl + r`
4.  Autocompletar nombres de archivos y de comandos, poniendo las
    primeras letras y pulsando `TAB`.
5.  Usar alias: `ls='ls-l`\'

## Administración de un server

### Dispositivos

#### LaFonera

Pequeño router que viene con un OpenWrt instalado.

#### Activar el SSH

Tiene instalado, pero no activado, dropbeard. Sólo tendremos que lanzar
el comando por consola para que nos deje entrar por ssh, para ello
debemos hacerlo mediante la interface web. Crearemos una página con este
código y lanzaremos el comando que activa el server:

``` html
<html>
<head></head>
<body>
<form method="post" action="http://192.168.10.1/cgi-bin/webif/connection.sh" enctype="multipart/form-data">
<input name="username" value="$(/etc/init.d/dropbear)" size="68">
<input type="submit" name="submit" value="Submit" />
</form>
</body>
</html>
```

Podremos entrar como root y hacer que el dropbeard se inicie
automáticamente haciendo:\
`ln -s /etc/init.d/dropbear /etc/init.d/S50dropbear`

### Otros

#### Atajos

      ctrl+l      Borrar pantalla
      alt+ctrl+Fx Cambia de terminal
      alt+F2      Ejecutar (gráfico)
      ctrl+alt+esc    En KDE para cerrar una aplicación a la fuerza
      ctrl+esc    Ver los procesos activos
      ctrl+alt+bckspc Reiniciar X
      shift+<cursor>  Subir\bajar por la consola

-   **alias listaInstalados=\"dpkg -l\"** Asigna un alias, cuando se
    llame a listaInstalados se ejecutará: \'dpkg -l\'

### Trucos Linux

-   Desde los entornos gráficos podemos acceder a servidores ssh,
    samba\... utilizando en la barra de direcciones el protocolo
    adecuado, como por ejemplo:
    -   `ssh://192.168.1.10` -\> Accede a server ssh
    -   `smb://192.168.1.10` -\> Accede a server samba
    -   `fish://192.168.1.10` -\> Accede a server ssh
-   Podemos copiar\\pegar seleccionando con el mouse y haciendo botón
    central en otro sitio.

#### Ver temperatura CPU

Instalamos el paquete acpi: `sudo apt-get install acpi`

-   Para ver tanto el estado de la batería como la temperatura del
    procesador: `acpi -t`
-   Si queremos ver toda la información posible ( temperatura, batería,
    y estado del cargador de corriente ): `acpi -V`
-   Y para ver cualquiera de estas informaciones en tiempo real, usamos
    el útil comando watch: `watch acpi -V`

### Notas

-   Un usuario que no sea el root no podrá abrir puertos de red más
    pequeños que el 1024.
-   El fichero *.bashrc* que hay en todos los home de todos los usuarios
    corresponde a todos los comandos que se ejecutan cuando inician
    sesión independientemente. Si queremos ver el fichero global que
    inician todos iremos a */etc/profile*.
-   Crear una iso rápidamente: *cat /dev/cdrom \> imagen.iso*
-   El log del sistema lo encontrarás en// /var/log/messages//
-   Podremos ver qué dispositivos usan qué IRQs en */proc/interrupts*
-   El comando *wget* recoge algún archivo de red o simplemente llama a
    una web.
-   El comando *run-parts* al cual se le indica un directorio ejecuta
    todos los archivos ejecutables de este.
-   Si quieres introducir más de un solo comando en la consola
    únicamente tendrás que separar estos por **;**.
-   Si quieres lanzar un comando con su tendrás que utilizar el
    parámetro `-c`: `su -c "comando"`
-   Es posible que montes una partición smb para hacer backups, puede
    que algunos ficheros tengan letras con acentos o Ñs, para que
    funcione bien deberás añadir las siguientes opciones:
    `-o codepage=cp850,iocharset=utf8,username=...`, siendo codepage el
    code page del server (el windows) e iocharset el del que envia
    (linux).
-   Para saber la temperatura de la cpu desde la consola consulta:
    `/proc/acpi/thermal_zone/<...>/temperature`.
-   Recuerda que puedes acceder a los logs de una aplicación desde
    `/var/log`, por ejemplo: `/var/log/apache2/error.log`.
-   Puedes lanzar un comando en segundo plano (o en *background*)
    añadiendo `&` después de su llamada.
-   `ls -lah` hará un ls pero mostrándolo *guay*, con los tamaños como
    megas, bytes\...

### Documentos

-   [Documentos](/sistemas/linux/biblioteca)
