# Sistema Linux (old)

## mount & fstab

El fichero */etc/fstab* es un archivo de texto que se lee al inicio del
sistema, en él se indican los dispositivos de disco que se montarán al
cargar. Este dispositivo puede ser desde un pendrive, pasando por un
CD-ROM hasta una partición en red.

### Mount

Antes de explicar el fstab es básico entender el **mount**; al llamar a
este comando lo primero que se indica es el tipo (ext3, cifs, vfat,
usbfs\...), para indicar el tipo pondremos **-t** pero podemos dejar
esto por defecto sin poner nada, indicaremos también dónde se encuentra
el elemento a montar y luego el punto de montaje (donde se montará), de
esa forma los archivos que en él se encuentran pasarán a estar (también)
en el punto de montaje:

    mount -t vfat /dev/hda4 /windows/c

Puedes indicar opciones adicionales, estas son las mismas que son
indicadas en el fstab. Para indicarlas tendrás que usar **-o** seguido
de estas opciones y, si hay varias, separarlas por comas.\
El comando mount por si solo muestra información de lo montado
actualmente.

-   [Montar carpetas
    compartidas](/sistema/linux/samba#montar_carpetas_compartidas)
-   [Montar una iso](/sistema/linux/notas#montar_una_iso)

### Formato del fstab

El formato es el siguiente:\
**\<sistema de ficheros\> \<punto de montaje\> \<tipo\> \<opciones\> 0
0**\
Sistema de ficheros, punto de montaje ya los hemos visto antes, los dos
ceros finales tienen un significado, pero no profundizaremos en él.
Veamos las opciones:

-   **rw** Es posible leer y escribir (read-write)
-   **ro** Sólo lectura (read only)
-   **exec** Permite la ejecución de ejecutables
-   **noexec** Impide ejecutar
-   **auto** Se indica que se inicie junto con el sistema
-   **noauto** Para que no se monte al inicio sino cuando se va a usar
    (disketeras, cds\...).
-   **users** Permite a los usuarios del sistema montar\\desmontar sin
    ser root.
-   **uid** y **gid** Indica el nombre de usuario y de grupo para quien
    se montará el dispositivo.
-   **pass** y **user** Password y usuario si el dispositivo los
    necesita
-   **credentials** archivo externo donde se guardan nombre de usuario y
    password del dispositivo, de forma externa.
-   **fmask** y **dmask** 3 valores octales para indicar los permisos de
    ficheros y directorios.
-   Si no se indica nada o se indica **defaults** se darán las opciones
    por defecto: *rw,suid,dev,exec,auto,nouser*.

### Montar automáticamente discos USB

Existe una aplicación denominada
[usbmount](http://usbmount.alioth.debian.org/), esta permite que al
insertar un disco usb este se monte automáticamente en el sistema.\
Monta los discos automáticamente en `/media/usb0`, `/media/usb1`\...\
La configuración se encuentra en `/etc/usbmount/usbmount.conf`.

### Ejemplos

    //oz/WWW    /mnt/www    smbfs   credentials=/etc/cred,gid=disknet,fmask=770,dmask=770   0   0

Este ejemplo monta en /mnt/WWW un sistema de red, recogiendo los datos
de \'logueo\' para este de /etc/cred, montandolo para el grupo disknet y
dando unos permisos de 770 para los ficheros contenidos en este y de
770, también, para los directorios.

    /dev/hda1  /windows/C  ntfs-3g     user,users,gid=users,umask=0002  0 0

Este ejemplo monta en /windows/C una partición ntfs permitiendo la
lectura y escritura (esto es gracias al `driver` ntfs-3g).

## Samba

-   Podemos volver a la pantalla donde configuramos Samba cuando lo
    instalamos mediante el comando *sambaconfig*.

### Demonios

-   **smdb** Maneja los recursos compartidos cliente-servidor Samba
    (impresión, visualización, compartición\...).
-   **nmbd** Servidor de nombres que emula la funcionalidad de un
    servidor WINS y NetBIOS.

### smb.conf

-   **/etc/samba/smb.conf** es el fichero de configuración de Samba.
-   Los \# y los ; son los comentarios.
-   Una vez modificado necesitarás reiniciar el sistema con:
    */etc/init.d/samba restart*

#### Zonas

-   **\[global\]**, donde irá la información usada por todos los
    usuarios.
    -   **workgroup**, grupo de trabajo.
    -   **encrypt passwords**, si vamos a usar en redes con windows de
        versión mayor a la 98.
    -   **netbios name**, nombre netbios.
    -   **hosts allow** indica el rango de ips permitidas para
        conectarse a la máquina. Para indicar un rango se hace
        \'192.168.1.\' y de esta forma entrarían todos con ip
        198.168.1.x:

```{=html}
<!-- -->
```
          * hosts allow = 192.168.1. 127.
    * **[etiqueta directorio]**, para cada directorio que decidamos compartir.
      * **path**, ruta del directorio que compartiremos.
      * **read only = [yes|no]** indicará si el directorio usado es de solo lectura.
      * **guest ok = [yes|no]** indicará si permitimos o no al usuario invitado entrar en nuestro sistema.
      * **browsable = [yes|no]** si podrá ser visto en la lista de recursos compartidos.

#### Ejemplo

    [global]
    workgroup = MICASA
    encrypt passwords = yes
    netbios name = arturito
    hosts allow = 192.168.1. 127.
    [docs]
    path = /home/alfred/myDir
    browseable = no
    read only = yes
    guest ok = no

### Montar carpetas compartidas

Para poder hacer esto necesitamos tener instalado el paquete **smbfs**,
luego, para desmontar podemos usar de igual manera el **umount**.

El paquete nos instala un nuevo comando: *smbmount* que es el que nos
permite montar mediante la siguiente sintaxis:

-   **smbmount //192.168.1.2/Downloads /mnt -o password=hola**.
-   **smbmount //192.168.1.2/Downloads /mnt -o passwd=hola**.

Aunque también nos permite añadir (o utilizar en el archivo fstab) un
nuevo tipo: el *smbfs*.

-   **mount -t smbfs -o password=hola //192.168.1.2/Downloads /mnt**

Luego, con hacer *umount /mnt* ya estaría desmontada.

Para **montar al iniciar el sistema** tendremos que añadir una línea al
*/etc/fstab*:

    //192.168.1.2/Downloads    /mnt/smb    smbfs     credentials=/etc/cred 0 0

Y, por lo tanto en este caso, crear el fichero /etc/cred con lo
siguiente:

    username = alfred
    password = alfredspass

#### CIFS

A dia de hoy el *smbfs* parece estar en desuso, para montar una carpeta
de red utilizaremos el `Common Internet File System`: **cifs**.\
La utilización de este es idéntica a la del smbfs; también necesitaremos
tener instalados los paquetes de samba.\
`mount -k cifs //192.168.1.10/APPS /mnt
mount.cifs //192.168.1.10/WWW /mnt -o credentials=/cred
mount.cifs //oz/WWW /home/alfred/public_html -o uid=alfred,pass=thepass
`

### SWAT

Es una interfaz web para configurar SAMBA de una forma gráfica.

#### Instalar

    apt-get install swat

Reiniciamos máquina.

#### Acceder

    http://<ip>:901

El nombre de usuario y el password tendrán que ser uno de la máquina que
se está administrando. Los permisos para ese usuario serán los mismos
que tenga para modificar el fichero `smb.conf`.

### Como\...

#### Añadir una carpeta compartida

1.  Vamos al menú `Shares`.
2.  Creamos el *share* que queremos, el nombre que pongamos será con el
    que se comparta.
3.  En *path* indicamos la ruta de la carpeta.
4.  Indicamos \"*available*\", \"*guest ok*\" y \"*browsable*\" como
    *yes*.

La carpeta tendrá que tener los siguientes permisos:

    chown nobody:nogroup smbtest/
    chmod 555 smbtest

O si queremos que también sea modificable:

    chmod 755 smbtest

## El inicio de Linux y sus demonios

### Inicio del sistema

El arranque del operativo, tras el inicio del hardware, carga siempre
los siguientes elementos y en el siguiente orden:

1.  BIOS
2.  MBR
3.  BootLoader
4.  Kernel
5.  init

#### La BIOS y el MBR

Una vez la máquina arranca se carga en memoria la BIOS, esta gestiona al
nivel más bajo todos los periféricos y busca el dispositivo adecuado
para iniciar el sistema (diskette, CD-ROM, HD\...). Si puede, carga el
programa que reside en el primer sector del dispositivo (MBR), este es
de 512 bytes y contiene instrucciones para el arranque del sistema
(bootloader); una vez cargado el control del arranque pasa a ser suyo.

#### El bootloader

En Linux los dos bootloaders más utilizados son el LILO y el GRUB. Un
bootloader se divide en dos fases, la primera consiste únicamente en la
carga de la segunda, las instrucciones para ello son las que carga el
MBR y una vez localizada la segunda parte del bootloader se carga y
comenzará la gestión.\
Para que el bootloader pueda cargar el kernel ha de tenerlo localizado,
generalmente es un binario del directorio `/boot` denominado
`vmlinuz-version`. Y antes de cargarlo necesita, también, lanzar el
`initrd` (initial RAM disk), una herramienta que necesitará el propio
kernel.

#### El kernel

Una vez la imágen del `initrd` ha sido cargada en memoria vuelca sobre
esta los drivers necesarios; configura la memoria, procesadores,
sistemas de I/O\...; e inicializa los dispositivos de almacenaje para
cargar el sistema de ficheros. Luego libera el espacio ocupado por el
`initrd`.\
El el dispositivo con la raíz del sistema y libera la memoria en
desuso.\
Una vez llegados a este punto el kernel ya es operativo, pero no ha
cargado ningún programa ni nada para poder decir que hace algo
significativo. Entonces, lo que hace, es lanzar el `/sbin/init`.

#### El /sbin/init

El `init` se encarga de configurar el entorno del sistema para la
interacción con el usuario. Es el primer proceso que se carga en la
máquina y sobre este se cargarán los demás.\
Lo primero que el `init` hace es cargar los scripts del `/etc/rc.d`,
estos configuran el relog del sistema, el puerto serie\... Luego lanza
el script `/etc/inittab`, este define como el sistema actúa frente a
cada nivel de ejecución y lanza el nivel por defecto.\
Lo siguiente que hace es ejecutar los scripts localizados en
`/etc/rc.d/init.d/`, estos son una serie de programas que se lanzan
según el nivel cargado; para definir los programas para cada nivel
existen dentro de esta ruta unos directorios con nombre `rcX.d`, donde
*X* es el nivel de ejcución concreto, y en ellos existen enlaces a los
scripts de `/etc/rc.d/init.d/` (por ejemplo, las referencias a los
scripts que se cargan en el nivel de ejecución 5 estarán localizadas en
`/etc/rc.d/rc5.d`). Los nombres de cada enlace comienzan por S (si son
programas que se lanzarán al inicio del nivel) o por K (programas que se
lanzarán cuando se cierre ese nivel). Tras la S o la K los nombres de
los enlaces contienen un número, ese número es el orden que se usará
para elegir qué script se ejecutará primero.\
Cuando un script\\programa localizado en `/etc/rc.d/init.d/` se lanza al
principio de un nivel de ejecución se hace utilizando el parámetro
`start` y cuando se lanza al finalizar dicho nivel se utiliza el
parámetro `stop`. Esto significa que nosotros también podríamos relanzar
o parar estos ejecutables una vez iniciado el sistema haciendo una
llamada del estilo: `/etc/rc.d/httpd stop`.\
Podemos también cerciorarnos del estado de un programa que esté en
`/etc/rc.d/init.d/` llamandolo con el parámetro `status`.\
En el nivel de ejecución 5 se lanza el `/etc/X11/prefdm`, este ejecuta
el `gdm`, el `kdm`, o el `xdm` que son los manejadores del sistema
gráfico X de linux y su configuración en `/etc/sysconfig/desktop`.

### Módulos

-   Para mostrar los módulos cargados en el sistema haremos: `lsmod`

### Scripts de inicio en Debian

Debian lanza también el programa *init* al iniciar el sistema, el
archivo que configura este es `/etc/inittab`. Luego se ejecutan los
scripts que hay en `/etc/init.d`, pero no directamente, utiliza para
ellos los enlaces existentes en `/etc/rcX.d` (donde *X* es el nivel de
init que arranca).\
Los nombres de los enlaces en `/etc/rcX.d` empiezan por \'S\' o \'K\'
según sean de entrado o de salida en el nivel de init respectivamente y
el orden en el que se ejecutarán será dado por un número que sigue a
esta letra (mientras más pequeño sea dicho número, antes será
ejecutado); luego, tras la letra y el número viene el nombre del script
original. Cuando un script \'S\' es llamado se le pasa como parámetro
`start`, cuando lo es un \'K\' se pasará un `stop`.\
Para facilitar esto Debian proporciona un comando llamada
**update-rc.d**, este funciona usando un script existente en
`/etc/init.d`. Se llama a update-rc.d seguido del nombre del script y de
una opción, si por ejemplo esta opción es *defaults* pondrá el link para
iniciarlo en los niveles 2 a 5 (los usados al iniciar la máquina) y para
detenerlo en 0 y 1 (los usados al parar la máquina).

    update-rc.d myScript defaults

### Como\...

-   **\...Saber el nivel de ejecución por defecto?** En el
    `/etc/inittab` encontrarás línias parecidas a la siguiente, la que
    indique `initdefault` será la que corresponda al nivel por defecto.

```{=html}
<!-- -->
```
    id:5:initdefault:

\* **\...Saber el nivel de ejecución actual?** Lanzando el comando
`runlevel`.

# El kernel

### Básico

#### LKM y /proc

Uno de los métodos para interactuar con el kernel de linux es el
directorio `/proc`, en él se encuentran ficheros virtuales que
representan los dispositivos instalados (cpuinfo, pci\...) o los
procesos en ejecución (subdirectorios que como nombre tienen números).
Algunos de estos ficheros pueden ser editados y de esa forma cambian el
parámetro concreto del kernel.\
\
Los LKM (Loadable Kernel Modules) son una forma dinámica de añadir y
eliminar código del kernel de linux; si los elementos del kernel (como
por ejemplo los drivers) se compilasen dentro del kernel ocuparían
memoria aunque no fuesen usados, en cambio, si se compilan como módulos
se irán cargando a medida que vayan usándose.\
\
\*\* Creando un LKM \*\*

#### sysctl

## Otros

### Control del tiempo

A parte del comando *date*, que te devuelve la hora actual hay pequeñas
cosas que debemos saber respecto al manejo del tiempo en Linux\...

#### Sincronizar el reloj

Podemos sincronizar el reloj de nuestro sistema con el de un servidor
NTP, de esos que te indican la hora actual exacta. Para ello existe el
comando *ntpdate*, su sintaxis: **ntpdate -u \<servidor\>**. Servidores
que pueden servirnos: swisstime.ethz.ch, hora.uv.es o gong.uv.es.

### rsync

Copia ficheros de forma incremental (sólo enviando las diferencias).
Sintaxis:

    rsync [opciones] origen destino

Opciones:

-   -n: Probar, no realiza nada solo muestra el resultado.
-   -a: Modo archivo. Respeta todos los permisos y propiedad del
    archivo. Igual que si se usaran los parámetros -rlptDg
-   -r: Recursivo
-   -l: Conservar los enlaces
-   -p: Conservar los permisos
-   -t: Conservar la fecha/hora
-   -g: Conservar el grupo
-   -D: Conservar los dispositivos (solamente con usuario root)
-   -v: Modo verboso (que es lo mismo que \--verbose), para mayor
    verbosidad usar -vv
-   -z: Comprimir en caso de que lo acepte el servidor (que es lo mismo
    que \--compress)
-   -C: Ignora archivos como hace CVS.
-   -u: Modo update, mantiene archivo en el destino si es posterior.
-   -b: backup renombrar archivos existentes a extensión.
-   \--exclude \"\*.bak\": Excluye los archivos \*.bak
-   \--delete: Elimina los ficheros en el destino que se han eliminado
    en el origen

Por ejemplo:

    rsync -a --delete --exclude "*bak" --exclude "*~" /www/* /backup

### Notas

![Quick Info Sheet](/sistema/linux/shell-commands.gif){.align-center
width="95"}
