# ActionScript 3

## Sintaxis básica

### Variables

-   `var nombre:tipo = valor;`
-   Tipos conocidos: *Number*, *String*

### Clases y objetos

    class nombre {
        accesivilidad var nombre: tipo;
        accesivilidad function nombreClase (nombre:tipo, ...) : tipo
        {}
        accesivilidad function nombre (nombre:tipo, ...) // constructor
        {}
    }

``` ActionScript
class SpaceShip {
  public var speed:Number;
  private var damage:Number;
  private static var inited:Boolean = false;
  public function SpaceShip ( ) {  }
  public function fireMissile ( ):Void {  }
  public function thrust ( ):Void {  }
  private static function init( ):Void { }
}
```

`var nombre:nombreClase = new nombreClase (parámetros);`

### Bucles

``` ActionScript
for (var i:Number = 0; i < 10; i++) 
  trace(i);
```

### Diferencia entre undefined y null

Null es variable o objeto (sí, en AS los tipos primitivos pueden ser
null) que no está asignado, undefined significa que esa variable no ha
sido definida.

### Clases dinámicas

En flash existen una serie de clases que no lanzan error, sino que crean
la propiedad o la función al ser llamadas, estas son: \'\'Array,
ContextMenu, ContextMenuItem, Function, FunctionArguments (el objeto que
se corresponde con los argumentos de una función), LoadVars, MovieClip,
Object, TextField. \'\'

Por ejemplo podríamos hacer:

``` ActionScript
var dataSender:LoadVars = new LoadVars( ); 
dataSender.firstName = "Rebecca";'' 
```

### Variables \'var\'

Son variables sin tipo definido, podemos meter un int, un string\... Y
luego podremos cambiarles el tipo:

``` ActionScript
var i;
i = 4;
i = "Hola!";
```

### Variables globales

Las variables globales en AS no pueden tener tipos, para crear una
variable global no debemos siquiera usar var, únicamente debemos añadir
\_global. delante del nombre y ya podremos usarla:

``` ActionScript
_global.autor = "Tupadre";
```

Son accesibles en todo el ensamblado, pero no es recomendable usarlas
(rompen la estética de la programación orientada a objetos).

### Añadir propiedades

Podemos añadir propiedades a objetos (no a clases) usando los corchetes:

``` ActionScript
var song:Sound = new Sound( );
song.url = "track3.mp3";        // Daría error
song["url"] = "track3.mp3";
trace(song["url"]);         // Mostraría: 'track3.mp3'
```

### Arrays

``` ActionScript
var doc:XML = new XML("<P>hello world</P");
var items:Array = new Array( );
```

Los elementos de los arrays no tienen un tipo concreto\...

``` ActionScript
items.push(doc);
```

\... por lo tanto, para acceder a ellos debemos hacer un cast:

``` ActionScript
var otherDoc:XML = XML(items[0]);
```

### Atributos de clase

**dynamic** - Si lo añadimos delante de la declaración de una clase,
esta será dinámica.\
**intrinsic** - Se añade delante de la declaración de la clase, los
métodos de esta no podrán tener cuerpo y las propiedades valores, ya que
este atributo indica que el código fuente de la clase está enlazado en
otro compilado:

``` ActionScript
dynamic intrinsic class LoadVars {
        var contentType:String;
        var loaded:Boolean;
        function load(url:String):Boolean;
        function send(url:String,target:String,method:String):Boolean;
}
```

### Ver las propiedades y valores de un objeto mediante un foreach:

``` ActionScript
class Box {
  public var width:Number  = 15;
  public var height:Number = 15;
}
var b:Box = new Box();
for (var prop:String in b) {
  trace("property name: " + prop);
  trace("property value: " + b[prop]);
}
```

Si la declaración del bucle hubiese sido: `for (var prop:String in Box)`
\... Se mostrarían las variables estáticas, es decir, en este caso
ninguna.

### Otros

#### Sintaxis para la creación de funciones:

*accesivilidad function nombre(parámetro:tipo):TipoDevuelto { cuerpo }*\
`public function convertCurrency():void { }`

#### Declaración de una constante

*accesivilidad const nombre:tipo = valor;*\
`private const ON_MESSAGE:String = "Busy Cursor ON";`

#### Cargar un objeto indefinido como uno definido

*var nombre:tipo = ObjetoIndefinido as tipo;*\
`var btn:Button = e.target as Button;`

## Notas

-   Podemos ver el tipo de un objeto haciendo typeof:
    `if (typeof msg == "string") ...`
-   Podemos saber si un objeto es instancia de un tipo de la siguiente
    manera: `if (msg instanceof XML) ...`
-   Para hacer un cast aquí los parentesis van al revés:
    `tipo(variable)`

``` ActionScript
var doc:XML = XML(msg);
```

Podemos castear un String a Integer (*Number(valorStr)*) o lo contrario
(*String(valorInt)*)

-   Convertir de string a integer, se usa la función global
    **parseInt**.
-   Saber si NO es un número correcto: *isNaN(valor)*
-   Abrir navegador con una página: *navigateToURL( objeto URLRequest )*

## Archivos

-   ![Essential
    AS2](/script/as3/oreilly_essential_actionscript_2.0.chm.zip)
-   ![Tips for learning
    AS3](/script/as3/tips_for_learning_actionscript_3.0.pdf)
