# Vagrant

Vagrant provides a configurable, reproducible and portable development
environtment. It automatically creates the environtment. That
environtment will be distributable between other team members and
platforms. This action avoids different work environtments for each
developer. It works through virtual machines from several providers
(VirtualBox, VMWare\...). To configure those virtual machines in other
environtments you can use tools like Chef, Puppet, etc.

Vagrant links files located inside the working path with the development
environtment file system. This method allows developers to work with the
environtment in an isolated way.

To download Vagrant you should go to: <http://www.vagrantup.com/>

You can find Vagrant documentation in: <http://docs.vagrantup.com/v2/>

## Working with projects

The first step you should do before start working with Vagrant projects
is go to the specific working path. Then, to create an environtment, you
execute:

    $ vagrant init

It creates a Vagrantfile which is writen using Ruby syntax and is a
definition for Vagrant to set up the environtment.

After configuring the project (adding one or several boxes, and setting
up several options (instructions are below)) you will start working on
it using:

    $ vagrant up

It creates the environtment from scratch, even if it is new or you
previously destroyed it. This command also brings the environtment back
after suspend it or halt it.

You can change the provider to start the envorintment with using the
parameter \--provider:

    $ vagrant up --provider=vmware_fusion
    $ vagrant up --provider=aws

You can access to the virtual machine through an ssh session using:

    $ vagrant ssh

You can destroy an environtment using the command:

    $ vagrant destroy

Differences between destroy, halt or suspend an environtment can be
found at: <http://docs.vagrantup.com/v2/getting-started/teardown.html>

## Boxes

Boxes are virtual machine images previously configured to start working
with them. To add a Box into the project you will execute:

    $ vagrant box add <name>

Being \<name\> the specific identifier for the image. Identifiers can be
image names in Vagrant Cloud, URLs, local files\... Vagrant Cloud
(<https://vagrantcloud.com/>) is a web page were you can find great
variety of free boxes.

## Configuring the project (Vagrantfile)

To configure the Vagrant project and environment it\'s needed to edit
the Vangrantfile created into the working directory. If configuration
changes affected the initial installation it would be required to reload
the project with:

    $ vagrant reload

Configuration lines are contained in Vagrantfile using the next format:

    Vagrant.configure("2") do |config|
        <configuration lines>
    end

To define the box that Vagrant will use we will add the next line (for
example, using hashicorp/precise32):

`config.vm.box = "hashicorp/precise32"`

To define a file script (for example bootstrap.sh) which will install
the required software to develop:

`config.vm.provision :shell, :path => "bootstrap.sh"`

To make available the access of a localhost port number inside the
Vagrant environtment (for example, to access to the Vagrant environment
through port 4567 using <http://127.0.0.1:80>):

`config.vm.network :forwarded_port, host: 4567, guest: 80`
