# Usar Joomla!

-   **Versión probada**: `1.5.15`

## Básico

Para instalar Joomla se necesita lo siguiente:

-   Versión de PHP superior a la 4.3.10.
-   En PHP, soporte para compresión zllib.
-   En PHP, soporte para XML.
-   En PHP, soporte MySQL.

Copiaremos el contenido descomprimido del archivo descargado donde
queramos porner la web y seguiremos los pasos de la instalación.\
Para entrar al panel de control iremos a la ruta de la web
`/administrator`.\
\
Joomla funciona de la siguiente forma:\
![](/otros/otros/howto/joomla01.png){.align-center width="600"}

## Cómo\...

### Gestionar el contenido y estructura

#### Secciones y categorías

El contenido de Joomla se gestiona a partir de los siguientes apartados:

-   Section Manager
-   Category Manager
-   Front Page Manager
-   Article Manager
-   Articles Trash Manager

El **Section Manager** se encarga de gestionar las secciones de la web y
el **Category Manager** las categorías (*of course!*). La estructura
principal de una web en Joomla es: Secciones -\> Categorías -\>
Artículos. Es decir, si estubiesemos haciendo una web de coches
tendríamos una sección denominada \"páginas de coches\" y dentro las
categorías \"Deportivos\" y \"Familiares\" y dentro de cada una los
diferentes artículos o coches. Puedes tener tantas secciones como
quieras.

#### Artículos

Los artículos corresponden al contenido principal del site, cada página
interna corresponde a un artículo. Para indicar las propiedades por
defecto para todos los artículos iremos a **Parameters** dentro del
*Article Manager*.

#### FrontPage Manager

Las páginas que se gestionan en el **Front Page Manager** son páginas
que se pueden ver desde la página principal; el contenido se gestiona a
partir del Article Manager.\
La FrontPage de Joomla es un componente que permite controlar como se ve
la página principal, la cual es un poco diferente a las otras.
Generalmente se la llama `Home` y encontramos su configuración en
`Menu -> mainmenu -> Home -> Parameters`.

#### Menús

La estructura de la página la organizamos mediante menús, estos se
gestionan en el **Menu Manager** y los apartados de la web corresponden
a los elementos que el menú tiene, para agregarlos, en la lista de menús
y por cada uno, tendremos un botón denominado `Menu Items` a partir del
cual podremos cambiar los elementos de este.\
Los elementos más destacables son:

-   **Internal Link -\> Articles -\> Article layout**: Muestra un sólo
    artículo (perfecto para los \"sobre nosotros\" y tal\...).
-   **External Link**: Agrega un link a un elemento externo de la
    página.

El *Menu Item* por defecto del *Menu* por defecto será el elemento que
se mostrará como índice.

#### Agregar módulos a las páginas

Los módulos son los elementos (que no son el contenido en sí) de cada
página, como por ejemplo los menús. Gestionamos los módulos a partir del
**Module Manager** y mediante este podemos agregar elementos a nuestras
páginas; para ello al hacer new escogemos sus propiedades (si queremos
que salga el título, su posición en la página (user1, top, left\...
todas dadas por la plantilla)\...).\
Desde el **Module Manager** podemos indicar dónde queremos que nos
aparezca un módulo concreto, en qué apartado y tal. Para ello hemos de
acceder a ese módulo, configurarlo como siempre y luego escoger en qué
apartados aparecerá desde la zona **Menu Assignment**.\
Tenemos la posibilidad de, desde el mismo **Module Manager** duplicar un
módulo (opción `copy`), cambiar su configuración y asignarlo a otro
`Menu Item`.

### Gestión de usuarios

#### Tipos de usuarios

La gestión de usuarios se divide en dos grandes grupos, los usuarios
**front-end** que son los que acceden a la web y los usuarios
**back-end** que son los que acceden a la administración.

-   *Usuarios front-end*:
    -   Registrados: Aquellos que pueden ver partes reservadas de la
        web.
    -   Autores: Pueden hacer lo que los usuarios regsitrados a la vez
        que editar su propia información.
    -   Editores: Pueden hacer lo mismo que los autores y ademas editar
        toda la información que aparece en el front-end.
    -   Publicadores: Pueden hacer lo que los editaros y además decidir
        qué información se publica o no.
-   *Usuarios back-end*, pueden hacer lo mismo que los front-end pero
    además:
    -   Manager: Pueden crear contenido y ver información sobre el
        sistema.
    -   Administradores.
    -   Super-Administradores: Pueden hacer de todo en Joomla!. La
        primera cuenta creada (la `admin`) es un super-administrador.

### Administración (general)

#### Cambios del editor

Puede que al cambiar los css de la plantilla no nos guste la idea que el
editor de Joomla tome estas reglas para mostrar el contenido a medida
que lo vamos editando. Podemos crear un archivo en la plantilla llamado
`editor_content.css` dentro del directorio `CSS`. Lo siguiente será ir a
las opciones del editor
(`Administrador de Mambots -> Editor WYSIWYG TinyMCE`) y en la opción
Template CSS classes ponemos `No`. Un ejemplo sería el siguiente:

``` css
body{ margin:0; padding:0; text-align: left; background: #FFF; background-image: none; } 
```

### General

-   Ha de existir un menú para la que la aplicación funcione y este ha
    de tener un menu item por defecto activo.
-   Para quitar el título de la página principal haremos:
    `Menus -> Main Menu -> Home -> Parameters - System -> Page Title [Hide]`.

## Avanzado

### Creación de plantillas

Las plantillas las colocaremos en una carpeta llamada `templates`,
dentro del directorio raiz de Joomla!. Cada plantilla estará en una
carpeta con su nombre y contendrá:

-   Archivo **index.php**, contiene código html y php.
-   Archivo **TemplateDetails.xml**, indica propiedades a la
    administración.
-   Carpeta **css**, contiene los archivos .css y el archivo principal
    `template_css.css`.
-   Carpeta **images**, que contiene los archivos de imágenes utilizados
    en la plantilla.
-   Archivo **Template_thumbnail.png**, imagen que funciona para
    previsualizar la plantilla en la administración.

#### index.php

El archivo index.php es el centro de toda plantilla en Joomla, es una
página html pero concódigo PHP interno, este código indica dónde irán
colocados los elementos. Las funciones y variables más útiles que
podemos utilizar en este código son:

-   Para que no todo el mundo pueda acceder al código de la plantilla:
    `<?php defined( '_JEXEC' ) or die( 'Restricted access' );?>`
-   Para incluir el contenido de la cabecera:
    `<jdoc:include type="head" />`
-   Para indicar la ruta de la css (`$this->baseurl` devuelve la ruta de
    la web):
    `<link rel="stylesheet" href="<?php echo $this->baseurl ?>/templates/system/css/style.css" type="text/css" />`
-   Para agregar los mensajes del servidor:
    `<jdoc:include type="message" />`
-   Para agregar los mensajes de debug
    `<jdoc:include type="modules" name="debug" />`
-   Para agregar los módulos de *top*:
    `<jdoc:include type="modules" name="top" />`
-   Para agregar los módulos de *bottom*:
    `<jdoc:include type="modules" name="bottom" />`
-   Para agregar el contenido: `<jdoc:include type="component" />`
-   Para saber la url del sitio: `<?php echo JURI::base();;?>`
-   Para saber el nombre de la plantilla:
    `<?php echo $this->template ?>`
-   Para saber el mail del administrador:
    `<?php echo $mainframe->getCfg('mailfrom'); ?>`
-   Para saber el nombre del sitio:
    `<?php echo $mainframe->getCfg('sitename'); ?>`
-   Para consultar un parámetro:
    `<?php echo $this->params->get('parametro'); ?>`

Por ejemplo:

``` php
<?php defined( '_JEXEC' ) or die( 'Restricted access' );?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" 
   xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" >
<head>
<jdoc:include type="head" />
<link rel="stylesheet" href="<?php echo $this->baseurl ?>/templates/mynewtemplate/css/style.css" type="text/css" />
</head>
<body>
<jdoc:include type="modules" name="top" /> 
<jdoc:include type="component" />
<jdoc:include type="modules" name="bottom" />
</body>
</html>
```

#### Los CSS

Podremos colocar los css de los elementos del sitio indicandolos por sus
ids, de la siguiente forma:

``` css
* {padding: 0; margin: 0; }
body{ }
#wrapper { margin: 0auto; width: 922px; }
#header { width: 900px; float: left; padding: 10px; height:42px; padding-bottom:30px; }
#leftcolumn { margin: 0px 5px 5px 0px; padding: 10px; width: 195px; float: left; }
#content { float: left; margin: 0px 5px 5px 0px; padding: 10px; width: 456px; display: inline; }
...
```

Aunque Joomla tiene algunas clases que aparecen por defecto:\
:!:
<http://www.compassdesigns.net/joomla-tutorials/joomla-15-template-tutorial/page-4>

#### TemplateDetails

El archivo `TemplateDetails.xml` es un archivo con formato .xml que nos
sirve para especificar las propiedades de la plantilla y se coloca en la
raíz de la carpeta de esta. En él se escriben, entre otros los datos de
autor y nombres, y será importante indicar los archivos de la plantilla
en su correspondiente carpeta contenedora. Si no indicásemos algún
archivo ese no sería reconocido ni instalado.

``` xml
<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE install PUBLIC "-//Joomla! 1.5//DTD template 1.0//EN"
 "http://dev.joomla.org/xml/1.5/template-install.dtd">
<install version="1.5" type="template">
        <name>mynewtemplate</name>
        <creationDate>2008-05-01</creationDate>
        <author>John Doe</author>
        <authorEmail>john@example.com</authorEmail>
        <authorUrl>http://www.example.com</authorUrl>
        <copyright>John Doe 2008</copyright>
        <license>GNU/GPL</license>
        <version>1.0.2</version>
        <description>My New Template</description>
        <files>
                <filename>index.php</filename>
                <filename>component.php</filename>
                <filename>templateDetails.xml</filename>
                <filename>template_thumbnail.png</filename>
                <filename>images/background.png</filename>
                <filename>css/style.css</filename>
        </files>
        <positions>
                <position>breadcrumb</position>
                <position>left</position>
                <position>right</position>
                <position>top</position>
                <position>user1</position>
                <position>user2</position>
                <position>user3</position>
                <position>user4</position>
                <position>footer</position>
        </positions>
</install>

```

#### Template Parameters

Los parámetros de plantillas permiten pasar valores a la plantilla desde
el back-end. Para usuarlos en el archivo `templateDetails.xml`
agregaremos lo siguiente:

``` xml
<params>
  <param name="template_width" type="list" default="fluid" label="Template Width" description="Width style of the template">
    <option value="fluid">Fluid with maximum and minimum</option>
    <option value="medium">Medium</option>
    <option value="small">Small</option>
  </param>
</params>
```

También necesitaremos agregar un fichero llamado `params.ini` en el
directorio de la plantilla, aunque este esté vacío Joomla lo necesita
para guardar la configuración seleccionada, por ejemplo únicamente
podría tener lo siguiente:

    template_width=2

Luego podremos consultarlos desde el php.ini:

``` php
<body class="width_<?php echo $this->params->get('template_width'); ?>">
```

#### Sobreescribir la salida

Podemos indicar el formato en el que queramos recibir el resultado de un
módulo para que así no nos salga en la forma por defecto. Para ello cada
módulo en su carpeta dentro de Joomla tiene una carpeta denominada
`tmpl`, esta indica el formato por defecto de dicho módulo, por ejemplo
los del módulo newflash:

    /modules/mod_newsflash/tmpl/default.php
    /modules/mod_newsflash/tmpl/horiz.php
    /modules/mod_newsflash/tmpl/vert.php
    /modules/mod_newsflash/tmpl/_item.php

Podremos cambiarlos para nuestra plantilla, cogiendo el archivo que
queramos y colocándolo en un nuevo directorio
`html/<nombre_modulo>/fichero` de nuestra plantilla, por ejemplo:

    templates/nuestra_plantilla/html/mod_newsflash/_item.php

De la misma forma que los módulos podremos cambiar los componentes, por
ejemplo en la carpeta components de joomla podríamos encontrar:

    /components/com_content/views/
    /components/com_content/views/archive
    /components/com_content/views/article
    /components/com_content/views/category
    /components/com_content/views/section
    ...
    /components/com_content/views/category/blog.php
    /components/com_content/views/category/blog_item.php
    /components/com_content/views/category/blog_links.php
    /components/com_content/views/category/default.php
    /components/com_content/views/category/default_items.php

Esta carpeta corresponde al componente que muestra el contenido,
archivo, artículo, categoría\... Dentro de un directorio `views`
encontramos otro directorio `tmpl`. :!:

#### Otros

-   Cambiar el título de la página:

``` php
<?php
$document =& JFactory::getDocument();
$document->setTitle($mainframe->getCfg('sitename') . " - " . $document->title);
?>
```

## Notas

### Módulos útiles

-   [Jx List
    Files](http://extensions.joomla.org/extensions/directory-a-documentation/downloads/6125),
    carga de un directorio una lista con los ficheros existentes en
    este.

### Links

-   [Documentación principal de
    Joomla](http://docs.joomla.org/Main_Page)
-   [Tutoriales muy útiles de
    Joomla](http://www.siteground.com/tutorials/joomla15/)
-   [Lista de extensiones públicas de
    Joomla](http://extensions.joomla.org/extensions/)
-   [Tutorial de creación de
    plantillas](http://www.compassdesigns.net/joomla-tutorials/joomla-15-template-tutorial)
