# Algebra

## Vectores

Un vector (V) es una agrupación de *n* números que pueden representar
desde un punto en el espacio, hasta una dirección u orientación y es
expresado de la siguiente forma:\
\<m\>V = (V_1, V_2, V_3 \... V_n)\</m\>\
\
Si un vector (P) que correspondiese a un punto con las tres coordenadas
correspondientes a las dimensiones sería:\
\<m\>P = (P_x, P_y, P_z)\</m\>\
\
Los vectores pueden ser expresados como matrices:\
\<m\>V = delim{\[}{matrix{3}{1}{V_1 V_2 V_3 \... V_n}}{\]}\</m\>

### Propiedades

Utilizando los vectores *V*, *P*, *Q* y *R* y un escalar *a*:

-   \<m\>aV = (aV_1, aV_2, aV_3 \... aV_n)\</m\> Si multimplicas un
    escalar por un vector este se multiplica por cada uno de sus
    componentes.
-   \<m\>P + Q = (P_1 + Q_1, P_2 + Q_2, P_3 + Q_3 \... P_n + Q_n)\</m\>
-   \<m\>P + Q = Q + P\</m\>

#### Suma de vectores

Para encontrar el camino directo entre el punto (0,0) y el camino
definido por los vectores (3, 1), (-2, 4), (6, -2) y (-2, 4), lo único
que tendríamos que hacer es sumar todos los vectores:\
\<m\>Nueva x: 3 + (-2) + 6 + (-2) = 5\</m\>\
\<m\>Nueva y: 1 + 4 + (-2) + 4 = 7\</m\>\
![](/numbers/suma_vectores.jpg)

#### Determinar vectores

Imaginemos un coche viajando a 50kmh que va a una dirección de 30º desde
el punto (0,0).\
![](/numbers/resolving_vectors.jpg)\
Gracias a la trigonometría sabemos que:\
\<m\>cos{alpha} = {cateto contiguo} / hipotenusa\</m\>\
\<m\>sin{alpha} = {cateto opuesto} / hipotenusa\</m\>\
\
Por lo tanto deducimos (correctamente) que cada hora el cohe se moverá:\
\<m\>50 cos{30} = 43,3 km en x\</m\>\
\<m\>50 sin{30} = 25 km en y\</m\>

### Magnitud de un vector

-   La magnitud (o **longitud** o **módulo**) de un vector
    (\<m\>V\</m\>) es un escalar (\<m\>delim{vert}{V}{vert}\</m\>) que
    indica su tamaño.
-   La magnitud se calcula con la siguiente fórmula:

\<m\>delim{vert}{V}{vert} = sqrt{sum{n=1}{n}![](V_n}^2)\</m\>

-   Por ejemplo, para un vector de 3 dimensiones sería:

\<m\>delim{vert}{V}{vert} = sqrt![](/V_x}^2 + {V_y}^2 + {V_z}^2}</m>
  * Cuando la magnitud de un vector es 1 entonces este vector es llamado vector unidad. 



==== Normalizar un vector ====
Un vector normalizado es aquel que su magnitud es 1, por lo tanto podríamos decir que la normalización es convertir un vector a un vector unidad, para ello lo multiplicaremos por <m>1/delim{vert}{V}{vert}</m> (es decir, dividimos cada uno de sus componentes por la magnitud). Por ejemplo, un vector de 3 dimensiones/ \\ 
<m>V_normalizado = (V_x/delim{vert}{V}{vert}, V_y/delim{vert}{V}{vert}, V_z/delim{vert}{V}{vert})</m>
  * Un vector normal se refiere a un vector que es perpendicula a una superficie en un punto concreto, no confundir con vector normalizado.



==== Producto escalar (dot product) ====
Es un número que permite medir la diferencia entre las direcciones a las que apuntan dos vectores. Este número es dado por la fórmula/ \\ 
<m>P · Q = sum{i=1}{n}{P_i Q_i}</m> \\ \\ 
En vectores que representan coordenadas 3D, el producto escalar sería la suma de sus componentes multiplicados/ \\ 
<m>P · Q = P_x Q_x + P_y Q_y + P_z Q_z</m> \\ \\ 
El producto escalar satisface la siguiente ecuación/ \\ 
<m>P · Q = delim{vert}{P}{vert} delim{vert}{Q}{vert} cos {alpha}</m> \\ 
Donde <m>alpha</m> es el angulo que existe entre las dos lineas conectadas en el orígen. \\ 
{{numbers/producto_escalar.jpg)\
Encontrar pues el **ángulo entre dos vectores** es muy sencillo. Si
normalizamos P y Q tenemos que \<m\>delim{vert}{P}{vert} = 1\</m\> y
\<m\>delim{vert}{Q}{vert} = 1\</m\> y por lo tanto:\
\<m\>P · Q = cos {alpha}\</m\>\
Es decir,\
\<m\>P_x Q_x + P_y Q_y + P_z Q_z = cos {alpha}\</m\>\
\
Esto nos desvela un par de cosas a tener en cuenta:

-   Si \<m\>P · Q = 0\</m\> entonces los vectores P y Q son
    perpendiculares. (La función del coseno es 0 para un ángulo de 90º).
-   El signo del producto escalar nos dice cuan cercanos son un punto de
    otro y si apuntan a la misma dirección. Por ejemplo, en la siguiente
    imágen, estando P perpendicular al orígen del sistema de
    coordenadas, el producto escalar entre P y Q será positivo si están
    en la misma parte del eje, negativo si no.

![](/numbers/producto_escalar_2.jpg)\
La longitud del lado adyacente a \<m\>alpha\</m\> es dada por
\<m\>delim{vert}{P}{vert} cos alpha\</m\>:\
\<m\>delim{vert}{P}{vert} cos alpha = {P ·
Q}/delim{vert}{Q}{vert}\</m\>\
Para obtener una proyección de P sobre Q:\
\<m\>proj_Q P = {P · Q}/delim{vert}{Q}{vert}\^2 Q\</m\>\
![](/numbers/producto_escalar_3.jpg)

### Producto cruzado de dos vectores 3D

También llamado vector producto, es un vector perpendicular a los dos
vectores dados. Se calcula como:\
\<m\>P x Q = [^1]\</m\>\
\
Esta fórmula proviene del cálculo del determinante de una matriz.\
El producto cruzado cumple la siguiente ecuación:\
\<m\>delim{vert}{P x Q}{vert} = delim{vert}{P}{vert}
delim{vert}{Q}{vert} sin {alpha}\</m\>\
Donde \<m\>alpha\</m\> es el angulo que existe entre las dos lineas
conectadas en el orígen.\
![](/numbers/producto_cruzado.jpg)\
\
La dirección de este vector está determinada por el orden de los
operandos, para poder entenderla debemos comprender la regla de la mano
derecha donde \"asignamos\" al dedo índice el primer operando, al
corazón (el del medio) el segundo y el producto cruzado correspondería
al pulgar:\
![](/numbers/right_hand_cross_product.png)

## Matrices

Las matrices no son más que una forma de organizar números en filas y
columnas.\
\<m\> A = delim{\[} { matrix{3}{3}{1 2 3 4 5 6 7 8 9} } {\]} \</m\>\
Para acceder a sus posiciones:\
\<m\> A = delim{\[} {matrix{2}{3}{a_00 a_01 a_02 a_10 a_11 a_12}} {\]}
\</m\>\
La dimensión de una matriz es el número de filas por el número de
columnas. Es decir, una matriz de 2x3 es una matriz de dos filas por
tres columnas.\
La matriz identidad es aquella que en su diagonal tiene el valor 1 y en
los demás valores 0:\
\<m\>A = delim{\[} {matrix{3}{3}{1 0 0 0 1 0 0 0 1}} {\]}\</m\>\
La multiplicación de matrices no es conmutativa a no ser que sea con una
matriz identidad (I): `A * I = A` ; `I * A = A` ; `A * I = I * A`

### Suma y resta de matrices

Para realizar esta operación las dos matrices han de tener la misma
dimensión.\
La operación se realiza en cada uno de sus elementos con el elemento de
la otra matriz en la misma posición:\
![](/numbers/suma_de_matrices.png){width="400"}

### Multiplicación por un escalar

Para ello se multiplica cada elemento de la matriz por el escalar:\
\<m\>B = delim{\[} {matrix{2}{3}{3 6 {-4} 0 {-1} 2}} {\]}\</m\>\
\<m\>-5B = delim{\[} {matrix{2}{3}![](-15} {-30} 20 0 5 {-10)}
{\]}\</m\>\
Resolver ecuaciones sería sencillo, por ejemplo, teniendo: \<m\>A =
delim{\[} {matrix{2}{2}{4 5 1 {-2}}} {\]}\</m\> y \<m\>B = delim{\[}
{matrix{2}{2}{0 {-1} {-3} 2}} {\]}\</m\> podríamos intentar resolver:
`2x = 3A - B`\
\<m\>2x = 3A - B\</m\>\
\<m\>½(2x) = ½(3A - B)\</m\>\
\<m\>x = ½(3A - B)\</m\>\
![](/numbers/ecuaciones_con_matrices.png)

### Multiplicación de matrices

La multiplicación se realiza de la siguiente forma:\
![](/numbers/explicacion_multipli_matrices.png)\
La multiplicación de matrices no es conmutativa (`AB ≠ BA`). Sólo puede
realizarse cuando el número de columnas de la primera es igual al de las
filas de la segunda:\
![](/numbers/explicacion_multipli_matrices2.png)

### Matriz traspuesta

Es la que se obtiene de intercambiar filas por columnas, la traspuesta
de A la indicamos como \<m\>A\^T\</m\>:\
\<m\>A = delim{\[} { matrix{2}{4}{2 {-1} 3 8 0 5 1 4} } {\]}\</m\> ;
\<m\>A\^T = delim{\[} { matrix{4}{2}{2 0 {-1} 5 3 1 8 4} } {\]}\</m\>

### Matriz simétrica

Es una matriz cuadrada que es traspuesta de sí misma:\
\
![](/numbers/algebra/simetric.png)

### Matriz inversa

Al igual que en números reales tenemos la identidad (1) tenemos también
inversos, aquellos números que al multiplicarlos con ellos nos da la
identidad:\
\<m\>1 = 3 · 3\^-1 = 3 · 1/3\</m\>\
Con las matrices también tenemos las matrices identidad y las inversas
que cumplen lo siguiente (para una matriz **cuadrada** `A` y la
identidad `I`):\
\<m\>A · A\^-1 = A\^-1 · A = I\</m\>\
Por ejemplo:\
\<m\>delim{\[} { matrix{2}{2}{3 4 2 16} } {\]} delim{\[} {
matrix{2}{2}{0.4 {-0.1} {-0.05} 0.075} } {\]} = delim{\[} {
matrix{2}{2}{1 0 1 0} } {\]}\</m\>\
\
Las matrices inversas nos permiten resolver ecuaciones con matrices, por
ejemplo, teniendo cuatro matrices: *A, B, C* y *D*, Entonces:\
\<m\>A B = C D ; B = A\^{-1} C D\</m\>

### Rango de una matriz

Es el número máximo de columnas (y filas) que son linealmente
independientes.

## Algebra lineal

### Combinación linear

Una combinación linear es una expresión construida a partir de un
conjunto de elementos (variables, funciones, vectores\...) en la que se
multiplica cada uno de sus términos por una constante y se suman los
resultados. Utilizado para encontrar características relacionadas.\
Por ejemplo una combinación de *x* y de *y* sería una expresión del tipo
*ax + by* donde a y b son constantes.\
\
Diremos que un conjunto de vectores es **linealmente independiente** si
ninguno puede escribirse como una combinación lineal de los otros. Dos
vectores son independientes si no tienen la misma dirección (sentidos
idénticos u opuestos (el vector nulo tiene todas las direcciones)).
![](/numbers/combinacion_linear.png){.align-center}

[^1]: P_y Q_z) - (P_z Q_y), (P_z Q_x) - (P_x Q_z), (P_x Q_y) - (P_y Q_x
