# Xtra

## Elementos del lenguaje

### Enumeraciones

``` java
protected static enum roboType  { Alpha, Beta, RobotDeCaramelo };
protected void config (roboType tipo) {
    switch (tipo) {
    case Alpha:
        System.out.println("hola");
        break;
    case Beta:
        break;
    case RobotDeCaramelo:
        break;
    }
}
```

## Tips de código

### Orden de operandos

``` java
i = 5;
v[i++] = 3; // Coloca 3 en v[5] e incrementa i en 1.
v[++i] = 3; // Incrementa i en 1 y, por lo tanto, coloca 3 en v[6].
```

### Constructores

Desde un constructor podemos llamar a otro, sí y sólo sí esta llamada se
hace en la primera línea del constructor.

``` java
public class Clase {
    ...
    public Clase () {
        this(10);
        ...
    }
    public Clase (int i) {
        ...
```

### Asignar e igualar

``` java
int i = 5;
int j = 100 * (i = 2);
System.out.println(i);  // 2
System.out.println(j);  // 200
```

### Crear un objeto de interface sin objeto de clase

Podemos crear un nuevo objeto a partir de una interface, pero, como bien
sabemos, necesitamos tener codificados los métodos de esta. Para ello,
en el momento de crear el objeto los podemos codificar.\
Teniendo la siguiente interface:

``` java
public interface Recorder {
    public void record (String messsage);
}
```

Podemos hacer lo siguiente:

``` java
public static void main(String[] args) {
    Recorder r = new Recorder() {
        public void record (String message) {
            System.out.println(message);
        }
    };
    r.record("Hello world!");
}
```

### Clonar un array

Un objeto cualquiera tiene un método llamado clone que devuelve un
object. Con este object podemos hacer un cast y volcarlo sobre un objeto
del tipo del de orígen, ahora el destino tendrá un nuevo objeto idéntico
al inical.

``` java
    int[] a = {3,4,5,1,4};
    int[] b = (int[])a.clone();
```

## Listado de excepciones

-   **ArithmeticException** Arithmetic error, such as divide-by-zero.
-   **ArrayIndexOutOfBoundsException** Array index is out-of-bounds.
-   **ArrayStoreException** Assignment to an array element of an
    incompatible type.
-   **ClassCastException** Invalid cast.
-   **IllegalArgumentException** Illegal argument used to invoke a
    method.
-   **IllegalMonitorStateException** Illegal monitor operation, such as
    waiting on an unlocked thread.
-   **IllegalStateException** Environment or application is in incorrect
    state.
-   **IllegalThreadStateException** Requested operation not compatible
    with current thread state.
-   **IndexOutOfBoundsException** Some type of index is out-of-bounds.
-   **NegativeArraySizeException** Array created with a negative size.
-   **NullPointerException** Invalid use of a null reference.
-   **NumberFormatException** Invalid conversion of a string to a
    numeric format.
-   **SecurityException** Attempt to violate security.
-   **StringIndexOutOfBounds** Attempt to index outside the bounds of a
    string.
-   **UnsupportedOperationException** An unsupported operation was
    encountered.

## Otros

### Redireccionando la entrada\\salida

Podemos indicar una entrada (texto que se introducirá) a un programa
Java de consola mediante: \'\' java Program \< fichero \'\'\
O podemos indicar que imprima sus salidas en un fichero: \'\' java
Program \> fichero \'\'\
O las dos a la vez: \'\' java Program \< ficheroIn \> ficheroOut \'\'

### Archivos .jar

En un .jar correctamente formado, es decir, debe tener indicada cual es
la clase que se va a lanzar, para ello ha de existir un fichero de texto
que sea: *META-INF\\MANIFEST.MF* con el nombre indicado de la forma
siguiente:

        Manifest-Version: 1.0
        Main-Class: pck.newFrame

Donde *pck.newFrame* es la clase donde está el main.\

-   Para lanzar un fichero jar llamado myJar, haríamos, desde consola:
    **java -jar myJar.jar**

#### Leer de un JAR una imágen

Debemos coger el resource que acompaña a la clase como un stream, luego,
mediante ImageIO podemos leer ese stream y pasarlo a imágen.

``` java
    java.io.InputStream is = this.getClass().getResourceAsStream("Carita.png");
    Image img = javax.imageio.ImageIO.read(is);
```

#### Lanzar una clase dentro de un jar

Para lanzar un Main dentro de una clase que está dentro de un .jar que
hace referencia a otro:

    java -cp "lucene-demos-2.9.4.jar:lucene-core-2.9.4.jar" org.apache.lucene.demo.IndexFiles texts/

Es decir (y si estás en windows pon `;` en vez de `:`):

    java -cp "your_jar.jar:lib/referenced_jar.jar" com.your.main.Main

## Notas

-   Otra forma de pillar un número aleatorio: **Math.random()**.
-   Las excepciones derivadas de la clase *RuntimeException* no
    requieren de un try/catch obligatorio, algo contrario a las
    derivadas de *Exception*.
-   Para indicar el número de decimales utilizando el String.format
    haremos: `%.2f`, siendo *.2* dos decimales y *f* un número float o
    double.
-   Podemos añadir dos clases a un mismo archivo, la clase principal (y
    pública) será la que tenga el nombre del archivo, la otra no debe
    tener ningún modificador.
-   Para la serialización usaremos las clases java.io.ObjectInputStream
    y java.io.ObjectOutputStream, con sus métodos writeObject y
    readObject.
-   Podemos hacer una conversión de forma cutre de, por ejemplo, int a
    String: `String s = "" + iVar;`
-   imports java.\*; te incluye java.util\... java.awt\...
-   Una vez declaras un constructor con parámetros ya no hay constructor
    por defecto a no ser que lo declares.
-   Desde las estáticas puedes acceder a las privadas de esa clase.
-   El main debe de estar en la clase que se llama igual que el archivo.
-   El resultado de un substring empieza por la posición inicial
    indicada con una longitud igual = posFinal - posInicial
-   La palabra reservada \'is\' en C# equivale a \'instanceof\' de java.
    Te indica si un objeto indeterminado es una clase heredada
    (subclase) de otra:

``` java
    Prueba p = new Prueba();
    if (p instanceof java.awt.Frame)
        System.out.println("hola");
```

-   Para la creación de constantes usaremos el modificador \'final\':
    `public static final double PI = 3.141;`
-   Las variables de dentro clase se inicializan automáticamente con
    valores por defecto (int = 0, double = 0.0\...) al crear el objeto.
-   Las clases necesarias para gestionar la hora pueden ser **java.util
    GregorianCalendar**, **Calendar** o **Date**. A esta última la
    puedes construir mediante un long, este long puede ser
    **System.currentTimeMillis()**
-   Para saber el tamaño de una matriz podemos ver el tamaño de la
    primera fila:

``` java
    int[][] matriz = new int[30][10];
    int files = matriz[0].length;
```

Y nos devolverá 10, el total de celdas que le tocan a cada una de las
otras. Ahora sólo debemos coger y dividir 10 entre matriz.length (que te
devolverá el total de celdas de la matriz 300), y 300 / 10\... 30!

-   En la clase Math encontrarás un método estático que te convierte un
    ángulo en grados a radianes.
-   Recoger la hora del sistema:\*\* System.currentTimeMillis();\*\*
