# Mono

## A tener en cuenta

Como Mono es multiplataforma el separador de ruta puede ser distinto en
Windows (`\`) que en Linux (`/`). Para evitar eso deberíamos hacer lo
siguiente:

``` csharp
string path = String.Format(".{0}scripts{0}jquery.js", System.IO.Path.DirectorySeparatorChar);
```

## Data Bases

### SQLite

Instalando la biblioteca `libmono-sqlite` podremos tener acceso a las
clases para acceder a bases de datos SQLite si en nuestro proyecto
referenciamos dicha librería.\
\

Para acceder a una base de datos SQLite debemos crear un objeto
`SqliteConnection` (`Mono.Data.Sqlite.SqliteConnection` para DB SQLite3
o `Mono.Data.SqliteClient.SqliteConnection` para DB SQLite) pasándole
como *connection string* una cadena del estilo `URI=file:fichero`
(siendo fichero el nombre del fichero de la DB). Luego todo funciona
como el conjunto de clases ADO.NET.\
\

El siguiente código lanza una consulta a la base de datos de SQLite3
localizada en el archivo `prueba3.db`:

``` csharp
using System.Data;
using Mono.Data.Sqlite;
...
List<Prueba> list = new List<Prueba>();
string connectionString = "URI=file:prueba3.db";
IDbConnection dbcon;
dbcon = (IDbConnection) new SqliteConnection(connectionString);
dbcon.Open();
IDbCommand dbcmd = dbcon.CreateCommand();
string sql = "SELECT * FROM elements";
dbcmd.CommandText = sql;
IDataReader reader = dbcmd.ExecuteReader();
while(reader.Read()) {
    list.Add(new Prueba() {str = reader.GetString (0)});
}
reader.Close();
reader = null;
dbcmd.Dispose();
dbcmd = null;
dbcon.Close();
dbcon = null;
```

## ASP.NET

### En apache (mod_mono)

Para que apache ejecute archivos .aspx tenemos que instalar los
siguientes paquetes:

    sudo apt-get install libapache2-mod-mono
    sudo apt-get install mono-apache-server2

Luego activar el módulo `mod_mono_auto` y desactivar `mod_mono`:

    sudo a2enmod mod_mono_auto
    sudo a2dismod mod_mono

Luego abriremos `/etc/apache2/mods-available/mod_mono_auto.conf` y
agregaremos:

    MonoServerPath "/usr/bin/mod-mono-server2"

Las webs ASP.NET se agregan como cualquier otro tipo de webs. Si da
`error 500 : Standard output has not been redirected or process has not been started.`,
a parte de instalar `xsp` y `xsp2` y a la vez:

    try: 
    sudo find /usr/bin | grep gmcs
    if result is NOT
      /usr/bin/gmcs
      /usr/bin/gmcs2
    try
     1)install mono-gmcs package (if only have “/usr/bin/gmcs”)
     or
     2)in case you have only “/usr/bin/gmcs2″ make symlink on it named gmcs
       sudo ln -s /usr/bin/gmcs2 /usr/bin/gmcs
    restart apache2 or xsp or your web server and check result in browser. I think it would help.

### XSP2

`xsp2` es el nombre del servidor de asp.net especial para mono. Al
ejecutar el comando `xsp2` se crea un servidor en el puerto 8080 en el
directorio donde se ejecute, aunque pueden configurarse sus aplicaciones
web (`webapp`).

## MonoDevelop

-   Haciendo sobre un proyecto\\solución
    `botón derecho --> Herramientas --> Crear paquete --> Binarios`
    podremos crear un comprimido con elementos que componen la web, sin
    el código fuente innecesario y con los elementos marcados con la
    propiedad `contenido`.
-   :?: No es posible meter código de C# 3 en la carpeta `App_Code`.
-   Las propiedades de los archivos `App.config` han de ser definidas
    como:
    -   `Acción de construcción: Definición de la aplicación.`
    -   `Copiar al directorio de salida: Copiar siempre.`

## C# Shell

-   <http://www.mono-project.com/CsharpRepl>

Desde *Mono 2.2* podemos tener una shell dinámica como la que tiene
Python. Para ello desde la consola escribiremos `csharp`, si quisieramos
una con GUI haremos `gsharp` (las `mono-tools` tendrán que estar
instaladas).

### Uso

Podemos mostrar variables o valores facilmente:

``` csharp
csharp> "a" == "a";
true
csharp> (3 + 4) != 2;
true
csharp> var b = 3;
csharp> b;
3
```

#### Funciones de utilidad

-   **help;**: Muestra la ayuda.
-   **quit;**: Sale del shell.
-   **ShowVars();**: Muestra las variables definidas.
-   **ShowUsing();**: Muestra los using utilizados.
-   **LoadPackage(string);**:
-   **LoadAssembly(string);**: Carga la dll indicada:

``` csharp
csharp> LoadAssembly("/home/alfred/Projects/dllTest/dllTest/bin/Debug/dllTest.dll");
csharp> dllTest.MyClass.Saludo();
"Hola caracola!!"
```

### gsharp

Además de lo que se puede hacer desde el shell también podremos:

-   Mostrar imágenes.

``` csharp
Image.FromFile("/home/alfred/Escritorio/about.jpg");
```

-   Utilizar la función `Plot` para representar funciones matemáticas:

``` csharp
Plot(x => 15*Math.Sin(x/7), x=> x*x);
```

### Notas

-   Los archivos .dll que se guarden en el directorio `csharp` o
    `gsharp` de la ruta que devuelva
    `Environment.GetFolderPath (Environment.SpecialFolder.ApplicationData)`
    se cargarán al inicio.
-   Para ejecutarlo en Windows haremos:
    1.  Start -\> All Programs -\> Mono 2.6.1 for Windows -\> Mono-2.6.1
        Command Prompt
    2.  `c:\> gsharp`

## Notas

-   La aplicación [MoMA](http://mono-project.com/MoMA) sirve para
    analizar un ensamblado creado en el framework .NET y te indica si es
    portable a Mono.
-   En las [Guías de inicio](http://www.mono-project.com/Start) de mono
    encontrarás recursos sobre como crear aplicaciones de escritorio,
    acceder\\crear webservices\...

### Linq en MonoDevelop 2.0

Aunque el intellisense no funcione correctamente, el siguiente código
compila correctamente para un proyecto en versión 3.5 y con las
referencias `System` y `System.Core` agregadas:

``` csharp
using System;
using System.Linq;
using System.Collections.Generic;
using System.Data.Linq;

namespace PruebaLinq
{
    class MainClass
    {
        public static void Main(string[] args)
        {
            List<string> l = new List<string>();
            l.Add("hola");
            l.Add("buenos días");
            l.Add("qué tal?");
            l.Add("todo bien?");
            
            var b = (from s in l select s).ToList();
            foreach (var i in b)
                Console.WriteLine(i);
            Console.ReadLine();
        }
    }
}
```
