# Notas de C++.NET

### Nuevo tipo de punteros

En punteros para código manejado (.NET) el signo usado para
identificarlos es distinto: \^, además, con este tipo de punteros no se
usa el new, sino el gcnew.

``` cpp
Socket^ sck = gcnew Socket ();
```

### Tipo NULO

No usaremos null, ni NULL, sino \'nullptr\'.

### Acceder a miembros estáticos

En C++ .NET los miembros estáticos son accedidos mediante:

``` cpp
Clase::Metodo();
```

### Delegados

Por alguna extraña razón que no acabo de entender, si al crear un
delegado vamos a usar un método miembro no estático de la clase en la
que estamos (o de un objeto) deberemos colocar el nombre del objeto en
la creación del delegado:

-   Si el método no es estático:

``` cpp
AsyncCallback ^asc = gcnew AsyncCallback(this, &Form1::ReceiveData);
```

-   Si es estático:

``` cpp
AsyncCallback ^asc = gcnew AsyncCallback(&Form1::ReceiveData);
```

Puede que lo de los métodos no estáticos sólo sean usados en el
constructor.

### Arrays

Declaración:

``` cpp
array<unsigned char> ^buffer; 
```

Inicialización:

``` cpp
buffer = gcnew array<unsigned char>(1000);
```

Inicialización con valores:

``` cpp
array<unsigned char> ^IP = gcnew array<unsigned char> { 198, 168, 1, 1};
```
