# Google Static Maps (v2)

-   [API](http://code.google.com/intl/en/apis/maps/documentation/staticmaps/)

Permite agregar imágenes de Google Maps a las aplicaciones. El servicio
retorna una imágen estática del mapa de Google según la posición
indicada a partir los parametros pasados a una URL enviada mediante
peticiones HTTP. Para cada petición podemos indicar el tipo de imágen,
la posición en el mapa, el tamaño de la imágen, el nivel de zoom, el
tipo de mapa y definir marcadores.\
\
El servicio tiene **limitaciones** para evitar su abuso, sólo es posible
realizar 1000 peticiones distintas por día y cliente, si se excediese el
límite aparecería una imágen indicándolo y dejaría de funcionar
temporalmente, si este límite es sobrepasado continuamente puede llegar
a bloquearse el acceso a la API.\
El tamaño máximo de una URL es de 2048, esta longitud debería ser
suficiente a no ser que se agregasen demasiados marcadores o rutas.

## Uso

Una URL de petición a Google Static Maps ha de tener el siguiente
formato, estando los parámetros separados por el caracter *ampersand*
(`&`).

    http://maps.google.com/maps/api/staticmap?parameters

Los parámetros son los siguientes:

-   **center** (necesario si no se indican marcadores), define el centro
    del mapa. Toma una localización separada por comas (latitud,
    longitud), como por ejemplo \"40.714728,-73.998672\", aunque también
    podría tomar una dirección \"city hall, new yourk, ny\".
-   **zoom** (necesario si no se indican marcadores), define el nivel de
    zoom en el mapa. Toma un valor numérico.
-   **size** (necesario), define las dimensiones de la imágen
    resultante. Su valor es un string con el formato `Value`x`Value`,
    por ejemplo 500x400.
-   **format** define el formato de la imágen resultado (por defecto
    PNG) que puede ser GIF, JPEG y PNG.
-   **maptype** define el tipo de mapa, entre los varios existen
    `roadmap`, `satellite`, `hybrid` y `terrain`.
-   **mobile** indica si el mapa se mostrará en un movil, permite `true`
    o `false`.
-   **language** define el lenguaje de las etiquetas.
-   **markers** indica si se agregarán marcadores, estos se separarán
    por `|` y se pueden agregar varios.
-   **path** infica un camino de dos o más puntos conectados en la
    imágen, también separados por `|`.
-   **visible** utilizado para indicar si algunas características del
    mapa serán visibles.
-   **sensor** (necesario) indica si la aplicación utiliza un sensor que
    determina la localización del usuario.

Ejemplo:

    http://maps.google.com/maps/api/staticmap?center=Barcelona&zoom=14&size=400x400&sensor=false

## Cómo\...
