# as3corelib

## Utilización

### Deserializar datos JSON

Necesitaremos importar el `com.adobe.serialization.json.JSON`, a partir
de entonces podremos hacer una llamada a `JSON.decode` al cual se le
pasa un string (con lo que te ha devuelto el servicio JSON) y te
devuelve \"lo que elijas\":

``` xml
<mx:Script>
        <![CDATA[
            import mx.collections.ArrayCollection;
            import mx.rpc.events.ResultEvent;
            import com.adobe.serialization.json.JSON;

            private function onJSONLoad(event:ResultEvent):void
            {
                var rawData:String = String(event.result);
                var arr:Array = (JSON.decode(rawData) as Array);
                var dp:ArrayCollection = new ArrayCollection(arr);
                cmb.dataProvider = dp;
                cmb.labelField = "denominacion";
            }
            
            public function load ()
            {
                service.send();
            }
        ]]>
</mx:Script>

<mx:HTTPService id="service" 
    resultFormat="text" 
    method="GET" 
    url="http://srvctrl/web-app-test/controllers/json/sae_lineas.ashx?parada=2289" 
    result="onJSONLoad(event)" />

<mx:Panel>
<mx:ComboBox id="cmb" />
<mx:Button click="{load();}" />
</mx:Panel>
```

O en vez de un array un objeto:

``` actionscript
var rawData:String = String(event.result);
var person:Object = JSON.decode(rawData);
txtName.text = person.first_name + " " + person.last_name;
txtEmail.text = person.email;
```

## Datos de la librería

-   [Link](http://code.google.com/p/as3corelib/)
-   ![Librería](/fw/as3corelib/as3corelib-.92.1.zip)
