# RDBMS

## MySQL

### Empezando\...

#### Instalación

    $ sudo apt-get install mysql-server

#### Creación de usuarios

    mysql> CREATE USER 'alfred' IDENTIFIED BY 'a';
    mysql> GRANT ALL ON *.* TO 'alfred'@'localhost' IDENTIFIED BY 'a';
    mysql> FLUSH PRIVILEGES;

#### Acceso remotamente

Acceder a `/etc/mysql/my.conf`, buscar línea `bind-address=...` e
insertar `bind-address=0.0.0.0`. Luego\...

    $ service mysql restart

#### Configuración

Cuando MySQL esté instalado y lo ejecutemos por primera vez este se
configurará. Una vez esta tarea se realice deberemos dar el password al
root mediante el siguiente comando:

    /usr/bin/mysqladmin -u root password 'new-password'

Se aconseja eliminar los usuarios anonimos que vienen por defecto:

    DELETE FROM mysql.user WHERE User='';
    DELETE FROM mysql.db WHERE User='';
    FLUSH PRIVILEGES;

#### Comandos de consola

-   `mysql`, abre el cliente nativo de mysql. Distingue entre el
    ejecutable con el mismo nombre que lanza el server.
-   `mysql -u user -p`, entra con el usuario *user* y pida su password.

### Comandos

Recuerda, tras cada comando coloca un \';\'

-   **show** *\[databases \| tables \| columns\]* muestra los elementos
    indicados.
    -   Para mostrar las tablas o las columnas debes de estar conectado
        a una base de datos.
    -   Para mostrar las columnas de la tabla *tablaX*:
        `show columns from tablaX;`.
    -   Para mostrar las tablas de la base de datos *dbX*:
        `show tables from dbX;`.
    -   Para mostrar propiedades de una tabla: `show table status`. -
        Ver más abajo.
-   **exit** sale de mysql.
-   **connect**, conecta con el servidor, puedes indicar a qué base de
    datos conectar directamente.
-   **use nombre**, conecta a la base de datos con el nombre indicado.
-   **describe tabla** muestra los detalles (columnas, tamaño de
    estas\...) de una tabla. Se puede acortar con **desc tabla**.
-   **source** *archivo* ejecuta un archivo .sql.

#### SHOW TABLE STATUS

-   **Sintaxis:**
    `SHOW TABLE STATUS [FROM db_name] [LIKE 'pattern' | WHERE expr]`

Este comando te muestra las propiedades de una tabla (como por ejemplo
el último índice asignado). Para consultar una tabla concreta harías:
`SHOW TABLE STATUS LIKE tabla_concreta`.\
Las propiedades que te muestra son:

-   Name, el nombre.
-   Engine, el tipo de motor usado para almacenar.
-   Version, el número de versión de la tabla.
-   Row_format, el formato de línea (Fixed, Dynamic, Compressed,
    Redundant, Compact).
-   Rows, el número de filas.
-   Avg_row_length
-   Data_length
-   Max_data_length
-   Index_length
-   Data_free, bytes no asignados.
-   Auto_increment, el próximo valor de auto incremento.
-   Create_time, cuando fue creada.
-   Update_time, cuando fue actualizada.
-   Check_time
-   Collation
-   Checksum
-   Create_options
-   Comment

### Volcado de datos

Desde un archivo .sql a la DB:

    $ mysql -u <user> -p <database> <file>

Desde la DB a un .sql:

    mysqldump -user -p basedatos > basedatos.sql

### Administración de usuarios

-   **Cambiar una contraseña** de un usuario:
    `SET PASSWORD FOR usuario@dominio=PASSWORD('nuevo_password')`

```{=html}
<!-- -->
```
    SET PASSWORD FOR root@localhost=PASSWORD('password');

-   **Para eliminar un usuario** hay que eliminar el registro de las
    bases de datos *user* y *db*.

```{=html}
<!-- -->
```
    DELETE FROM mysql.user WHERE User='alfred';
    DELETE FROM mysql.db WHERE User='alfred';
    FLUSH PRIVILEGES;

`FLUSH PRIVILEGES` activa los cambios de privilegios.

-   **Crear usuarios**, utiliza el comando
    `GRANT privilegios ON donde TO usuario IDENTIFIED BY 'password`\',
    siendo\...
    -   Privilegios: *USAGE, SELECT, INSERT, UPDATE, CREATE, ALTER,
        DELETE, DROP\...* Separados por comas si damos varios o *ALL* si
        le damos todos.
    -   Donde: `database.table`.

```{=html}
<!-- -->
```
    GRANT SELECT ON *.* TO tina IDENTIFIED BY 'muller';
    GRANT ALL ON db1.* TO tina IDENTIFIED BY 'muller';

Si el usuario sólo puede conectarse desde un solo ordenador el nombre de
usuario lo indicariamos como: `usuario@identificador_maquina`. Si no se
indica el identificador de la máquina (que podrá ser una ip o el nombre
de la máquina) el usuario tendrá acceso desde fuera de la red y en el
campo `Host` de la tabla `mysql.user` el valor será %.\
Al ejecutar mysql, el cliente, si no especificamos nombre de usuario,
entraremos como el usuario en el que estemos logueados en la máquina.

-   Para **quitar privilegios** utilizamos el comando *REVOKE* de la
    misma forma que se utiliza el *GRANT*.

### Notas

-   El puerto por defecto es el 3306.

## Sqlite

Sqlite es una base de datos dentro de un fichero, es muy manejable y
ligera, usa sql standard pero, como imaginarás no es muy potente.
Actualmente existen dos versiones posibles la sqlite 2 y la 3, para
crear\\usar una base de datos en UNIX (a parte de, evidentemente, tener
instalados los paquetes) sólo tendremos que usar los comandos que la
definenen seguidos del nombre de la base de datos:

    sqlite myDb.db
    sqlite3 mySecondDb.db

Ahora podemos lanzar comandos como **.tables** o **.quit**, que
describen las tablas existentes o salen de la base de datos
respectivamente, o lanzar comandos sql:

``` sql
create table prueba (id integer);
```

Para recoger el último identificador generado para un registro insertado
utilizaremos el comando:

``` sql
SELECT last_insert_rowid();
```

Para insertar una fecha:

``` sql
update files set created = '2029-11-06' where id=1;
```

Para crear una tabla con identificador con autoincremento:

``` sql
CREATE TABLE t1(a INTEGER PRIMARY KEY, b INTEGER);
```

### DataTypes

``` sql
CREATE TABLE t1(
    t  TEXT,     -- text affinity by rule 2
    nu NUMERIC,  -- numeric affinity by rule 5
    i  INTEGER,  -- integer affinity by rule 1
    r  REAL,     -- real affinity by rule 4
    no BLOB      -- no affinity by rule 3
);

-- Values stored as TEXT, INTEGER, INTEGER, REAL, TEXT.
INSERT INTO t1 VALUES('500.0', '500.0', '500.0', '500.0', '500.0');
SELECT typeof(t), typeof(nu), typeof(i), typeof(r), typeof(no) FROM t1;
text|integer|integer|real|text

-- Values stored as TEXT, INTEGER, INTEGER, REAL, REAL.
DELETE FROM t1;
INSERT INTO t1 VALUES(500.0, 500.0, 500.0, 500.0, 500.0);
SELECT typeof(t), typeof(nu), typeof(i), typeof(r), typeof(no) FROM t1;
text|integer|integer|real|real

-- Values stored as TEXT, INTEGER, INTEGER, REAL, INTEGER.
DELETE FROM t1;
INSERT INTO t1 VALUES(500, 500, 500, 500, 500);
SELECT typeof(t), typeof(nu), typeof(i), typeof(r), typeof(no) FROM t1;
text|integer|integer|real|integer

-- BLOBs are always stored as BLOBs regardless of column affinity.
DELETE FROM t1;
INSERT INTO t1 VALUES(x'0500', x'0500', x'0500', x'0500', x'0500');
SELECT typeof(t), typeof(nu), typeof(i), typeof(r), typeof(no) FROM t1;
blob|blob|blob|blob|blob

-- NULLs are also unaffected by affinity
DELETE FROM t1;
INSERT INTO t1 VALUES(NULL,NULL,NULL,NULL,NULL);
SELECT typeof(t), typeof(nu), typeof(i), typeof(r), typeof(no) FROM t1;
null|null|null|null|null
```

Equivalencias:

  ----------------------------------------------------------------------------------------------------------------- --------- ---
  INT, INTEGER, TINYINT, SMALLINT, MEDIUMINT, BIGINT, UNSIGNED BIG INT, INT2, INT8                                  INTEGER   1
  CHARACTER(20), VARCHAR(255), VARYING CHARACTER(255), NCHAR(55), NATIVE CHARACTER(70), NVARCHAR(100), TEXT, CLOB   TEXT      2
  BLOB, *no datatype specified*                                                                                     NONE      3
  REAL, DOUBLE, DOUBLE PRECISION, FLOAT                                                                             REAL      4
  NUMERIC, DECIMAL(10,5), BOOLEAN, DATE, DATETIME                                                                   NUMERIC   5
  ----------------------------------------------------------------------------------------------------------------- --------- ---

### DATE & TIME formats

Los formatos de fecha que sqlite acepta son:

-   `"YYYY-MM-DD"`
-   `"YYYY-MM-DD HH:MM"`
-   `"YYYY-MM-DD HH:MM:SS"`
-   `"YYYY-MM-DD HH:MM:SS.SSS"`
-   `"YYYY-MM-DDTHH:MM"`
-   `"YYYY-MM-DDTHH:MM:SS"`
-   `"YYYY-MM-DDTHH:MM:SS.SSS"`
-   `"HH:MM"`
-   `"HH:MM:SS"`
-   `"HH:MM:SS.SSS"`
-   `"now"`
-   `"DDDDDDDDDD"`

## Documentos

-   ![Qué hacer y qué no hacer con SQL](/db/docs/sqldodont.pdf)
