# TDD (Test Driven Development)

## Basics

El TDD es una metodología de diseño. No de desarrollo ni de tests.

### Test unitarios y funcionales

### TDD pipeline

![](/code/tdd/tdd_cycle.jpg){width="200"}\

1.  **Add test**, escribir un test que utilice la funcionalidad que se
    quiere implementar.
2.  **Watch test fail**, si la prueba no falla es que no es idónea,
    escogemos otra.
3.  **Write code**, escribimos el código *mínimo* para que la prueba
    pase.
4.  **Run tests**, hacemos el código funcional mientras vamos corriendo
    los tests.
5.  **Refactor**, ponemos el código bonito.

Y volvemos a empezar\...

### Best Practices

-   Have separate source and test folders. Test code should follow the
    structure of source.
-   Test should fail the first time it's written/run.
-   Test names should reflect intent, and names should be expressive.
-   Refactor to remove duplicate code after passing test.
-   Re-run tests after every refactoring.
-   Only write new code when a test is failing. Each test should test
    new/different behavior.
-   Write the assertion first.
-   Minimize the assertions in each test.
-   All tests should pass before writing the next test.
-   Only refactor when all tests are passing.
-   Write the simplest code to pass the test.
-   Don't introduce dependencies between tests. Test should pass when
    run in any order.
-   Tests should run fast. A slow test is a test that won't get run.
-   Use mock objects to test code at system boundaries (e.g. database,
    container, file system) so that tests run fast.

### Why unit tests?

Every day in our office there is an exchange which goes something like
this:\
\
*Man, I just love unit tests, I\'ve just been able to make a bunch of
changes to the way something works, and then was able to confirm I
hadn\'t broken anything by running the test over it again\...*\
\
The details change daily, but the sentiment doesn\'t. Unit tests and
test-driven development (TDD) have so many hidden and personal benefits
as well as the obvious ones that you just can\'t really explain to
somebody until they\'re doing it themselves.

1.  Unit Tests allows you to make big changes to code quickly. You know
    it works now because you\'ve run the tests, when you make the
    changes you need to make, you need to get the tests working again.
    This saves hours.
2.  TDD helps you to realise when to stop coding. Your tests give you
    confidence that you\'ve done enough for now and can stop tweaking
    and move on to the next thing.
3.  The tests and the code work together to achieve better code. Your
    code could be bad / buggy. Your TEST could be bad / buggy. In TDD
    you are banking on the chances of both being bad / buggy being low.
    Often it\'s the test that needs fixing but that\'s still a good
    outcome.
4.  TDD helps with coding constipation. When faced with a large and
    daunting piece of work ahead writing the tests will get you moving
    quickly.
5.  Unit Tests help you really understand the design of the code you are
    working on. Instead of writing code to do something, you are
    starting by outlining all the conditions you are subjecting the code
    to and what outputs you\'d expect from that.
6.  Unit Tests give you instant visual feedback, we all like the feeling
    of all those green lights when we\'ve done. It\'s very satisfying.
    It\'s also much easier to pick up where you left off after an
    interruption because you can see where you got to - that next red
    light that needs fixing.
7.  Contrary to popular belief unit testing does not mean writing twice
    as much code, or coding slower. It\'s faster and more robust than
    coding without tests once you\'ve got the hang of it. Test code
    itself is usually relatively trivial and doesn\'t add a big overhead
    to what you\'re doing. This is one you\'ll only believe when you\'re
    doing it.
8.  I think it was Fowler who said: \"Imperfect tests, run frequently,
    are much better than perfect tests that are never written at all\".
    I interpret this as giving me permission to write tests where I
    think they\'ll be most useful even if the rest of my code coverage
    is woefully incomplete.
9.  Good unit tests can help document and define what something is
    supposed to do
10. Unit tests help with code re-use. Migrate both your code and your
    tests to your new project. Tweak the code till the tests run again.

## Patrones

## Notas

-   ![Unit and functional tests](/code/tdd/testing_fun_really_.pdf)
-   ![Unit test
    patterns](/code/tdd/advanced_unit_test_part_v_-_unit_test_patterns_-_codeproject.pdf)
-   [Anti patterns
    catalogue](http://stackoverflow.com/questions/333682/tdd-anti-patterns-catalogue)
-   [How to make unit
    tests?](http://www.ibm.com/developerworks/java/library/j-test/index.html)
-   [Videos of unit test
    patterns](http://www.youtube.com/playlist?list=PL0CCC6BD6AFF097B1)
