# GIT

## Conceptos

El **working tree** es el directorio de trabajo, donde se crea un
repositorio.

Un **commit** es la actualización del registro local en la máquina; los
commits se identifican por un hash. A un commit se le puede asignar una
**tag** que es un alias.

Un **push** es la actualización del repositorio remoto a partir de los
cambios realizados por el commit.

![](/code/git/mgav9.png){width="400"}

Una **branch** es una copia del master desde la cual trabajar. Para
fusionar dos branches se hace un **merge**.

Un repositorio **remote** consiste en un repositorio que no está en
máquina local.

**origin** es una keyword que indica el repositorio inicial (donde se
recogieron los archivos, donde se empezó a guardar\...).

## Uso

### Clone

Obtener un repositorio externo:

    $ git clone <ruta>

Obtener un repositorio usando con otro nombre en local:

    $ git clone git://github.com/schacon/grit.git otro_nombre

Obtener una branch concreta de un repsitorio:

    $ git clone git://github.com/schacon/grit.git -b dev

### Ficheros

#### Borrado

Borrar un fichero tanto local como en repositorio:

    $ git rm filename.ext

Borrar un fichero sólo del repositorio:

    $ git rm --cached mylogfile.log

Borrar un directorio entero en el repositorio pero no en local:

    $ git rm -r --cached folderName

### Commits

Indicar el commit con el comentario directamente:

    $ git commit -m "the 1st commit"

Realizar un commit de cambios actualizando automáticamente los ficheros
que ya existen en el working tree pero sin añadir nuevos:

    $ git commit -a -m "commit message"

### Push

Para subir unos cambios registrados en local al servidor:

    $ git push repo_name branch_name

### Tags

Para identificar un commit sin tener que referirse a él por el hash
haremos (siendo `3720b35` el hash):

    $ git tag working 3720b35

\... O podremos taggear el último:

    $ git tag my_identifier

Muchas veces se hacen tags por versión:

    $ git tag 1.0.3

Podríamos haccer:

    $ git diff working..broken 

Podemos conocer una lista de tags existentes

    $ git tag

O eliminar una tag concreta:

    $ git tag -d my_tag

### Branches

Antes de hacer una branch actualiza el master (pull).

Crear una branch:

    $ git branch my_branch

Subir la branch a un repositorio externo:

    $ git push origin my_branch

Cambiar de branch:

    $ git checkout my_branch

Saber qué branch es la tuya actual (la que tiene estrella):

    $ git branch 

También podemos:

-   `git branch -a`, ver todas las branches, las remotas también.
-   `git branch -v`, ver más información sobre las branches.

Eliminar una branch localmente:

    $ git branch -d the_local_branch

Eliminar una branch remota:

    $ git push origin --delete the_remote_branch

Eliminar una branch remota (alternativa):

    $ git push origin :the_remote_branch

Unir tu branch al repositorio:

    $ git merge master

Eliminar una branch del working tree:

    $ git branch -d my_branch

### Merge de branches

#### Forzar\\sobreescribir

Cuando quieras forzar un merge de una branch te pondrás en la destino
(`checkout`) y harás:

    $ git merge -X <opcion> <branch>

Donde la opción puede ser `ours` o `theirs` según la versión que se
prefiera en caso de conflicto (ours para la versión de la branch actual
y theirs para la de la que quieres hacer merge).

## Versiones

Para volver temporalmente a una versión anterior

    $ git checkout <id_commit>

## Workflows

### El tuyo

#### GitHub

Obtener un repsitorio:

    $ git clone https://github.com/ElectronicStars/Hindbrain

Actualizar el repositorio:

    $ git add .
    $ git commit -a
    $ git push

Subir a una branch que no existe en GitHub o que es distinta a la
master:

    $ git push origin my_branch

## Administración de repositorios

## Git Avanzado

## Notas

### Recursos

#### Tutoriales

-   [Git Immersion](http://gitimmersion.com/)
