# Ejemplos de física

## Leyes de Newton

### Movimiento de un objeto

Podemos representar un objeto en una posición (punto x,y), con una
velocidad (vector), una aceleración (vector) y una masa (número) desde
[Processing](/highlevel/processing) como\...

``` java
class Objeto {
  PVector location;
  PVector velocity;
  PVector acceleration;
  float mass;
  float max_vel;
  Objeto(PVector loc, PVector vel, float mass) {
    acceleration = new PVector(0,0);
    velocity = vel.get();
    location = loc.get();
    this.mass = mass;
  }
  void update () {
    velocity.add(acceleration);
    location.add(velocity);
    acceleration.mult(0);
  }
  void applyForce (PVector force) {
    force.div(mass);
    acceleration.add(force);
  }
  void draw () {
    ellipse(location.x, location.y, 20, 20);
  }
}

Objeto obj;

void setup() {
  size (500, 500);
  background(255);
  obj = new Objeto(new PVector(width / 2, height / 2), new PVector(0, 0), 5);
  strokeWeight(3);
}

void draw () {
  background(255);
  // applyForce
  obj.update();
  obj.draw();
}
```

A partir de este podemos\...

-   **Cambiar la velocidad inicial** cambiando la creación del objeto:

``` java
obj = new Objeto(new PVector(width / 2, height / 2), new PVector(-3, 2), 5);
```

-   **Aplicarle una o varias fuerzas**

``` java
PVector wind = new PVector(0.3,0);
PVector gravity = new PVector(0,0.5);
obj.applyForce(wind);
obj.applyForce(gravity);
```

Con esto mostraríamos, para un objeto en una posición (10, 20) con masa
5 y una velocidad inicial de (-3, 2):

1.  Aceleración causada por viento desde la derecha (5, 0):
    \<m\>Aceleración por viento = viento / masa = (5,0) / 5 =
    (1,0)\</m\>
2.  Aceleración causada por la gravedad (0, 10): \<m\>Aceleración por
    gravedad = gravedad / masa = (0,10) / 5 = (0,2)\</m\>
3.  \<m\>Aceleración total = (1,0) + (0,2) = (1,2)\</m\>
4.  \<m\>Velocidad = velocidad + aceleración = (-3,2) + (1,2) =
    (-2,4)\</m\>
5.  \<m\>Posición = posición + velocidad = (10,20) + (-2,4) =
    (8,24)\</m\>

También podemos agregar resistencia con **\"viscosidad\"** al objeto:

``` java
float c = -0.5;
PVector thingVel = obj.velocity;
PVector force = PVector.mult(thingVel, c);
obj.applyForce(force);
```
