# R

Es un lenguaje y entorno de programación para análisis estadístico y
gráfico.\
Existe un IDE para trabajar con el lenguaje denominado
[RStudio](http://www.rstudio.org). Para instalarlo en Ubuntu añadiremos
el paquete `r-base`.

## Básico

### Funciones básicas

-   `dim(variable)`: Devuelve la dimensión de una variable (*filas x
    columnas*).
-   `class(variable)`: Devuelve el tipo de datos que es la variable.
-   `summary(variable)`: Devuelve un resúmen (máximos, mínimos, número
    de elementos de una categoría\...) de una variable (matriz,
    data.frame\...).

Mostrar por pantalla:

-   `print(variable)`: Muestra por pantalla un texto.
-   `sprintf("formato", variables)`: Devuelve, **no lo muestra**, un
    string formateado.

Strings:

-   `s = paste(s, "Delta", sep="")`: Concatena al string `s` la palabra
    `Delta` con ninguna separación.

Listas:

-   `a = c(2, 3, 5)`: creará una lista de tres números.
-   `a = c(c(2, 3, 5), 3)`: creará una lista de cuatro números.

Trabajo con paquetes:

Para la ayuda:

-   `?? funcion`: Busca en la ayuda disponible los registros que casan
    con el nombre de esta función.
-   `help funcion`: Muestra la ayuda para la función.

### Variables

#### Variables categóricas

En R son denominadas `factor` y sus categorías `levels`.\
\
Podremos crear una variable categórica a partir de una que no lo es
(asignando los distintos valores que tiene como levels) de la siguiente
forma:

    Dictamen <- factor(Dictamen)

Podremos ver los levels de una variable factor mediante:

    levels(Dictamen)

Podremos cambiar los nombres de los levels mediante:

    levels(Dictamen) <- c("positiu","negatiu")''

#### Operadores

-   `ifelse(a>0,a,0)` : Operador ternario.

### Conjuntos de datos

#### Generación

-   `rep`: genera una serie de valores repeticas veces.

```{=html}
<!-- -->
```
    > rep(1:4, 2)
    [1] 1 2 3 4 1 2 3 4
    > rep (c(1,2), 2)
    [1] 1 2 1 2
    > rep (0, 5)
    [1] 0 0 0 0 0

#### Acciones sobre un conjunto de datos

Para cambiar los valores de un conjunto de datos lo podremos hacer como
sigue (aquí cambia los registros de Ingressos que tengan valor 99999999
o 0 por NA):

    Ingressos[Ingressos == 99999999 | Ingressos == 0] <- NA

Si en vez de convertirlos a NA los quisiesemos eliminar (el ejemplo
elimina los registros que no tienen 0 ni en la columna 1, en la 3, en la
6 ni en la 8):

    dd <- dd[dd[,1] != 0 & dd[,3] != 0 & dd[,6] != 0 & dd[,8] != 0,]

Si quisiesemos ver un conteo del contenido podríamos hacer (el ejemplo
devuelve el número de registros que tienen en la columna 1 un 0):

    table(dd[,1]==0)

Contar el número de elementos que tienen en la primera variable el valor
concreto\...

    sum(datos[,1] == 2)

Seaparar unos datos `Data` en dos tablas y de forma aleatoria:

    learn <- sample(1:150, 75)
    mydata.learn <- Data[learn, ]
    mydata.test <- Data[-learn, ]

Para conocer el número de filas y de columnas de un conjunto de datos
utilizaremos la funcion `nrow` y `ncol` respectivamente.\
La función `rbind` te permite concatenar dos conjuntos de datos, el
segundo después del primero.\
Podemos recoger un subconjunto si, por ejemplo, tenemos en una variable
`idxs` los indices así: `sub <- conjunto[idxs]`. O el subconjunto
negativo restante `sub <- conjunto[-idxs]`.

#### Vectores y matrices

Creación de una matriz:

    > A <- matrix ( c (1 ,2 ,3 ,4) ,2 ,2 , byrow = TRUE )
    > A
         [,1] [,2]
    [1,]    1    2
    [2,]    3    4

    > a <- matrix ( c (1 ,2 ,3 ,4) ,4 ,1)
    > a
         [,1]
    [1,]    1
    [2,]    2
    [3,]    3
    [4,]    4

-   `scale(X)` centra y reduce (normaliza) la matriz X.
-   Para aplicar una función sobre una matriz utilizaremos `apply`. Esta
    recibe como primer parámetro la matriz, como segundo sobre qué se
    aplicará (1 = filas, 2 = columnas, `c(1,2)` = filas y columnas) y la
    función: `apply (x, 2, sum)`.
-   Con la combinación de signos `%*%` podemos hacer el *dot product*
    (producto escalar) :?: (no sé si es dot product o scalar product,
    también existe %o%).
-   `diag(x)` recibe un vector x y lo coloca como diagonal en una matriz
    de 0.
-   `t(x)` recoge la matriz traspuesta de x.

#### Data Frame

Para crear un Data Frame a partir de dos vectores de dimensión igual:

    dd <- data.frame(x,y)

Para leer un archivo de datos (un csv separado por tabs, columnas\...) y
cargarlo en un data.frame usaremos:

    datos <- read.table("alpha.csv",header=T)

-   `attributes (var)`: Devuelve las propiedades\\acciones que se pueden
    hacer sobre el dataframe var.
-   `names(var)`: Devuelve los nombres de las columnas del data frame.
-   `variable$nombre_columna`: Acceso a una columna del dataframe.

Mediante `attach(var)` haremos accesibles (sin necesidad de acceder por
dataframe\$columna sino como variables) las columnas del data frame.\
Para eliminar una columna de un data frame: `datos$beta2=NULL`\

### Control de flujo

#### If

    if(datos$beta1[i]==1)
        producto_preferido[i] = 1

#### Bucle for

    producto_preferido <- nrow(252)
    for (i in 1:252) {
        producto_preferido[i]=NA
        if(datos$beta1[i]==1)
            producto_preferido[i] = 1
    }

    > for (i in 1:10) {
        print(c(sum(datos[,i] == 1) / nrow(datos), sum(datos[,i] == 2) / nrow(datos)));
    }

#### Funciones

Para crear la función `p.xk` a la que se le pasan dos parámetros, lo que
devuelve es el resultado de último comando ejecutado.

    p.xk <- function(vec,fac){nk <- as.vector(table(fac)); n <- sum(nk); xk <- tapply(vec,fac,mean);
               txk <- (xk-mean(vec))/(sd(vec)*sqrt((n-nk)/(n*nk))); pxk <- pt(txk,n-1,lower.tail=F)}

Si en una función queremos devolver datos complejos haremos lo
siguiente, esto sería: `cv = cvalidation(datos); cv$learn;`

    cvalidation = function (dframe) {
      nregs = nrow(dframe);
      nind_group = nregs/10;
      ilearn = sample(1:nregs, nind_group * 9);
      dlearn <- dframe[ilearn,];
      dtest <- dframe[-ilearn,];
      list(learn = dlearn, test = dtest);
    }

### Usar datos externos

-   `try(data())` devuelve los paquetes de datos disponibles.
-   `data(iris3)` carga los datos de iris3. Por ejemplo, para trabajar
    con ellas:

```{=html}
<!-- -->
```
    data(iris3)
    Data <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]), Sp = rep(c("s","c","v"), rep(50,3)))

## Estadística

### Básico

Generación de una distribución normal:

    x <- rnorm(50)

Recoger la desviación estándard de una matriz, un vector o un dataframe:

    sd(X)

Aunque también podríamos sacarlas (pero centradas con `center` o
escaladas con el vector unidad con `scale`) con:

    pc1 = prcomp(X, scale=T)
    pc1$sdev

### Objetos estadísticos

#### Regresión linear (lm)

Para crear un objeto \"regresión linear\" a partir de las columnas x,y
de un dataframe deberemos indicarlo con `~`:

    reg1 <- lm(dd$y ~ dd$x, data=dd)

#### Regresión local (loess)

    reg2 <- loess(y ~ x, data=dd)

## Gráficos

### Funciones

-   `plot(x)`: Muestra en un gráfico de puntos los elentos de x.
    Podríamos hacer también `plot(x,y)`, que sería poner x en función de
    y.
-   `hist(x)`: Muestra en un histograma la forma de x.

### Como\...

-   **Hacer plots 3d**: los encontrarás en el paquete `rgl`. Contiene
    funciones como `plot3d`\...

## Data Mining & Machine Learning

    data(HouseVotes84, package="mlbench")
    model <- naiveBayes(Class ~ ., data = HouseVotes84) # Entrenamiento, predecir Class
    pred <- predict(model, HouseVotes84[,-1])           # Prediccion (sobre los mismos datos)
    table(pred, HouseVotes84$Class)                     # Tabla de confusión \ contingencia

### Naïve Bayes

## Avanzado

### Funciones

#### K nearest neighbors (knn)

En el package `class`:

    aux = datos[,-10] # Volcado de los datos menos la columna Ingressos
    aux1 = aux[!is.na(Ingressos),] # Cogemos los Ingressos que no tienen NA de aux en aux1
    aux2 = aux[is.na(Ingressos),] # Cogemos los Ingresos que tienen NA de aux
    knn.ing = knn(aux1,aux2,Ingressos[!is.na(Ingressos)]) # Hacemos el knn con los que no tienen NA sobre los que sí tienen 
    Ingressos[is.na(Ingressos)] = knn.ing # Asignamos los nuevos valores

## Notas

### Como\...

#### Crear una tabla

Denominada `pvalk.con` de `nresp` filas y `ncon` columnas y asignar los
nombres de las columnas y las filas a partir de una categórica y de otra
matriz:

    pvalk.con <- matrix(NA,nresp,ncon)
    rownames(pvalk.con) <- levels(tmp)
    colnames(pvalk.con) <- row.names(pvalcon)

#### Limpiar el workspace

    rm(list=ls())

### Notas

-   ![Comparación de MATLAB y R](/math_langs/matlabr.pdf), sacada de
    <http://www.math.umaine.edu/~hiebeler/comp/matlabR.html>.
