# \[More\] Effective C++

## Effective C++

### Evitar macros

Para definir constantes no utilizaremos `#define` sino `const`, es
preferible el procesador al pre-procesador.\
Para los arrays de chars utilizaremos la siguiente notación:

``` cpp
const char * const authorName = "Scott Meyers";
```

En las clases definiremos las constantes como `static`.\
También preferiremos declarar las macros como funciones `inline` a
hacerlas con los `#define`.

### Es preferible iostream a stdio.h

Es decir, es preferible el `cout` o el `cin` al `printf` o `getch`.\
Remarcar también que incluir `iostream` es distinto a incluir
`iostream.h`, esta segunda contiene las funciones como globales en vez
de estar dentro de los namespaces, llevando a poder provocar algún error
de nombres.

### Gestión de memoria

El preferible utilizar los `new` y `delete` en vez del `malloc` y el
`free`.\
Es importante entender que al hacer un array debe llamarse al `delete`
como `delete []`.

``` cpp
string *stringPtr2 = new string[100];

delete [] stringPtr2;
```

Cuando creamos un puntero nulo lo inicializaremos como 0, no como
`NULL`.\
Llamaremos a los delete a los punteros miembros de una clase dentro del
destructor de esta.\
\

Debemos estar preparados por si el sistema se quedase sin memoria, para
ello existe una función llamada `set_new_handler` que recibe por
parámetro la función que se llamará si esto ocurriese:

``` cpp
void noMoreMemory() { 
  cerr << "Unable to satisfy request for memory\n"; 
  abort(); 
} 

int main() { 
  set_new_handler(noMoreMemory); 
  for (long i=0; i<100000000; i++)
    new long[100000000]; 
} 
```

## More Effective C++
