# Tornado

## Básico

-   [Web del proyecto](http://www.tornadoweb.org/en/stable/)
-   [Overview](http://www.tornadoweb.org/en/branch2.4/overview.html) y
    [Documentación](http://www.tornadoweb.org/en/branch2.4/documentation.html).

``` python
import tornado.ioloop
import tornado.web

class MainHandler(tornado.web.RequestHandler):
    def get(self):
        self.write("Hello, world")

application = tornado.web.Application([
    (r"/", MainHandler),
])

if __name__ == "__main__":
    application.listen(8888)
    tornado.ioloop.IOLoop.instance().start()
```

Una aplicación que utilice tornado se define a partir de unos patrones
que indican la ruta y las clases que gestionarán peticiones a dichas
rutas.

### RequestHandler\'s

``` python
class MainHandler(tornado.web.RequestHandler):
    def get(self):
        self.write("You requested the main page")

class StoryHandler(tornado.web.RequestHandler):
    def get(self, story_id):
        self.write("You requested the story " + story_id)

application = tornado.web.Application([
    (r"/", MainHandler),
    (r"/story/([0-9]+)", StoryHandler),
])
```

### Cómo\...

#### \... Instalar?

    $ pip install tornado

#### \... Servir contenido estático?

``` python
application = tornado.web.Application([
    (r'/(.*)', tornado.web.StaticFileHandler, {'path': '../static/'}),
    (r'/(.*)', tornado.web.StaticFileHandler, {'path': '../static/index.html'})
])
```

``` python
class IndexHandler(tornado.web.RequestHandler):
    def get(self, *args, **kwargs):
        self.render('index.html')
```

#### \... Indicar que es debug y se muestre más info por consola?

Como argumento `debug=True` al constructor del objeto aplicación.

## Notas

-   ![Estos apuntes](/fw/tornado/tornado_zmq_websockets.zip) explican
    cómo crear un websocket que publica a partir de datos recibidos por
    ZeroMQ. Fuentes:
    -   <http://zeromq.github.io/pyzmq/eventloop.html>
    -   <https://learning-0mq-with-pyzmq.readthedocs.org/en/latest/pyzmq/multisocket/tornadoeventloop.html>.
    -   <https://github.com/FZambia/tornado-zmq-sockjs-example>
