# Log4net

Librería para el tratamiento de logs para .NET basada en
[log4j](/fw/log4j). Podemos bajárnoslo de
[aquí](http://logging.apache.org/log4net/).\
\

Para poder escribir logs en la aplicación utilizamos objetos `logger`
para instanciar un logger llamaremos al método `GetLogger` de la clase
`LogManager` con un string, este corresponderá al nombre del objeto
`logger`, si luego volvemos a llamarlo con el mismo nombre nos devolverá
el mismo logger. Lo que nos devuelve es un `ILog` y será a partir del
cual llamemos a sus métodos para escribir en el log:

``` csharp
ILog logger = LogManager.GetLogger("MyLogger");
logger.Debug("Mensaje de nivel DEBUG");
logger.Info("Mensaje de nivel INFO");
logger.Warn("Mensaje de nivel WARN");
logger.Error("Mensaje de nivel ERROR");
logger.Fatal("Mwnsaje de nivel FATAL");
```

## Configuración

Tras añadir el proyecto como referencia deberemos indicar cual será el
fichero de configuración que utilice.\
Podemos indicar que será un fichero concreto:

    [assembly: log4net.Config.XmlConfigurator(ConfigFile="Web.config", Watch=true)] 

O podemos indicar que tendrá el mismo nombre que la aplicación pero con
una extensión específica (por ejemplo log4net):

    [assembly: log4net.Config.XmlConfigurator(ConfigFileExtension="log4net", Watch=true)] 

O por ejemplo indicar que será el fichero de configuración por defecto:

    [assembly: log4net.Config.XmlConfigurator(ConfigFileExtension="config", Watch=true)] 

La configuración se hace a partir de un fichero con formato xml con la
siguiente estructura:

-   Elemento **appender** que indica como se guardará el log. Tiene una
    propiedad `name` con la cual se identificará luego. Por ejemplo, si
    indicamos que guardaremos en un fichero (indicando en la propiedad
    `type` el valor `log4net.Appender.FileAppender`) seguirá la
    siguiente estructura:
    -   *file*: Nombre del fichero de log.
    -   *appendToFile*: Puede estar a true o a false, si está a true el
        log se almacena al final del fichero.
    -   *layout*: Indica el formato del log.
-   Elemento **root** corresponde al logger genérico, para configurarlo
    utilizamos:
    -   *level*, indica el nivel de log (en orden ascendente: ALL,
        DEBUG, INFO, WARN, ERROR, FATAL, OFF, es decir si indicamos
        nivel ERROR sólo recibiremos mensajes de ERROR y FATAL).
    -   *appender-ref*: Define el identificador del log.

Un ejemplo de fichero xml de configuración:

``` xml
<?xml version="1.0" encoding="utf-8" ?>
<log4net>
     <appender name="LogFile" type="log4net.Appender.FileAppender">
         <file value="./web-serviceExample.log" />
         <lockingModel type="log4net.Appender.FileAppender+MinimalLock" />
         <appendToFile value="true" />
         <layout type="log4net.Layout.PatternLayout">
             <conversionPattern value="%date %level %thread %logger - %message%newline" />
         </layout>
     </appender>
     <root>
         <level value="DEBUG" />
         <appender-ref ref="LogFile" />
     </root>
</log4net>
```

Y aquí otro ejemplo, corresponde a una porción del fichero de
configuración de la aplicación donde se inserta la configuración de
log4net:

``` xml
<configSections>
    <section name="log4net" type="log4net.Config.Log4NetConfigurationSectionHandler, log4net" />
</configSections>
    
<log4net debug="true">
    <appender name="RollingLogFileAppender" type="log4net.Appender.RollingFileAppender">
        <file value="C:\\TestProj\\TestLog.txt" />
        <appendToFile value="true" />
        <rollingStyle value="Size" />
        <maxSizeRollBackups value="10" />
        <maximumFileSize value="10MB" />
        <staticLogFileName value="true" />
        <layout type="log4net.Layout.PatternLayout">
            <conversionPattern value="%-5p %d %5rms %-22.22c{1} %-18.18M - %m%n" />
        </layout>
    </appender>
    
    <root>
        <level value="DEBUG" />
        <appender-ref ref="RollingLogFileAppender" />
    </root>
</log4net>
```

### Más opciones de configuración

#### Indicar que se muestre en la consola de debug

Para ello agregaremos lo siguiente al archivo de configuración:

``` xml
<appSettings>
    <add key="log4net.Internal.Debug" value="true" />
</appSettings>
```

Y\...

``` xml
<system.diagnostics>
    <trace autoflush="true">
        <listeners>
            <add name="textWriterTraceListener" 
               type="System.Diagnostics.TextWriterTraceListener" 
               initializeData="C:\\TestProj\\TestProjlog4net.txt" />
        </listeners>
    </trace>
</system.diagnostics>
```

#### Utilizar varios loggers

Para definir otro logger haríamos:

``` xml
<logger name="segundoLogger">
    <level value="ERROR" />
     <appender-ref ref="OtroLogFile" />
</root> 
```

Luego, en el código, lo llamaríamos así:

``` csharp
ILog segundoLogger = LogManager.GetLogger("segundoLogger");
```

#### Ejemplos de configuración

Puedes acceder a los ejemplos de configuración existentes en la [página
oficial de
log4net](http://logging.apache.org/log4net/release/config-examples.html).
Allí encontrarás ejemplos para utilizar Oracle, Access, SQLite, la
consola\... como salidas de log.

#### Indicar que no se bloquee el archivo

Lo haremos utilizando las propiedad `lockingModel`:

``` xml
<lockingModel type="log4net.Appender.FileAppender+MinimalLock" />
```

## Appenders

Son las clases encargadas de escribir en distintos medios el log.

### Appenders en log4net

Log4net ya contiene unos appenders configurados para volcar el log sobre
alguna DB, o fichero\... Los existentes los encontraremos en
`log4net.Appender` y son los siguientes:\
Para más información mirar en la documentación [documentación de
log4net](http://logging.apache.org/log4net/release/sdk/log4net.Appender.html)

#### AdoNetAppender

Escribe los eventos de log en una base de datos.

#### AspNetTraceAppender

Escribe los eventos de log sobre una página ASP.

#### ConsoleAppender

Escribe los eventos de log sobre una aplicación de consola (ya sea a
partir del flujo standard de salida o el de error).

#### EventLogAppender

Escribe los eventos de log sobre los sucesos de Windows.

#### FileAppender

Escribe los eventos de log sobre un fichero.

#### RollingFileAppender

Escribe los eventos de log sobre un fichero, puede ser configurado para
crear varios ficheros restringiendo según el tamaño.
