# LESS

Es un lenguaje que compila a CSS.

-   [Página oficial](http://lesscss.org/)
-   [Wiki](https://github.com/cloudhead/less.js/wiki)

Página basada en:
<http://www.genbetadev.com/desarrollo-web/less-el-lenguaje-de-hojas-de-estilo-dinamico>.

## Uso

### Agregar LESS

#### En JavaScript

``` html
<link rel="stylesheet/less" type="text/css" href="styles.less">
<script type="text/javascript" src="less-1.1.3.js"></script></link>
```

#### A partir del compilador

Compilar:

    $ lessc styles.less styles.css

Compilar en modo minified:

    $ lessc styles.less styles.css -x

El compilador, por defecto, funciona con node.js. Puede ser instalado en
Ubuntu con:

    $ sudo apt-get install rubygems1.8
    $ sudo gem install rubygems-update
    $ sudo update_rubygems     
    $ sudo gem install less

## Código

### Variables

#### Definición

Se declaran con `@nombre:valor;`:

    @color: #a8b317;
    a {
        color: @color;
    }
    h2 {
        color: @color;
    }

Compila a:

``` css
a {
    color: #a8b317;
}
h2 {
    color: #a8b317;
}
```

#### Manipulación

Podemos operar sobre ellas:

    @minWidth: 20%;
    @columnLeft: @minWidth * 2;
    @columnRight: @columnLeft + @minWidth;
    @color: #4a785b;
    .sideLeft {
        background-color: @color + #111;
        width: @columnLeft;
    }
    .sideRight {
        background-color: @color;
        width: @columnRight;
    }

Compilaría a:

``` css
.sideLeft {
    background-color: #5b896c;
    width: 40%;
}
.sideRight {
    background-color: #4a785b;
    width: 60%;
}
```

#### Scope

    @var: #333;
    #page {
        @var: #fff;
        #header {
            color: @var; // #fff
        }
    }
    #footer {
        color: @var; // #333
    }

#### Inclusión de strings

Podemos añadir una variable string dentro de otra\...

    @url: "http://www.genbetadev.com";
    background-image: url("@{url}/images/background.png");

### Mixins

Consiste en agregar las propiedades de una clase a otra. Además podemos
incluir parámetros (en el siguiente ejemplo

    .round-corners (@radius: 5px) {
        -moz-border-radius: @radius;
        -webkit-border-radius: @radius;
        border-radius: @radius;
    }

Que podría ser escrito como:

    #header {
        .round-corners;
    }
    #post {
        .round-corners(16px);
    }

Y compilaría:

``` css
#header {
    border-radius: 5px;
    -webkit-border-radius: 5px;
    -moz-border-radius: 5px;
}
#post {
    border-radius: 16px;
    -webkit-border-radius: 16px;
    -moz-border-radius: 16px;
}
```

#### \@arguments

`@arguments` engloba todos los parámetros:

    .shadow (@x: 0, @y: 0, @blur: 1px, @color: #000) {
        -moz-box-shadow: @arguments;
        -webkit-box-shadow: @arguments;
        box-shadow: @arguments;
    }
    .shadow(1px, 2px);

### Anidación de reglas

Podemos generar reglas cuando las tenemos anidadas del estilo\...

    #record {
        h1 {
            font-family: Helvetica, Arial, sans-serif;
            font-weight: bold;
            font-size: 2em;
        }
        p {
            font-size: 12px;
            a {
                text-decoration: none;
                &:hover {
                    color: red;
                }
            }
        }
    }

Compilaría:

``` css
#record  h1{
    font-family: Helvetica, Arial, sans-serif;
    font-weight: bold;
    font-size: 2em;
}
#record p {
    font-size: 12px;
}
#record p a {
    text-decoration: none;
}
#record p a:hover {
    color: red;
}
```

### Funciones de color

    lighten(@color, 10%); // devuelve un color un 10% mas "claro" que @color
    darken(@color, 10%); // devuelve un color un 10% mas "oscuro" que @color
    saturate(@color, 10%); // devuelve un color un 10% "más" saturado que @color
    desaturate(@color, 10%); // devuelve un color un 10% "menos" saturado que @color
    fadein(@color, 10%); // devuelve un color un 10% "menos" transparente que @color
    fadeout(@color, 10%); // devuelve un color un 10% "más" transparente que @color
    spin(@color, 10); // devuelve un color con 10 grados de tono mayor que @color
    spin(@color, -10); // devuelve un color con 10 grados de tono menor que @color
    hue(@color); // devuelve el canal `hue` de @color
    saturation(@color); // devuelve el canal `saturation` de @color
    lightness(@color); // devuelve el canal `lightness` de @color

Que luego usuaríamos\...

    @base: #f04615;
    .class {
      color: saturate(@base, 5%);
      background-color: lighten(spin(@base, 8), 25%);
    }

### Espacios de nombres

Podremos crear las siguientes clases (`.logo .slogan .menu`) englobadas
dentro de `#main_header`:

    #main_header {
        .logo () {
            display: block;
            border: none;
            background: transparent url(../media/logo.png) 0 0 scroll;        
        }
        .slogan { ... }
        .menu { ... }
        ...
    }

Para luego, por ejemplo, utilizar `.logo` en otro namespace (`#header`):

    #header a {
        color: green;
        #main_header > .logo;
    }

### Otras

#### Ignorar elementos

Si por alguna razón queremos que el compilador de LESS deje algún
elemento tal cual esté escrito (por ejemplo porque no compila bien esa
línea) usaremos `~valor`.

    .transparente {
        filter: ~"progid:DXImageTransform.Microsoft.AlphaImageLoader(src='image.png')";
    }

#### JavaScript

Podemos incluir código JavaScript:

    @var: `"genbetadev".toUpperCase() + ' mola!'`;

Generaría\...

``` css
@var: "GENBETADEV mola!";
```

#### Importar

Podemos importar fichero .less y ficheros .css:

    @import "lib.less";
    @import "lib";
    @import "lib.css";
