# GLSL

## Apuntes

-   [Cómo compilar un programa de
    shaders](/fw/ogl/ogl4&#creacion_de_un_programa_de_shaders)

Los vertex shader mapean los vértices en la pantalla. Fragment shaders,
en cambio, se encargan de los colores y del *rasterizing* de los
fragmentos (porciones) de los triangulos resultantes.

### Tipos de variables

-   **in**, enlazan datos de fases anteriores (en versiones antiguas
    también eran llamadas **attribute** para los vertex shaders).
-   **out**, enlanzan datos para fases posteriores.

Las variables **varying**, en versiones anteriores, eran las out de los
vertex shaders y las in de los fragment shaders.

## Vertex Shaders

### Conceptos

#### Coordenadas de pantalla

En la pantalla las coordenadas del framebuffer (-1,-1) y (1,1)
corresponden a la parte baja-izquierda y alta-derecha respectivamente.
Los VAO ya mapean los vértices en esas coordenadas.

### Variables

#### gl_Position

### Sintaxis entre versiones

#### 150

#### 330

## Ejemplos de Vertex Shaders

### Básicos

El más simple de todos, recibe la posición y el color y los reemplaza.

``` c
#version 150
in vec4 vPosition;
in vec4 vColor;
out vec4 color;
void main() {
  gl_Position = vPosition;
  color = vColor;
}
```

## Fragment Shaders

### Variables

Las variables de entrada h an de tener el mismo nombre que en el Vertex
Shader.

#### gl_FragColor

Vector de cuatro elementos que asigna el color RGBA para cada fragmento.

### Sintaxis entre versiones

#### 150

#### 330

## Ejemplos de Fragment Shaders

### Básicos

``` c
#version 150
in vec4 color;
out vec4  fColor;
void main() { 
    fColor = color;
} 
```
