# IronPython

IronPython es un interprete de Python para el CLR (Common Language
Runtime) de .NET, está creado en C# y permite que cualquier programa en
Python pueda ser interpretado con este además de poder acceder a las
bibliotecas .NET.\

-   Para arrancar la consola de IronPython ejecutaremos el programa
    `ipy.exe`.
-   Para arrancar la consola de IronPython permitiendo el autocompletado
    con tab haremos: `ipy.exe -X:TabCompletion`.
-   Para salir de la consola haremos ctrl + Z y luego Enter o F6 y luego
    Enter.
-   Para hacer que IronPython se ejecute en background (sin ventana de
    consola), en vez de usar `ipy.exe` usaremos `ipyw.exe`.
-   Para lanzar un script ejecutaremos IronPython por consola mediante
    el comando que queramos seguido de la ruta del script.

## Básico

### Como en Python\...

-   Desde la consola podemos hacer una llamada a `dir()` lo que nos
    devolverá las posibilidades del entorno.
-   Podemos importar el contenido de un módulo, por ejemplo *sys*:
    `import sys`. Esto dará acceso a dicho módulo el cual podremos
    consultar ahora con `dir(sys)`.
    -   `sys.path` devolverá la ruta de la ejecución de IronPython.
    -   `sys.version`
    -   `sys.executable` devolverá la dirección del ejecutable de la
        aplicación.
-   Hacer `__doc__` trae la documentación de una clase\\función, por
    ejemplo en el módulo first.py importado existe la siguiente función,
    haciendo `first.add.__doc__` nos devolvería el texto que indica lo
    que esta hace.

``` python
def add(a, b):
    "add(a, b) -> returns a + b"
    return a + b
```

-   El comando `import` también puede ser usado para importar al \"por
    defecto\", por ejemplo (y con acceso a .NET) podremos hacer lo
    siguiente, esto permitirá llamar a las funciones `System.Math.Abs`,
    `System.Math.Pow`\... llamandolas únicamente como `Abs`, `Pow`\...

``` python
from System.Math import *
```

-   Tal vez queramos agregar un directorio para que sus archivos .py
    sean accesibles y poder hacer import de ellos (un ejemplo sería la
    librería estándard de Python), para ello en la carpeta Lib de
    IronPython existe un archivo denominado `site.py` (y si no se
    crea!), ese se ejecuta cada vez que se ejecuta un archivo con
    IronPython por lo que podremos agregar el directorio así (por
    ejemplo si tenemos la librería estándard de python en
    c:\\python26\\lib):

``` python
import sys
sys.path.append(r"c:\python26\lib")
```

## .NET

### Namespaces

Para acceder a un namespace de .NET haremos un import de este, por
ejemplo:

``` python
import System
dir (System.Environment)
System.Console.WriteLine("hola mundo!")
```

### Clases

Para utilizar las clases de .NET primero tendríamos que importarlas y
luego, con sintaxis Python, utilizarlas.\
En el siguiente ejemplo se recogen las clases de `System.Collections` y
luego se crea un objeto Hashtable, se introducen sus datos y luego se
muestran estos:

``` python
from System.Collections import *
h = Hashtable()
h["a"] = "IronPython"
h["b"] = "Tutorial"
print h["a"]
for e in h: 
  print e.Key, ":", e.Value
```

Podemos declarar las listas a partir de arrays python:

``` python
l = ArrayList([1,2,3])
s = Stack((1,2,3))
```

### Genericos

Para declarar una clase genérica en IronPython utilizaremos la
declaración como en Python pero antes de los parentesis pondremos entre
corchetes el tipo:

``` python
from System import *
from System.Collections.Generic import *
l = List[String]()
l.Add("hola")
l.Add("adios")
for e in l:
    print e
```

### Acceso a librerías

IronPython puede importar algunas librerías de .NET (las más usadas),
pero para agregar otras estas deben ser referenciadas mediante el módulo
`clr` en el cual podemos encontrar:

-   `clr.AddReference`, que agrega una referencia a un ensamblado .NET.
-   `clr.AddReferenceToFile` agrega una referencia a un ensamblado
    especificando su nombre de fichero, es necesario que el ensamblado
    esté en un directorio listado en `sys.path`.
-   `clr.AddReferenceToFileAndPath`, igual que el `AddReferenceToFile`
    pero este acepta la ruta absoluta.
-   `clr.AddReferenceByName` agrega la referencia especificando el
    nombre completo del ensamblado, por ejemplo:
    `System.Xml, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089`.
-   `clr.AddReferenceByPartialName` agrega la referencia especificando
    un nombre parcial de ensamblado.

Luego deberemos importar el namespace.

``` python
import clr
clr.AddReference("System.Xml")
import System.Xml
d = System.Xml.XmlDocument()
d.Load("file.xml")
```

O con una librería creada por nosotros:

``` python
import clr
clr.AddReferenceToFile("ClassLibrary1.dll")
from ClassLibrary1 import *
c = Class1()
c.Suma(3,5)
```

### Eventos y delegados

Se agregan como en C#, pero en vez de ser métodos de clases son
funciones en Python:

``` python
from System.IO import *
w = FileSystemWatcher()
w.Path = "."
def handle (*args):print args
w.Created += handle
w.Changed += handle
w.EnableRaisingEvents = True
```

Podemos indicar los parámetros:

``` python
def handle (w, a):print a.ChangeType, a.FullPath
```

Y para elminarlos:

``` python
w.Changed -= handle
```

### Windows Forms

Debido a la necesidad de un objeto aplicación y tal durante la ejecución
de un programa con GUI en .NET la cosa se complica con IronPython, pero
podemos hacerlo más fácil importando el archivo `winforms.py` que está
en la carpeta del tutorial, de esa forma los imports y tal ya los hace
este:

``` python
import winforms
from System.Windows.Forms import *

def prueba (*args):
    MessageBox.Show("hola caracola")

form1 = Form()
b = Button()
b.Text = "hola"
b.Click += prueba
form1.Controls.Add(b)
form1.Text = "prueba"
form1.Show()
```

## Como\...

### Crear un array

``` python
import System
System.Array[int]((1,2,3))
```

O\...

``` python
Array[Array[int]]( ( (1,2), (2,3) ) )
```

### Escoger entre métodos sobreescritos

``` python
from System import Console
Console.WriteLine.Overloads[object](None)
```

## Notas

-   Si quisieramos debugar mediante visual studio lo que haríamos sería
    `Archivo --> Abrir proyecto o solución` y eligiríamos el archivo
    `ipy.exe` de IronPython, luego en las propiedades del proyecto
    creado indicar el directorio donde trabajamos y como argumentos `-D`
    y el nombre del archivo. Algo así:

![](/fw/ironpython/prop_project.png){.align-center width="550"}

-   En la carpeta `Tools/Scripts` hay un archivo denominado `pyc.py`
    este es un compilador a CLR. Su uso es `ipy pyc.py script.py`, el
    `script.py` ha de estar en UTF-8.

### Archivos

-   ![Binarios, 2.6](/fw/ironpython/ironpython-2.6-bin.zip), compatible
    con CPython 2.x.
