# Programming Arduino

Respecto a la IDE, un ordenador normal no ejecuta código Arduino, pero
aún así deberemos compilarlo antes de subirlo a la placa. A parte de la
compilación el IDE nos permite acceder al puerto de comunicaciones serie
para ver las respuestas del microcontrolador (botón *serial
communication*), el botón *stop* para dicha comunicación.

## El lenguaje

La función `setup()` es la que primero se llama en una aplicación de
Arduino. Aquí es donde inicializaremos nuestros elementos y
dispositivos. Uno de los comandos más comunes en este apartado sería una
llamada a `Serial.begin()`, que inicializa el puerto serie para el
debug.\
Otra función de Arduino es la `loop()`, esta debe contener todo lo que
se repetirá en nuestra aplicación.\
La inicialización de las variables se puede realizar fuera de las
funciones.

### Datos

#### Arrays

Funcionan como en C:

``` c
int intArray[10];
intArray[4] = 3;
int preini[3] = {1, 2, 3};
```

#### Strings

Funcionan como en C:

``` c
char name[6] = {'a','l','f','r','e','d'};
char name[] = "alfred";
char* myString[] = {"alfred", "gar"};
```

#### Constantes

Las que podemos utilizar en nuestro código:

-   `true/false`
-   `HIGH/LOW`, define el nivel de voltaje.
-   `INPUT/OUTPUT`

### Funciones

-   **pinMode (pin, mode)**: Asigna un modo (INPUT\\OUTPUT) a un pin,
    esto es necesario antes de utilizarlo.
-   **digitalWrite(pin, value)**: Asigna un valor a un pin. Este método
    recibe HIGH o LOW como segundo parámetro, para poder utilizarlo se
    ha de haber asignado el pin indicado como OUTPUT.
-   **digitalRead(pin)**: Lee el valor de un pin, este valor será HIGH o
    LOW. Para poder utilizarlo se ha de haber asignado el pin indicado
    como INPUT.
-   **analogRead(pin)**: Este método retorna un valor entre 0 y 1023 que
    representa el voltaje que recibe ese pin.
-   **analogWrite(pin, value)**: Lo mismo que el anterior pero para
    escribir un valor en un pin.
-   **delay(ms)**: Indica al programa que espere un número de
    milisegundos antes de ejecutar la siguiente instrucción.
-   **millis()**: Devuelve el número de milisegundos desde que el
    programa se inició.

### Otros

#### Importar una librería

Para importar una librería lo hacemos de una forma parecida a como se
hace en C, utilizando el comando `#include <libreria.h>`.\
Una librería consta de cuatro elementos:

-   Un fichero .h, que es la definición de la librería.
-   Un fichero .cpp, el apartado que se compilará.
-   Un fichero *keywords.txt*, que indica qué elementos se han de
    resaltar en el IDE.
-   El binario de la librería.

#### Debugar una aplicación

Para debugar una aplicación en Arduino desde un PC leeremos el puerto
serie, para ello lo primero que debemos hacer es inicializar la
velocidad de la comunicación (en baudios), deberemos usar uno de los
siguientes valores: 300, 1200, 2400, 4800, 9600, 14400, 19200, 28800,
38400, 57600 o 115200; en la función `Serial.begin(value)`.\
\
Para enviar valores lo haremos mediante `Serial.print(value)` o
`Serial.print(value, format)`, el formato puede ser una de las
siguientes constantes: `DEC`, `HEX`, `OCT`, `BIN` o `BYTE`.

## Programas

### Sencillos

#### Botón que al pulsarse encienda un led

-   Necesitaremos el botón y un led.
-   Al botón conectaremos:
    -   El pin de tierra.
    -   Una conexión mediante una resistencia de 10k al pin de 5v.
-   Cuando el circuito está completo fluirá la corriente en el botón,
    para leer esta corriente conectaremos la pata del botón al pin
    digital 10.
-   El led, sino utilizamos el integrado en la placa, podremos colocarlo
    en el pin 13.

![](/arduino/ej01.png)

-   ![Ficheros](/arduino/ej01.rar)

``` c
int ledPin = 13;
int buttonPin = 10;

void setup() {
  pinMode(ledPin, OUTPUT);
  pinMode(buttonPin, INPUT);
}

void loop() {
  int val = digitalRead(buttonPin);
  if (val == 0)
    digitalWrite(ledPin, LOW);
  else
    digitalWrite(ledPin, HIGH);
}
```

## Programandolo con\...

### Processing

### C\\C++

## Otros
