# Recursos

Sobre como utilizar pequeños programas, IDE de desarrollo, pequeños
apuntes generales, \"*tips & tricks*\"\...

## Arquitecturas

-   Arquitectura de una web que sirve datos a tiempo real: ![Documento
    1](/code/tools/how_we_built_filmgrain_part_1_of_2_filmgrain_blog.pdf)
    y ![Documento
    2](/code/tools/how_we_built_filmgrain_part_2_of_2_filmgrain_blog.pdf).

## Comandos Linux

### make y los makefiles

El comando **make** mejora y configurar una compilación de varios
ficheros en C\\C++, y es que a diferencia del compilador tradicional
sólo recompila los ficheros de código fuente que han cambiado. Otra de
sus ventajas es que no es necesario utilizar una larga línea donde se
incluyan las librerías, las cabeceras y el código fuente para compilar,
lo que se hace es configurar un fichero llamado **makefile** y a partir
de ahí, cuando queramos compilar, llamar al **make**.\
\
El makefile es un archivo de texto común donde se definen las reglas
para el make utilizando el siguiente formato:

    # comentario
    destino: requisito
        comando

Los comentarios son, evidentemente, opcionales. El *destino* se refiere
al objeto a crear (un ejecutable, un fichero .o\...) o una tarea. El
*requisito* es el nombre del archivo (o archivos separados por espacios)
que se necesita para ejecutar el *comando*. En la línea de *comando* no
se utilizan espacios sino tabulaciones e indica el comando del shell a
ejecutar (en nuestro caso lo que nos concierne es el compilador), si el
comando nos ocupa más de una línea podemos indicar que sigue en la línea
siguiente mediante `\`, si queremos añadir más comandos podemos hacerlo
en una segunda línea.

    polaca: main.o stack.o getop.o getch.o
            gcc -o polaca main.o stack.o getop.o getch.o
    main.o: main.c calc.h
            gcc -c main.c
    stack.o: stack.c calc.h
            gcc -c stack.c
    getop.o: getop.c calc.h
            gcc -c getop.c
    getch.o: getch.c
            gcc -c getch.c
    clean:
            rm polaca \
                    main.o stack.o getop.o getch.o

El anterior ejemplo corresponde a un makefile el cual podemos ejecutar
haciendo **make**, **make polaca** y **make clean**. Cuando ejecutamos
el comando make sin seguirlo de nada escogerá un fichero makefile por
defecto, este deberá tener el nombre *makefile* (si queremos utilizar un
makefile con otro nombre añadiremos el parámetro `-f` y el nombre del
fichero), como tampoco estamos indicando el `destino` se ejecutará el
primero que encuentre, en este caso \"polaca\" (por lo que haría lo
mismo que ejecutar \"make polaca\"), en cambio, si indicamos destino
(como en make clean) se ejecutará el apartado del destino **clean**. Si
un comando necesita un fichero que no existe busca entre los demás
destinos, si coincide lo ejecuta.\
\
Puedes utilizar variables dentro del archivo, para ello las definirías
en la primera línea haciendo únicamente `nombreVariable = valor`. Luego,
para utilizarla, harías `$(NombreVariable)`. Ni que decir tiene que
distingue mayúsculas de minúsculas. En el ejemplo anterior podemos
definir el compilador y los objetos:

    CC = gcc
    OBJECTS = main.o stack.o getop.o getch.o
    polaca: $(OBJECTS)
            $(CC) -o polaca $(OBJECTS) 
    ...

Un makefile contiene reglas predefinidas como por ejemplos comandos de
compilación de C, de esa forma nos es innecesario indicar los .o, .c o
.h.

    CC = gcc
    OBJECTS = main.o stack.o getop.o getch.o

    polaca: $(OBJECTS)
            $(CC) -o polaca $(OBJECTS)
    clean :
            rm polaca $(OBJECTS)

Los ficheros .o son los que indican al make cuando se ha generado el
elemento, por lo tanto si los borramos el make recompilaría todo el
proyecto.

## Herramientas

### Repositorio de páginas

  Herramienta                              Uso                                           Lenguaje
  ---------------------------------------- --------------------------------------------- ------------
  [waf](/otros/waf)                        Sistema de construcción                       Python
  [Consola de Chrome](/otros/chromecons)   Intérprete de JavaScript                      JavaScript
  [Fabric](/otros/fabric)                  Herramienta para lanzar comandos vía Python   Python
  [Vagrant](/otros/vagrant)                Tool to create development environtments      \-
  [Factory Boy](/otros/factoryboy)         Fixtures replacement tools                    Python

### Documentando C++ con DoxyS

-   [DoxyS](http://www.doxys.dk/)
-   ![DoxyS 0.97](/code/tools/doxys_0_97_win_bin.zip)

DoxyS es una herramienta por consola de documentación de C\\C++.
Partiendo del código en este lenguaje genera un manual en formato html.\

-   Para generar el manual de DoxyS introduce `doxys -m`.
-   Para generar la documentación itnroduce `doxys` en el directorio
    raíz del código.

### Ant

Es una herramienta que ayuda en la automatización de la compilación de
código, creación de librerías y otras acciones que se requieren para la
creación del resultado de un proyecto Java.

#### Script de construcción

Un script de Ant se escribe en XML y se llama **build.xml**, describe
como construir un proyecto Java a partir de objetivos (*targets*) y
tareas (*tasks*). Un objetivo es una acción a realizar (compilar el
codigo, ejecutar los tests\...), una tarea es una acción concreta
(generar un jar\...). Tendrá una estructura parecida al siguiente:

``` xml
<?xml version="1.0" ?> 
<project name="tax-calculator" default="package"> 
  <target name="init"> 
    <mkdir dir="build/classes" />                       
    <mkdir dir="dist" />                                        
  </target> 
  <target name="compile" depends="init" description="Compile Java code"> 
    <javac srcdir="src" destdir="build/classes"/> 
  </target> 
  <target name="package" depends="compile" description="Generate JAR file">                                                 
    <jar destfile="dist/tax-calculator.jar" basedir="build/classes"/> 
  </target> 
  <target name="clean" description="Deletes generated directories"> 
    <delete dir="build" /> 
    <delete dir="dist" /> 
  </target> 
</project> 
```

La rama principal es la llamada **project**, esta contiene todos los
targets, podemos encontrar las propiedades **name** (que define el
nombre) o **default** (que define la target por defecto que se
ejecutará). Los targets tienen un nombre (definido por **name**) y, si
necesitan que otro target se realice antes, dependencias a este
(mediante la propiedad **depends**); la **description** no es más que
una descripción de lo que hace el target.

#### Ejecutar Ant

Si no estamos utilizando un IDE de desarrollo de Java y queremos
ejecutar el script Ant por consola tendremos que echar mano del comando
**ant** de la siguiente forma:

-   `ant clean`: Ejecuta el target clean.
-   `ant clean compile`: Ejecutará el target clean y luego el compile.
-   `ant -f x.xml`: Utilizará el fichero x.xml en vez el build.xml.

#### Tareas

Dentro de los targets podemos encontrar las tareas las cuales son:

-   **mkdir** crea un arbol de directorios definido por *dir*.
-   **javac** compila el código que se encuentra en *srcdir* y las
    clases resultado las coloca en *destdir*.
-   **jar** coge clases compiladas en java en *basedir* y genera un
    archivo .jar en la ruta indicada por *destfile*. (Tiene otras que lo
    hacen más potente)
-   **delete** elimina el directorio *dir*.
-   **javadoc** genera la documentación.
-   **echo** muestra por pantalla el texto de la propiedad *message*.

Existen otras definiciones de tareas para mover\\copiar ficheros como
**copy** que copia un fichero *file* al directorio *todir*. También
existen **ftp** y **scp** (secure copy).\
Otras serían para la configuración de la aplicación, con acciones como
coger elementos (**get**), **unzip** o **available**.

#### Definir el classpath

Para indicar el archivo correspondiente a una librería utilizaremos una
tarea parecida a esta:
`<path id="junit.classpath" location="lib/junit.jar"/>`\
Si quisieramos indicar una ruta donde estubiesen varios archivos .jar
usaremos las siguientes líneas:

``` xml
<path id="compile.classpath">     
  <fileset dir="lib" includes="*.jar" /> 
</path>
```

Para usar este classpath con la tarea **javac** utilizaremos la
propiedad *classpathref*:

``` xml
<target name="compile" depends="init" description="Compile Java code"> 
  <javac srcdir="src"  
         destdir="build/classes" 
         classpathref="compile.classpath" /> 
</target>
```

Aunque también podemos incrustarlo dentro de la tarea:

``` xml
<target name="compile" depends="init" description="Compile Java code"> 
  <javac srcdir="src" destdir="build/classes"> 
    <classpath> 
       <fileset dir="lib" includes="*.jar"/> 
    </classpath>        
  </javac> 
</target>
```

#### Configuración del script

Podemos definir valores para el script en unos elementos llamados
propiedades. Por ejemplo podríamos definir un directorio, dándole como
identificador *build.dir*, de la siguiente forma:

``` xml
<property name="build.dir" location="build"/>
```

Y luego accederíamos al valor de *build.dir* haciendo `${build.dir}` ,
es decir, haciendo `${identificador de la propiedad}`:

``` xml
<target name="display-properties">
  <echo>Build directory : ${build.dir}</echo> 
</target>
```

Podemos mostrar todas las propiedades definidas haciendo
`<echoproperties />`.\
Ant tiene predefinidas las siguientes propiedades: *\${basedir}*,
*\${java.home}*, *\${java.version}*, y *\${user.home}*. Otra cosa que
podemos hacer es definir las propiedades en un fichero distinto:

``` xml
<property file="${user.home}/ant-global.properties"/><property file="${basedir}/local.properties"/>
```

### Compiladores de C

#### gcc y g++

-   [Compiladores Linux.](/highlevel/c/clinux#gcc_y_g)

#### Dev-C++

-   Probablemente, si utilizas este editor y necesites usar librerías
    externas (OpenGL, DirectX\...) tendrás que buscar el DevPak
    adecuado. Existe un repositorio en <http://devpaks.org>.
-   Cuando instales un repositorio, por ejemplo el de DirectX, se te
    añadirán al directorio lib ficheros .a, estos son librerías
    estáticas con nombre del estilo libxxx.a. Para linkarlas al proyecto
    tendremos que añadir ese \'xxx\', no todo el nombre del archivo; por
    ejemplo, para añadir `libddraw.a` añadiremos al linker `-lddraw`.

### Herramientas para C

-   Un detector de memory leaks es `valgrind`. Existen GUIs tales como
    `Alleyoop` o `valkyrie`.
-   `gProf` es un analizador de código.

### cURL

Es una herramienta de consola para utilizar protocolos que permitan
sintaxis URL (FTP, FTPS, LDAP, HTTP\...). Es una buena herramienta para
simular acciones sobre el navegador web, además existe `libcurl`, una
API que permite arreglar cURL a desarrollos.

#### Descargar contenido de una URL

    curl url

#### Enviar parámetros POST

    curl -X POST -d "param1=value1&param2=value2" http://127.0.0.1:8080/group/

#### Enviar DELETE

    curl -X DELETE http://127.0.0.1:5000/servers/1

### SSH

El comando `ssh` es usado para acceder remotamente a una consola Linux.

-   `ssh 192.168.1.100` - Accede al host 192.168.1.100 con el usuario
    actualmente validado.
-   `ssh 192.168.1.100 -l root` - Accede al host 192.168.1.100 con el
    usuario indicado (root).

Existen servidores de ssh que podemos instalar en nuestras máquinas,
como por ejemplo: *dropbear* para pequeños dispositivos o el
*openssh-server*.\
Podemos montar dispositivos remotos con el protocolo `sftp`.

#### Claves

Podemos conectar a un host remoto mediante un archivo clave .pem:

    $ ssh -i skey.pem ubuntu@ec2-54-218-73-84.us-west-2.compute.amazonaws.com

#### Configuración

Aunque también podríamos añadir esta clave al archivo de configuración
de ssh y acceder mediante un alias:

    $ cd ~/.ssh
    $ cp skey.pem ~/.ssh/
    $ chmod 400 ~/.ssh/skey.pem
    $ chmod 700 ~/.ssh
    $ gedit ~/.ssh/config

Esto sería su contenido:

    Host awshost1
    HostName ec2-54-218-35-71.us-west-2.compute.amazonaws.com
    User ubuntu
    IdentityFile "~/.ssh/skey.pem"

Y así su conexión:

    $ ssh awshost1

#### Copia de archivos

## Visual Studio

### Tips creando bibliotecas

#### C++

-   Cuando estés generando una biblioteca, lo mejor para probarla es
    indicar que el directorio del compilado resultante es la misma ruta
    que el directorio del ejecutable con el que la probarás, es
    recomendable que esta ruta sea relativa. *(botón derecho sobre el
    proyecto -\> Propiedades -\> General -\> Directorio de resultados)*
-   Al crear el proyecto con el que probarás la librería, si lo haces en
    la misma solución de Visual Studio que esta, puedes indicar que el
    proyecto el programa depende del proyecto de la librería haciendo
    *click derecho sobre el proyecto -\> Dependencias del proyecto*.
-   Se aconseja cambiar el nombre de las .dll correspondiente a la
    versión release y a la debug (por ejemplo llamarlas library.dll y
    library_d.dll respectivamente), y es que parece ser son
    incompatibles y según como sean usadas pueden crear errores
    indeseados. Para ello se ha de ir a las propiedades del proyecto y
    seleccionar a quien quieres aplicar la configuración y en
    *Vinculador -\> General -\> Archivo de resuldados* cambiarlo.
-   Puedes hacer un `#define DLLIMPORT _declspec(dllimport)` de esa
    forma harás el código más legible y no sólo eso, puedes hacer un
    define distinto para la cabecera de la librería o para la del
    programa, por ejemplo, en MSVC++ se define para el preprocesador
    `_USRDLL` cuando se trabaja con un proyecto que compila una dll y
    eso puede usarse para crear una cabecera válida para un proyecto dll
    o para un proyecto ejecutable.

``` cpp
#ifdef _USRDLL 
#define DECLSPEC _declspec(dllexport)
#else
#define DECLSPEC _declspec(dllimport)
#endif

DECLSPEC int suma (int);
```

-   Para vincular una librería estática (fichero .lib) se hace desde las
    *Propiedades del proyecto -\> Vinculado -\> Entrada -\> Dependencias
    adicionales*. Se ha de agregar ahí su nombre.

### Tips & tricks (C++)

-   En nuestro código podemos saber si se ha compilado en modo debug si
    se ha hecho un #define de `_DEBUG`.

``` cpp
#if defined _DEBUG
    std::cout << "Compilado en modo debug";
#endif
```

-   Podemos escribir en la ventana de salida (output window) utilizando
    la función `OutputDebugString (string)`, recuerda incluir
    `windows.h`.
-   Puedes cambiar los define por defecto de un proyecto en las
    propiedades de este *C++ -\> Preprocesador -\> Definiciones*.
-   Si quieres utilizar archivos .h que estén en otro directorio y no
    quieres compilarlos sólo has de añadir dicho directorio a tu
    proyecto como directorio de inclusiones desde //Propiedades del
    proyecto -\> C++ -\> General -\> Directorios de inclusión
    adicionales *. \* Si tienes un error de conversión de char a LPCWSTR
    puedes hacer dos cosas: - Convertir el string MultiByte utilizando
    `MultiByteToWideChar`. - Cambiar en las propiedades del proyecto que
    los strings sean MultiByte (*propiedades -\> General -\> Juego de
    carácteres//).
-   Si programas con una versión superior a 2003\...
    -   \... Para que los usuarios de tus programas puedan ejecutarlos
        tendrás que compilarlos en modo release.
    -   \... Puedes tener problemas de linkaje de librerías si estas han
        sido compiladas con versiones anteriores. Trata de conseguir el
        codigo fuente y compilarlas con tu versión.

## IIS

-   `iisreset` es un comando de consola que reinicia el IIS.

```{=html}
<!-- -->
```
-   En el IIS que viene con Windows XP Pro (v.5.1) sólo podemos tener un
    site activo.

### adsutil

`adsutil.vbs` es un script bastante útil que se encuentra en
`c:\inetpub\adminscripts` y que admite una serie de parámetros, a partir
de los cuales puedes realizar la configuración de los sitios web (que no
directorios virtuales) dentro de un IIS.\
Para llevar a cabo acciones con este script es necesario conocer el
identificador del sitio web con el que quieras trabajar.
![Aquí](/code/tools/listwebsiteid.zip) tienes un script que va indicando
pares de sitio web\\identificador que tienes en la máquina actualmente.\
El `adsutil.vbs` ha de ejecutarse con el `cscript.exe`.

#### Enumerar las propiedades de un sitio web

    dsutil.vbs  enum w3svc/WebsiteId

Siendo el WebsiteId un número identificador que corresponda al id del
site sobre el que queramos ver su info.

#### Acciones sobre sitios web

-   **Crear** el site 2: `cscript adsutil.vbs CREATE W3SVC/2`
-   **Eliminar** el site 2: `cscript adsutil.vbs DELETE W3SVC/2`
-   **Copiar** el site 1 en el site 2 (aún no existente):
    `cscript adsutil.vbs COPY W3SVC/1 W3SVC/2`

#### Configurar el ServerBindings y el SecureBindings de un sitio web

Para que las aplicaciones dinámicas que ejecutes sobre IIS generen
automática y correctamente las url será necesario configurar los
ServerBindings (rutas por las que puede ser accedida nuestra
aplicación). Es decir, sin configurar pueden aparecernos como
`http://local/site` cuando lo que queremos es que nos aparezcan como
`http://internet/site`.\
\
Para configurar estos elementos usaremos el parámetro `set` del
`adsutil.vbs` seguido de `/w3svc/WebsiteId/elemento` (siendo el
WebsiteId el número identificador del site y el elemento ServerBindings
o SecureBindings) y luego la dirección que queramos definir en el
siguiente formato: `":puerto:ruta"`. Si quisieramos configurarlo como
inicialmente estaba haríamos: `:80:`.

    adsutil.vbs set /w3svc/WebsiteId/ServerBindings ":80:www.example.com"
    adsutil.vbs set /w3svc/WebsiteId/SecureBindings ":443:www.example.com"

Si quisiesemos agregar una lista de sitios:

    adsutil.vbs set /w3svc/WebsiteId/ServerBindings ":80:www.example.com" ":81:www.example2.com"

Una vez definidos estos parámetros reiniciaremos el server con el
comando `iisreset`.

### Activar SSL

#### A partir de un certificado ya creado

En *IIS 5.1*. Teniendo algún certificado existente en nuestra máquina
podemos hacer botón derecho sobre el sitio web, ir a las propiedades y
luego a la pestaña *Seguridad de directorios*, en el apartado
*Conexiones seguras* se nos dan opciones que nos permite escoger el
certificado que queramos y, a partir de ahí activar SSL en nuestras webs
(siempre desde la pestaña *Seguridad de directorios*).

### .NET e IIS

-   Para restaurar o reinstalar ASP.NET ejecutaremos `aspnet_regiis -i`
    (que está en *C:\\WINDOWS\\Microsoft.NET\\Framework\\vXXXX*).

#### Ejecutar una aplicación ASP.NET con un usuario concreto

Las aplicaciones web que son solicitadas al IIS son ejecutadas por el
usuario ASPNET que se instala en el sistema cuando instalamos el
framework. Si en algún momento nos interesase que sea otro usuario quien
lance estas aplicaciones lo que haremos será:

1.  Crear al usuario en concreto en el sistema operativo donde se
    encuentra el IIS.
2.  Dar a ese usuario permisos para acceder a las referencias de ASP.NET
    mediante el comando: `aspnet_regiis -ga MachineName\AccountName`
3.  En el IIS\...
    -   5.1 ir a las propiedades de la aplicación\\web en cuestión, a la
        pestaña *ASP.NET*, editar configuración, pestaña aplicación y
        allí editar la *Suplantación local*.

#### Problemas con WCF

-   Para problemas específicos con WCF ver: [WCF en IIS](/sp/wcf#iis)

## Eclipse

### Tips & Tricks

#### Java

-   Podemos ejecutar targets de Ant desde la vista *Outline*.

#### Python (PyDev)

-   `ctrl + alt + enter`: Abre una consola interactiva.

### Plugins

-   [Pydev](http://pydev.sourceforge.net): Plugin para el desarrollo en
    [Python](/script/python).
-   [CDT](http://www.eclipse.org/cdt): Plugin para el desarrollo en
    C\\C++.
-   [Green UML](http://green.sourceforge.net): Plugin para el diseño
    automático UML.
-   [Omondo](http://www.eclipsedownload.com): Plugin para el diseño
    automático UML.
-   [EPIC](http://e-p-i-c.sourceforge.net): Plugin para el desarrollo en
    [Perl](/script/perl).
-   [Subclipse](http://subclipse.tigris.org): Plugin para añadir la
    posivilidad de utilizar Subversion.
