# Data Mining

Algoritmos y metodología para la explotación de datos.

## El preproceso

Cuando iniciamos un trabajo debemos preprocesar los datos de los que
disponemos, esto es adaptarlos para poder tratarlos.

### Tratamiento de individuos

#### Outlayers

Son individuos con valores atípicos, acostumbran a mover la media y son
un problema de difícil solución.

#### Individuos a los que le falten valores

Cuando un individuo tiene una variable sin valor podemos buscar otro
individuo, el más cercano a él (mediante distancia euclídea, por
ejemplo), y asignarle el mismo valor.

### Tratamiento de variables

#### Feature selection

Consiste en deducir qué variables (características, campos\...) son más
importantes.\
Se busca el grado de relación de las variables con la variable de
respuesta (o de salida, es la variable que queremos deducir o que
estamos estudiando).\
Para saber si una variable está relacionada con otra mediante el
[p-valor](/ai/datos#p-valor) o el [coeficiente de
correlación](/ai/datos#coeficiente_de_correlacion).

#### Feature extraction

Es la creación de nuevas variables a partir de las originales que pueden
servir más que estas. Por ejemplo si te dan una imágen con un dígito,
realmente lo que te están dando es un conjunto de píxels del cual poco
se puede deducir, convendría más extraer información de esos píxels
buscando la verticalidad de la imágen, los agujeros que tiene\...

#### Notas

-   Una variable, mientas más falte los individuos menos fiable será.

## Modelos de regresión

### Regresión Lineal

La regresión lineal modeliza la relación entre una variable dependiente
`Y`, las variables independientes `Xi` y un término aleatorio ε, y puede
ser expresado de la siguiente forma:\
\<m\>Y = beta_0 X_0 + beta_1 X_1 + \... + beta_i X_i + varepsilon\</m\>\
Donde β son los parámetros respectivos a cada variable independiente, e
`i` es el número de parámetros independientes a tener en cuenta en la
regresión.\
![](/ai/data_mining/linear_regression.png)\
Es decir, a partir de una distribución bidimensional podemos estudiar la
influencia existente entre dos variables (causa-efecto). Un ejemplo
sería la relación entre la cantidad de lluvia y la producción agrícola,
entre el aumento de precio y la demanda de un producto\... Para ello, a
partir de una representación gráfica en un sistema de coordenadas
encontraremos un \"diagrama de dispersión\", será regresión lineal
cuando la función es lineal (pendiente y ordenada (y = ax + b)), la
recta del gráfico resultante será la **recta de regresión**. Esto nos
permite, además, predecir un valor para una x que no esté en la
distribución.

### Regresión logística

Para modelar la probabilidad de un evento que ocurre en función de otros
factores. Usa la función logit.

## Reglas de asociación

Las reglas de asociación buscan relaciones del estilo \"*si ocurre X
entonces también ocurre Y*\", siendo X e Y conjuntos de valores de
variables. El ejemplo más sencillo es es el de la cesta de la compra de
un supermercado, en este se busca qué productos generalmente se compran
a la vez. Por ejemplo si se compran patatas fritas y olivas es muy
probable que también se compre coca cola o cerveza, por lo que
conociendo estos el super puede ofrecer packs o hacer una reorganización
de los productos. Otras aplicaciones pueden ser transacciones bancarias,
seguros, soporte de clientes\...\
\

Las reglas de asociación no tratan de comprovar hipótesis como hacen las
pruebas de hipótesis estadísticas, su objetivo es el de descubrirlas.\
Los **episodios frecuentes** son las ocurrencias de un evento que
queremos estudiar, por ejemplo en la cesta de la compra, el evento es
una compra de varios productos. Para representarlos se utilizan
combinaciones de valores binarios, esto es usar 0 o 1 cuando en el
evento hay una ausencia o presencia de los episodios. Es decir, debemos
binarizar la base de datos para poder aplicar los métodos que extraen
las reglas.\
\

Una regla de asociación se representa de la siguiente forma: `X ⇒ Y`\
Esto significa que cuando en el episodio frecuente un elemento o grupo
de elementos X (**antecedente**) también se da un elemento o grupo de
elementos Y (**consecuente**).

Una regla será válida sólo si supera un **soporte** y una **confianza**
mínimos. El soporte corresponde a la frecuencia de la regla y la
confianza a su fortaleza y se definen (siendo `D` la proporción de
elementos que contiene dicho conjunto):\
\
![](/ai/md/soporte_confianza.png){.align-center}\

Existe también el concepto de **lift** (elevación) que se puede
interpretar como la importancia de una regla, pero de forma diferente a
lo que ocurre con el soporte y la confianza no existe un lift mínimo, su
valor viene de la proporción de fiabilidad de la norma y de la
fiabilidad esperada de la norma. Un valor de lift = 1 indica que ese
conjunto aparece una cantidad de veces acorde a lo esperado. Un valor de
lift \> 1 indica que ese conjunto aparece una cantidad de veces superior
a lo esperado (por lo que los productos se encuentran más veces de lo
normal). Un valor de lift \< 1 indica que ese conjunto aparece una
cantidad de veces inferior a lo esperado (por lo que se puede intuir que
los productos no estan formando parte del mismo conjunto más veces de lo
normal).

### Algoritmos

Existen distintos algoritmos para extraer reglas de asociación, a
destacar el `apriori` y el de `Agrawal`.

### Ejemplos

#### Ejemplo 1

![](/ai/md/md-table1.png){width="450"}\
En esta tabla de 10 elementos, 5 registros marcan \'Tarda\'; 5
\'Act1-TBC\'; 5 \'Tarda\' y \'Act1-TBC\'; 9 \'No Entrenador\'; 9
\'Piscina\'; 8 \'No Entrenador\' y \'Piscina\'; 5 \'Tarda\' y \'No
Entrenador\'; 5 \'Tarda\', \'Act1-TBC\' y \'No Entrenador\'; 4
\'Tarda\', \'Act1-TBC\', \'Piscina\' y \'No Entrenador\'.

-   La regla `{Tarda, Act1-TBC} ⇒ {No entrenador personal, piscina}`
    tiene una confianza del 80% \<m\>(4/5)\</m\> y un soporte del 40%.
-   La regla `{Tarda, Atc1-TBC} ⇒ {No entrenador persona}` tiene una
    confianza del 100% \<m\>(5/5)\</m\> y un soporte del 50%.
-   La regla `{Tarda} ⇒ {No entrenador personal}` tiene una confianza
    del 100% y un soporte del 70%.

#### Cálculo de reglas de asociación con R

En la librería `arules` encontramos las siguientes funciones:

-   `as(X, "transactions")`, binariza un dataset.
-   `apriori` extrae reglas de asociación de un dataset binarizado,
    podemos indicar el soporte y la confianza mínimos.
-   `inspect` muestra el contenido de las reglas.
-   `subset` filtra reglas.

```{=html}
<!-- -->
```
    library (arules)
    cat_transac <- as(datos_categorias, "transactions")
    rules = apriori (cat_transac, parameter = list (support=0.2, confidence=0.6))
    myrules = SORT(rules, by = "lift")[1:5]
    inspect(myrules)
    myrules.sub = subset(rules, subset = rhs %in% "preferred_brand=Delta")
    inspect (myrules.sub)

## Notas
