from flask import Flask, render_template
from flask_sse import sse


app = Flask(__name__)
app.config["REDIS_URL"] = "redis://localhost"
app.register_blueprint(sse, url_prefix='/stream')


@app.route("/")
def hello():
    return render_template('index.html')


@app.route("/send")
def events():
    sse.publish({"message": "Hello!"}, type='greeting')
    return "Message sent!"
