//
//  shaders.h
//  FreeVRPlayer
//
//  Created by alfred visyon on 23/11/15.
//  Copyright © 2015 Visyon. All rights reserved.
//

#ifndef shaders_h
#define shaders_h

#define STRINGIFY(A)  #A

const char* vertexShaderSource = STRINGIFY(
                                     attribute vec4 position;
                                     uniform mat4 modelViewProjectionMatrix;
                                     attribute vec2 texCoord;
                                     varying vec2 v_textureCoordinate;
                                     void main() {
                                         gl_Position = modelViewProjectionMatrix * position;
                                         v_textureCoordinate = texCoord;
                                     }
);

const char* fragmentShaderSimpleSource = STRINGIFY(
                                               precision mediump float;
                                               uniform sampler2D SamplerY;
                                               varying mediump vec2 v_textureCoordinate;
                                               void main() {
                                                   gl_FragColor = texture2D(SamplerY, v_textureCoordinate);

                                               }
);

#endif /* shaders_h */
